# 🎭 Painel Administrativo Allure

Este é o painel administrativo completo para gerenciar o site Allure, focado no gerenciamento das modelos.

## 🚀 Como Acessar

### 1. Criar Superusuário

Primeiro, você precisa criar um usuário administrador:

```bash
# Opção 1: Usando o script personalizado
cd allure_project
python create_admin.py create

# Opção 2: Usando o comando Django padrão
python manage.py createsuperuser
```

### 2. Iniciar o Servidor

```bash
cd allure_project
python manage.py runserver
```

### 3. Acessar o Painel

Abra seu navegador e acesse:
```
http://localhost:8000/admin/
```

## 📊 Funcionalidades do Painel

### 🎯 Gerenciamento de Modelos

#### Lista de Modelos
- **Visualização completa**: Nome, idade, localização, status, premium, boost
- **Filtros avançados**: Por status, categoria, etnia, estado, etc.
- **Busca**: Por nome, email, cidade, estado
- **Ordenação**: Por data de cadastro, nome, etc.

#### Ações em Lote
- ✅ **Aprovar modelos**: Muda status para "aprovado"
- ❌ **Rejeitar modelos**: Muda status para "rejeitado"
- ⏸️ **Suspender modelos**: Muda status para "suspenso"
- ⭐ **Ativar/Desativar Premium**: Controla status premium
- 🚀 **Ativar/Desativar Boost**: Controla boost por 7 dias

#### Detalhes da Modelo
- **Informações básicas**: Nome, idade, descrição
- **Localização**: Estado e cidade
- **Características físicas**: Etnia, altura, peso
- **Informações profissionais**: Categoria, tipo de ensaio, local de atendimento
- **Contatos**: Telefone, WhatsApp, email
- **Fotos e documentos**: Upload e visualização
- **Status e controle**: Status, premium, boost
- **Estatísticas**: Visualizações, boost status

### 📸 Gerenciamento de Fotos

- **Upload de fotos**: Por categoria (galeria, seios, frente, bumbum, rosto)
- **Ordenação**: Controle da ordem das fotos
- **Preview**: Visualização das imagens
- **Filtros**: Por categoria, modelo, data

### 💰 Gerenciamento de Serviços

- **Cadastro de serviços**: Descrição, preço, duração
- **Ativação/Desativação**: Controle de serviços ativos
- **Associação**: Cada serviço vinculado a uma modelo

### 📈 Estatísticas e Analytics

- **Visualizações**: Controle de visualizações por modelo
- **Favoritos**: Usuários que favoritaram cada modelo
- **Boost**: Pagamentos e status de boost

### 💳 Pagamentos de Boost

- **Aprovação de pagamentos**: Aprovar e ativar boost automaticamente
- **Rejeição**: Rejeitar pagamentos pendentes
- **Controle**: Status, valores, durações

## 🎨 Interface Personalizada

### Dashboard
- **Cards de estatísticas**: Total de modelos, pendentes, aprovadas, premium
- **Ações rápidas**: Links diretos para funções principais
- **Visual moderno**: Design responsivo e intuitivo

### Status Badges
- 🟡 **Pendente**: Aguardando aprovação
- 🟢 **Aprovado**: Ativa no site
- 🔴 **Rejeitado**: Não aprovada
- 🟣 **Suspenso**: Temporariamente suspensa

### Boost Status
- 🟢 **Ativo**: Boost funcionando até data específica
- 🔴 **Expirado**: Boost vencido
- ⚪ **Não ativo**: Sem boost

## 🔧 Comandos Úteis

### Script de Administração

```bash
# Criar superusuário
python create_admin.py create

# Listar usuários
python create_admin.py list

# Abrir shell Django
python create_admin.py shell
```

### Comandos Django

```bash
# Criar migrações
python manage.py makemigrations

# Aplicar migrações
python manage.py migrate

# Coletar arquivos estáticos
python manage.py collectstatic

# Shell Django
python manage.py shell
```

## 📱 Responsividade

O painel é totalmente responsivo e funciona em:
- 💻 Desktop
- 📱 Tablet
- 📱 Mobile

## 🔒 Segurança

- **Autenticação obrigatória**: Acesso restrito a usuários admin
- **Permissões**: Controle granular de permissões
- **Logs**: Registro de todas as ações administrativas

## 🎯 Fluxo de Trabalho Recomendado

### 1. Aprovação de Modelos
1. Acesse "Modelos" no painel
2. Filtre por status "Pendente"
3. Revise as informações da modelo
4. Use ação em lote "Aprovar modelos selecionadas"

### 2. Gerenciamento de Premium
1. Selecione modelos para tornar premium
2. Use ação "Ativar premium para modelos selecionadas"
3. Monitore no filtro "Premium"

### 3. Controle de Boost
1. Acesse "Pagamentos de Boost"
2. Filtre por status "Pendente"
3. Aprove ou rejeite pagamentos
4. Monitore boost ativo nas modelos

### 4. Upload de Fotos
1. Acesse uma modelo específica
2. Vá para a seção "Fotos da modelo"
3. Adicione fotos por categoria
4. Organize a ordem das fotos

## 🆘 Suporte

Para dúvidas ou problemas:
1. Verifique os logs do Django
2. Consulte a documentação do Django Admin
3. Entre em contato com o desenvolvedor

---

**Desenvolvido para Allure** 🎭 