"""
Registro de modelos no AdminSite personalizado do Allure
"""
from django.contrib.auth.models import User
from django.contrib.auth.admin import UserAdmin
from .admin_site import admin_site
from models.admin import (
    ModeloAdmin, BannerAdmin, FotoModeloAdmin, FotoAprovacaoAdmin, ServicoAdmin,
    VisualizacaoModeloAdmin, FavoritoAdmin, CategoriaAdmin,
    AvaliacaoAdmin, ComentarioAdmin, VideoModeloAdmin, PlanoAnuncioAdmin
)
from payments.admin import (
    TransacaoPagamentoAdmin, WebhookLogAdmin, ConfiguracaoPagamentoAdmin, PlanoAnuncioPagamentoAdmin,
    VoucherAdmin, VoucherUsoAdmin
)
# Importar admin do communication
from communication.admin import (
    EmailTemplateAdmin, EmailLogAdmin, EmailTriggerAdmin, EmailQueueAdmin
)
from models.models import (
    Modelo, Banner, FotoModelo, FotoAprovacao, Servico, VisualizacaoModelo,
    Favorito, Categoria, Avaliacao, Comentario, VideoModelo, PlanoAnuncio
)
from payments.models import (
    TransacaoPagamento, WebhookLog, ConfiguracaoPagamento, PlanoAnuncioPagamento, Voucher, VoucherUso
)
from communication.models import (
    EmailTemplate, EmailLog, EmailTrigger, EmailQueue
)

# Admin personalizado para User
class AllureUserAdmin(UserAdmin):
    list_display = ('username', 'email', 'first_name', 'last_name', 'is_active', 'is_staff', 'date_joined', 'modelo_relacionado')
    list_filter = ('is_active', 'is_staff', 'is_superuser', 'date_joined', 'groups')
    search_fields = ('username', 'first_name', 'last_name', 'email')
    ordering = ('-date_joined',)
    
    fieldsets = (
        (None, {'fields': ('username', 'password')}),
        ('Informações Pessoais', {'fields': ('first_name', 'last_name', 'email')}),
        ('Permissões', {
            'fields': ('is_active', 'is_staff', 'is_superuser', 'groups', 'user_permissions'),
        }),
        ('Datas Importantes', {'fields': ('last_login', 'date_joined')}),
    )
    
    add_fieldsets = (
        (None, {
            'classes': ('wide',),
            'fields': ('username', 'email', 'password1', 'password2'),
        }),
    )
    
    def modelo_relacionado(self, obj):
        """Mostra se o usuário tem um modelo relacionado"""
        try:
            modelo = Modelo.objects.get(user=obj)
            return f"✅ {modelo.nome_exibicao or modelo.nome}"
        except Modelo.DoesNotExist:
            return "❌ Sem modelo"
    
    modelo_relacionado.short_description = 'Modelo Relacionado'
    modelo_relacionado.admin_order_field = 'modelo__nome_exibicao'

# Registrar modelos do app models
admin_site.register(Modelo, ModeloAdmin)
admin_site.register(Banner, BannerAdmin)
admin_site.register(FotoModelo, FotoModeloAdmin)
admin_site.register(FotoAprovacao, FotoAprovacaoAdmin)
admin_site.register(Servico, ServicoAdmin)
admin_site.register(VisualizacaoModelo, VisualizacaoModeloAdmin)
admin_site.register(Favorito, FavoritoAdmin)
admin_site.register(Categoria, CategoriaAdmin)
admin_site.register(Avaliacao, AvaliacaoAdmin)
admin_site.register(Comentario, ComentarioAdmin)
admin_site.register(VideoModelo, VideoModeloAdmin)
admin_site.register(PlanoAnuncio, PlanoAnuncioAdmin)

# Registrar modelos do app payments
admin_site.register(TransacaoPagamento, TransacaoPagamentoAdmin)
admin_site.register(WebhookLog, WebhookLogAdmin)
admin_site.register(ConfiguracaoPagamento, ConfiguracaoPagamentoAdmin)
admin_site.register(PlanoAnuncioPagamento, PlanoAnuncioPagamentoAdmin)
admin_site.register(Voucher, VoucherAdmin)
admin_site.register(VoucherUso, VoucherUsoAdmin)

# Registrar modelos do app communication
admin_site.register(EmailTemplate, EmailTemplateAdmin)
admin_site.register(EmailLog, EmailLogAdmin)
admin_site.register(EmailTrigger, EmailTriggerAdmin)
admin_site.register(EmailQueue, EmailQueueAdmin)

# Registrar o modelo User padrão do Django
admin_site.register(User, AllureUserAdmin) 