# Generated by Django 5.2.4 on 2025-09-14 10:54

import django.core.validators
import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("models", "0012_auto_20250902_1739"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="EmailTemplate",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "nome",
                    models.CharField(
                        help_text="Nome identificador do template",
                        max_length=100,
                        validators=[django.core.validators.MinLengthValidator(3)],
                    ),
                ),
                (
                    "tipo",
                    models.CharField(
                        choices=[
                            ("cadastro_sucesso", "Cadastro Realizado com Sucesso"),
                            ("perfil_aprovado", "Perfil Aprovado"),
                            ("perfil_rejeitado", "Perfil Rejeitado"),
                            ("pagamento_aprovado", "Pagamento Aprovado"),
                            ("pagamento_pendente", "Pagamento Pendente"),
                            ("pagamento_falhou", "Pagamento Falhou"),
                            ("plano_ativado", "Plano Ativado"),
                            ("plano_expirando", "Plano Expirando em Breve"),
                            ("plano_expirado", "Plano Expirado"),
                            ("boost_ativado", "Boost Ativado"),
                            ("boost_expirado", "Boost Expirado"),
                            ("premium_ativado", "Premium Ativado"),
                            ("premium_expirado", "Premium Expirado"),
                            ("recuperacao_senha", "Recuperação de Senha"),
                            ("contato_cliente", "Mensagem de Cliente"),
                            ("bem_vindo", "Bem-vindo ao Allure"),
                            ("promocao", "Promoção Especial"),
                            ("newsletter", "Newsletter"),
                            ("custom", "Personalizado"),
                        ],
                        help_text="Tipo de notificação",
                        max_length=50,
                        unique=True,
                    ),
                ),
                (
                    "assunto",
                    models.CharField(
                        help_text="Assunto do email (pode usar variáveis como {{nome}})",
                        max_length=200,
                    ),
                ),
                (
                    "conteudo_html",
                    models.TextField(
                        help_text="Conteúdo HTML do email (pode usar variáveis como {{nome}})"
                    ),
                ),
                (
                    "conteudo_texto",
                    models.TextField(
                        blank=True, help_text="Conteúdo em texto simples (opcional)"
                    ),
                ),
                (
                    "ativo",
                    models.BooleanField(
                        default=True, help_text="Se o template está ativo para uso"
                    ),
                ),
                (
                    "variaveis_disponiveis",
                    models.JSONField(
                        blank=True,
                        default=list,
                        help_text="Lista de variáveis disponíveis para este template",
                    ),
                ),
                ("data_criacao", models.DateTimeField(auto_now_add=True)),
                ("data_atualizacao", models.DateTimeField(auto_now=True)),
                (
                    "criado_por",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="templates_criados",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Template de Email",
                "verbose_name_plural": "Templates de Email",
                "ordering": ["tipo", "nome"],
            },
        ),
        migrations.CreateModel(
            name="EmailTrigger",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("nome", models.CharField(max_length=100)),
                (
                    "evento",
                    models.CharField(
                        choices=[
                            ("modelo_cadastrado", "Modelo Cadastrado"),
                            ("modelo_aprovado", "Modelo Aprovado"),
                            ("modelo_rejeitado", "Modelo Rejeitado"),
                            ("pagamento_criado", "Pagamento Criado"),
                            ("pagamento_aprovado", "Pagamento Aprovado"),
                            ("pagamento_falhou", "Pagamento Falhou"),
                            ("plano_ativado", "Plano Ativado"),
                            ("plano_expira_em_7_dias", "Plano Expira em 7 Dias"),
                            ("plano_expira_em_3_dias", "Plano Expira em 3 Dias"),
                            ("plano_expirado", "Plano Expirado"),
                            ("boost_ativado", "Boost Ativado"),
                            ("boost_expirado", "Boost Expirado"),
                            ("premium_ativado", "Premium Ativado"),
                            ("premium_expirado", "Premium Expirado"),
                            ("senha_redefinida", "Senha Redefinida"),
                            ("contato_recebido", "Contato Recebido"),
                        ],
                        max_length=50,
                        unique=True,
                    ),
                ),
                ("ativo", models.BooleanField(default=True)),
                (
                    "delay_minutos",
                    models.PositiveIntegerField(
                        default=0,
                        help_text="Delay em minutos antes do envio (0 = imediato)",
                    ),
                ),
                (
                    "condicoes",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        help_text="Condições adicionais para o envio (ex: status específico)",
                    ),
                ),
                ("data_criacao", models.DateTimeField(auto_now_add=True)),
                ("data_atualizacao", models.DateTimeField(auto_now=True)),
                (
                    "template",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="triggers",
                        to="communication.emailtemplate",
                    ),
                ),
            ],
            options={
                "verbose_name": "Gatilho de Email",
                "verbose_name_plural": "Gatilhos de Email",
                "ordering": ["evento"],
            },
        ),
        migrations.CreateModel(
            name="EmailQueue",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("destinatario_email", models.EmailField(max_length=254)),
                ("destinatario_nome", models.CharField(blank=True, max_length=200)),
                (
                    "contexto",
                    models.JSONField(
                        default=dict, help_text="Contexto para renderizar o template"
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("pendente", "Pendente"),
                            ("processando", "Processando"),
                            ("enviado", "Enviado"),
                            ("falhou", "Falhou"),
                            ("cancelado", "Cancelado"),
                        ],
                        default="pendente",
                        max_length=20,
                    ),
                ),
                (
                    "prioridade",
                    models.PositiveIntegerField(
                        default=5, help_text="Prioridade (1=alta, 5=normal, 10=baixa)"
                    ),
                ),
                ("tentativas", models.PositiveIntegerField(default=0)),
                ("max_tentativas", models.PositiveIntegerField(default=3)),
                (
                    "data_agendamento",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        help_text="Data/hora para envio",
                    ),
                ),
                ("data_criacao", models.DateTimeField(auto_now_add=True)),
                ("data_processamento", models.DateTimeField(blank=True, null=True)),
                ("erro_mensagem", models.TextField(blank=True)),
                (
                    "modelo",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="models.modelo",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "template",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="queue_items",
                        to="communication.emailtemplate",
                    ),
                ),
            ],
            options={
                "verbose_name": "Item da Fila de Email",
                "verbose_name_plural": "Fila de Emails",
                "ordering": ["prioridade", "data_agendamento"],
                "indexes": [
                    models.Index(
                        fields=["status", "data_agendamento"],
                        name="communicati_status_932880_idx",
                    ),
                    models.Index(
                        fields=["prioridade", "data_agendamento"],
                        name="communicati_priorid_813fc3_idx",
                    ),
                ],
            },
        ),
        migrations.CreateModel(
            name="EmailLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("destinatario_email", models.EmailField(max_length=254)),
                ("destinatario_nome", models.CharField(blank=True, max_length=200)),
                ("assunto", models.CharField(max_length=200)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("pendente", "Pendente"),
                            ("enviado", "Enviado"),
                            ("falhou", "Falhou"),
                            ("entregue", "Entregue"),
                            ("rejeitado", "Rejeitado"),
                        ],
                        default="pendente",
                        max_length=20,
                    ),
                ),
                ("data_envio", models.DateTimeField(auto_now_add=True)),
                ("data_entrega", models.DateTimeField(blank=True, null=True)),
                ("erro_mensagem", models.TextField(blank=True)),
                (
                    "contexto",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        help_text="Contexto usado para renderizar o template",
                    ),
                ),
                (
                    "modelo",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="emails_recebidos",
                        to="models.modelo",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="emails_recebidos",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "template",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="logs",
                        to="communication.emailtemplate",
                    ),
                ),
            ],
            options={
                "verbose_name": "Log de Email",
                "verbose_name_plural": "Logs de Email",
                "ordering": ["-data_envio"],
                "indexes": [
                    models.Index(
                        fields=["destinatario_email", "data_envio"],
                        name="communicati_destina_74ae29_idx",
                    ),
                    models.Index(
                        fields=["status", "data_envio"],
                        name="communicati_status_5098bc_idx",
                    ),
                    models.Index(
                        fields=["template", "data_envio"],
                        name="communicati_templat_98d24a_idx",
                    ),
                ],
            },
        ),
    ]
