from django.core.management.base import BaseCommand
from models.models import PlanoAnuncio


class Command(BaseCommand):
    help = 'Cria os planos iniciais do sistema de anúncios'

    def handle(self, *args, **options):
        self.stdout.write(
            self.style.SUCCESS('🚀 Iniciando criação dos planos iniciais...')
        )
        
        planos_data = [
            # Plano Básico
            {
                'nome': 'Básico',
                'tipo': 'basico',
                'duracao_dias': 30,
                'preco': 29.90,
                'destaque_perfil': False,
                'boost_visualizacoes': False,
                'fotos_ilimitadas': False,
                'videos_ilimitados': False,
                'suporte_prioritario': False,
                'relatorio_estatisticas': False,
                'max_fotos': 10,
                'max_videos': 3,
                'ordem': 1
            },
            # Plano Premium
            {
                'nome': 'Premium',
                'tipo': 'premium',
                'duracao_dias': 30,
                'preco': 59.90,
                'destaque_perfil': True,
                'boost_visualizacoes': True,
                'fotos_ilimitadas': False,
                'videos_ilimitados': False,
                'suporte_prioritario': False,
                'relatorio_estatisticas': False,
                'max_fotos': 25,
                'max_videos': 8,
                'ordem': 2
            },
            # Plano VIP
            {
                'nome': 'VIP',
                'tipo': 'vip',
                'duracao_dias': 30,
                'preco': 99.90,
                'destaque_perfil': True,
                'boost_visualizacoes': True,
                'fotos_ilimitadas': True,
                'videos_ilimitados': True,
                'suporte_prioritario': False,
                'relatorio_estatisticas': False,
                'max_fotos': 999,
                'max_videos': 999,
                'ordem': 3
            },
            # Plano Exclusivo
            {
                'nome': 'Exclusivo',
                'tipo': 'exclusivo',
                'duracao_dias': 30,
                'preco': 149.90,
                'destaque_perfil': True,
                'boost_visualizacoes': True,
                'fotos_ilimitadas': True,
                'videos_ilimitados': True,
                'suporte_prioritario': True,
                'relatorio_estatisticas': True,
                'max_fotos': 999,
                'max_videos': 999,
                'ordem': 4
            },
            # Planos de 60 dias com desconto
            {
                'nome': 'Básico 60 Dias',
                'tipo': 'basico',
                'duracao_dias': 60,
                'preco': 49.90,
                'destaque_perfil': False,
                'boost_visualizacoes': False,
                'fotos_ilimitadas': False,
                'videos_ilimitados': False,
                'suporte_prioritario': False,
                'relatorio_estatisticas': False,
                'max_fotos': 10,
                'max_videos': 3,
                'ordem': 5
            },
            {
                'nome': 'Premium 60 Dias',
                'tipo': 'premium',
                'duracao_dias': 60,
                'preco': 99.90,
                'destaque_perfil': True,
                'boost_visualizacoes': True,
                'fotos_ilimitadas': False,
                'videos_ilimitados': False,
                'suporte_prioritario': False,
                'relatorio_estatisticas': False,
                'max_fotos': 25,
                'max_videos': 8,
                'ordem': 6
            }
        ]
        
        planos_criados = 0
        planos_atualizados = 0
        
        for plano_data in planos_data:
            plano, created = PlanoAnuncio.objects.get_or_create(
                nome=plano_data['nome'],
                tipo=plano_data['tipo'],
                duracao_dias=plano_data['duracao_dias'],
                defaults=plano_data
            )
            
            if created:
                self.stdout.write(
                    self.style.SUCCESS(f'✅ Plano "{plano.nome}" criado com sucesso!')
                )
                planos_criados += 1
            else:
                # Atualizar plano existente
                for key, value in plano_data.items():
                    setattr(plano, key, value)
                plano.save()
                self.stdout.write(
                    self.style.WARNING(f'🔄 Plano "{plano.nome}" atualizado.')
                )
                planos_atualizados += 1
        
        self.stdout.write(
            self.style.SUCCESS(
                f'\n🎉 Processo concluído!\n'
                f'📊 Resumo:\n'
                f'   • Planos criados: {planos_criados}\n'
                f'   • Planos atualizados: {planos_atualizados}\n'
                f'   • Total de planos: {PlanoAnuncio.objects.count()}'
            )
        )
