from django.core.management.base import BaseCommand
from django.test import RequestFactory
from django.contrib.auth.models import User
from payments.views import selecionar_plano
from models.models import Modelo


class Command(BaseCommand):
    help = 'Testa a view de seleção de planos'

    def handle(self, *args, **options):
        self.stdout.write('🧪 Testando view de seleção de planos...')
        
        try:
            # Criar request factory
            factory = RequestFactory()
            
            # Criar request anônimo
            request = factory.get('/payments/planos/')
            
            # Testar view
            response = selecionar_plano(request)
            
            self.stdout.write(f'✅ View funcionou! Status: {response.status_code}')
            
            if hasattr(response, 'context_data'):
                context = response.context_data
                self.stdout.write(f'📊 Contexto: {list(context.keys())}')
                
                if 'planos_por_tipo' in context:
                    planos = context['planos_por_tipo']
                    self.stdout.write(f'📋 Tipos de planos: {list(planos.keys())}')
                    
                    for tipo, lista_planos in planos.items():
                        self.stdout.write(f'  - {tipo}: {len(lista_planos)} planos')
            
        except Exception as e:
            self.stdout.write(f'❌ Erro na view: {str(e)}')
            import traceback
            self.stdout.write(f'🔍 Traceback: {traceback.format_exc()}')
        
        self.stdout.write('🏁 Teste concluído!')
