#!/usr/bin/env python
"""
Script para criar usuários administradores para o painel Allure
"""
import os
import sys
import django

# Configurar o Django
os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'allure_project.settings')
django.setup()

from django.contrib.auth.models import User
from django.core.management import execute_from_command_line


def create_superuser():
    """Cria um superusuário interativamente"""
    print("=== Criação de Superusuário para Allure ===")
    print()
    
    username = input("Digite o nome de usuário: ")
    email = input("Digite o email: ")
    password = input("Digite a senha: ")
    confirm_password = input("Confirme a senha: ")
    
    if password != confirm_password:
        print("Erro: As senhas não coincidem!")
        return
    
    try:
        # Verificar se o usuário já existe
        if User.objects.filter(username=username).exists():
            print(f"Erro: O usuário '{username}' já existe!")
            return
        
        # Criar o superusuário
        user = User.objects.create_superuser(
            username=username,
            email=email,
            password=password
        )
        
        print(f"\n✅ Superusuário '{username}' criado com sucesso!")
        print(f"Email: {email}")
        print(f"Você pode acessar o painel admin em: http://localhost:8000/admin/")
        
    except Exception as e:
        print(f"Erro ao criar superusuário: {e}")


def list_users():
    """Lista todos os usuários do sistema"""
    print("=== Usuários do Sistema ===")
    print()
    
    users = User.objects.all().order_by('date_joined')
    
    if not users:
        print("Nenhum usuário encontrado.")
        return
    
    for user in users:
        status = "Superusuário" if user.is_superuser else "Staff" if user.is_staff else "Usuário"
        print(f"ID: {user.id} | Usuário: {user.username} | Email: {user.email} | Status: {status}")


def main():
    """Função principal"""
    if len(sys.argv) > 1:
        command = sys.argv[1]
        
        if command == "create":
            create_superuser()
        elif command == "list":
            list_users()
        elif command == "shell":
            execute_from_command_line(sys.argv)
        else:
            print("Comandos disponíveis:")
            print("  python create_admin.py create  - Criar superusuário")
            print("  python create_admin.py list    - Listar usuários")
            print("  python create_admin.py shell   - Abrir shell do Django")
    else:
        print("=== Script de Administração Allure ===")
        print()
        print("Comandos disponíveis:")
        print("  python create_admin.py create  - Criar superusuário")
        print("  python create_admin.py list    - Listar usuários")
        print("  python create_admin.py shell   - Abrir shell do Django")
        print()
        print("Ou execute diretamente: python manage.py createsuperuser")


if __name__ == "__main__":
    main() 