#!/bin/bash

# Script para desenvolvimento com Django + SASS Watch
# Autor: Assistente AI

echo "🚀 Iniciando servidor de desenvolvimento Allure..."
echo "================================================"

# Verificar se estamos no diretório correto
if [ ! -f "manage.py" ]; then
    echo "❌ Erro: Este script deve ser executado no diretório raiz do projeto Django"
    echo "   Diretório atual: $(pwd)"
    echo "   Execute: cd allure_project && ./dev.sh"
    exit 1
fi

# Verificar se o ambiente virtual existe
if [ ! -d "venv" ]; then
    echo "❌ Erro: Ambiente virtual não encontrado"
    echo "   Execute: python3 -m venv venv"
    exit 1
fi

# Ativar o ambiente virtual
echo "📦 Ativando ambiente virtual..."
source venv/bin/activate

# Verificar se as dependências estão instaladas
echo "🔧 Verificando dependências..."
pip install -r requirements.txt

# Verificar se o banco de dados está configurado
if [ ! -f "db.sqlite3" ]; then
    echo "🗄️  Executando migrações..."
    python manage.py makemigrations
    python manage.py migrate
fi

# Compilar arquivos SASS uma vez
if [ -f "compile_sass.py" ]; then
    echo "🎨 Compilando arquivos SASS..."
    python compile_sass.py
fi

echo ""
echo "🌐 Iniciando servidor Django + SASS Watch..."
echo "================================================"
echo "📱 Django Server: http://localhost:8010"
echo "🎨 SASS Watch: Monitorando mudanças em tempo real"
echo "================================================"
echo "Pressione Ctrl+C para parar ambos os serviços"
echo ""

# Função para limpar processos ao sair
cleanup() {
    echo ""
    echo "🛑 Parando servidor de desenvolvimento..."
    kill $(jobs -p) 2>/dev/null
    exit 0
}

# Capturar Ctrl+C
trap cleanup SIGINT SIGTERM

# Executar Django e SASS watch em paralelo
python manage.py runserver 8010 &
python watch_sass.py &

# Aguardar todos os processos
wait
