# Generated by Django 5.2.4 on 2025-08-05 21:49

import django.core.validators
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("models", "0004_alter_banner_link_alter_modelo_categoria_servico_and_more"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Comentario",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("texto", models.TextField()),
                ("data_comentario", models.DateTimeField(auto_now_add=True)),
                ("aprovado", models.BooleanField(default=False)),
                (
                    "modelo",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="comentarios",
                        to="models.modelo",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="comentarios_feitos",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Comentário",
                "verbose_name_plural": "Comentários",
                "ordering": ["-data_comentario"],
            },
        ),
        migrations.CreateModel(
            name="VideoModelo",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("titulo", models.CharField(max_length=200)),
                ("descricao", models.TextField(blank=True)),
                ("arquivo", models.FileField(upload_to="modelos/videos/")),
                (
                    "thumbnail",
                    models.ImageField(
                        blank=True, null=True, upload_to="modelos/videos/thumbnails/"
                    ),
                ),
                (
                    "duracao",
                    models.PositiveIntegerField(
                        blank=True, help_text="Duração em segundos", null=True
                    ),
                ),
                ("ativo", models.BooleanField(default=True)),
                ("data_upload", models.DateTimeField(auto_now_add=True)),
                (
                    "modelo",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="videos",
                        to="models.modelo",
                    ),
                ),
            ],
            options={
                "verbose_name": "Vídeo da Modelo",
                "verbose_name_plural": "Vídeos das Modelos",
                "ordering": ["-data_upload"],
            },
        ),
        migrations.CreateModel(
            name="Avaliacao",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "nota",
                    models.PositiveIntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(5),
                        ]
                    ),
                ),
                ("comentario", models.TextField(blank=True)),
                ("data_avaliacao", models.DateTimeField(auto_now_add=True)),
                ("aprovado", models.BooleanField(default=False)),
                (
                    "modelo",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="avaliacoes",
                        to="models.modelo",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="avaliacoes_feitas",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Avaliação",
                "verbose_name_plural": "Avaliações",
                "ordering": ["-data_avaliacao"],
                "unique_together": {("modelo", "user")},
            },
        ),
    ]
