# Generated by Django 5.2.4 on 2025-09-02 20:39

from django.db import migrations


def corrigir_campos_null(apps, schema_editor):
    """Corrige campos NULL para valores vazios"""
    Modelo = apps.get_model('models', 'Modelo')
    
    # Atualizar campos NULL para strings vazias
    Modelo.objects.filter(biografia__isnull=True).update(biografia='')
    Modelo.objects.filter(sobre_mim__isnull=True).update(sobre_mim='')


def reverter_correcao(apps, schema_editor):
    """Reverte a correção (não faz nada)"""
    pass


class Migration(migrations.Migration):
    dependencies = [
        ("models", "0011_remove_modelo_aprovado_por_and_more"),
    ]

    operations = [
        migrations.RunPython(corrigir_campos_null, reverter_correcao),
    ]
