# Generated by Django 5.2.4 on 2025-09-15 20:34

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("models", "0017_remove_modelo_boost_ativo_and_more"),
        ("payments", "0004_remove_boost_premium_models"),
    ]

    operations = [
        migrations.CreateModel(
            name="PlanoAtivoLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "tipo_ativacao",
                    models.CharField(
                        choices=[
                            ("pagamento", "Pagamento Aprovado"),
                            ("admin", "Adicionado pelo Admin"),
                            ("renovacao", "Renovação"),
                        ],
                        max_length=20,
                    ),
                ),
                ("data_inicio", models.DateTimeField()),
                ("data_fim", models.DateTimeField()),
                (
                    "valor_pago",
                    models.DecimalField(
                        blank=True, decimal_places=2, max_digits=10, null=True
                    ),
                ),
                ("observacoes", models.TextField(blank=True)),
                ("data_criacao", models.DateTimeField(auto_now_add=True)),
                (
                    "modelo",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="logs_planos",
                        to="models.modelo",
                    ),
                ),
                (
                    "plano",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="models.planoanuncio",
                    ),
                ),
                (
                    "transacao_pagamento",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="payments.transacaopagamento",
                    ),
                ),
            ],
            options={
                "verbose_name": "Log de Plano Ativo",
                "verbose_name_plural": "Logs de Planos Ativos",
                "ordering": ["-data_inicio"],
            },
        ),
    ]
