# Generated manually for data migration

from django.db import migrations


def migrate_etnia_data(apps, schema_editor):
    """Migra os dados de etnia existentes para as novas opções"""
    Modelo = apps.get_model('models', 'Modelo')
    
    # Mapeamento dos valores antigos para os novos
    etnia_mapping = {
        'branca': 'loira',  # Assumindo que branca pode ser loira
        'negra': 'negra',   # Mantém o mesmo
        'parda': 'morena',  # Assumindo que parda pode ser morena
        'asiatica': 'oriental',  # Asiática vira Oriental
        'indigena': 'mestica',  # Indígena vira Mestiça
        'outra': 'morena',  # Outra vira Morena como padrão
    }
    
    # Atualizar os registros existentes
    for modelo in Modelo.objects.all():
        if modelo.etnia in etnia_mapping:
            modelo.etnia = etnia_mapping[modelo.etnia]
            modelo.save(update_fields=['etnia'])


def reverse_migrate_etnia_data(apps, schema_editor):
    """Reverte a migração de dados"""
    Modelo = apps.get_model('models', 'Modelo')
    
    # Mapeamento reverso
    reverse_mapping = {
        'loira': 'branca',
        'negra': 'negra',
        'morena': 'parda',
        'oriental': 'asiatica',
        'mestica': 'indigena',
        'mulata': 'outra',
        'ruiva': 'outra',
    }
    
    # Reverter os registros
    for modelo in Modelo.objects.all():
        if modelo.etnia in reverse_mapping:
            modelo.etnia = reverse_mapping[modelo.etnia]
            modelo.save(update_fields=['etnia'])


class Migration(migrations.Migration):
    dependencies = [
        ("models", "0022_update_etnia_choices"),
    ]

    operations = [
        migrations.RunPython(migrate_etnia_data, reverse_migrate_etnia_data),
    ]
