# Generated by Django 5.2.4 on 2025-08-04 23:23

import django.db.models.deletion
import uuid
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("models", "0004_alter_banner_link_alter_modelo_categoria_servico_and_more"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="ConfiguracaoPagamento",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("chave", models.CharField(max_length=100, unique=True)),
                ("valor", models.TextField()),
                ("descricao", models.TextField(blank=True)),
                ("ativo", models.BooleanField(default=True)),
                ("data_criacao", models.DateTimeField(auto_now_add=True)),
                ("data_atualizacao", models.DateTimeField(auto_now=True)),
            ],
            options={
                "verbose_name": "Configuração de Pagamento",
                "verbose_name_plural": "Configurações de Pagamento",
            },
        ),
        migrations.CreateModel(
            name="WebhookLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "tipo",
                    models.CharField(
                        choices=[
                            ("payment", "Payment"),
                            ("preference", "Preference"),
                            ("order", "Order"),
                            ("other", "Other"),
                        ],
                        max_length=20,
                    ),
                ),
                ("dados_recebidos", models.JSONField()),
                ("processado", models.BooleanField(default=False)),
                ("erro", models.TextField(blank=True)),
                ("data_recebimento", models.DateTimeField(auto_now_add=True)),
                ("data_processamento", models.DateTimeField(blank=True, null=True)),
            ],
            options={
                "verbose_name": "Log de Webhook",
                "verbose_name_plural": "Logs de Webhook",
                "ordering": ["-data_recebimento"],
            },
        ),
        migrations.CreateModel(
            name="TransacaoPagamento",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "external_reference",
                    models.CharField(blank=True, max_length=100, unique=True),
                ),
                (
                    "tipo",
                    models.CharField(
                        choices=[
                            ("boost", "Boost de Perfil"),
                            ("premium", "Upgrade Premium"),
                            ("servico", "Serviço"),
                            ("outro", "Outro"),
                        ],
                        max_length=20,
                    ),
                ),
                ("valor", models.DecimalField(decimal_places=2, max_digits=10)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("pendente", "Pendente"),
                            ("aprovado", "Aprovado"),
                            ("rejeitado", "Rejeitado"),
                            ("cancelado", "Cancelado"),
                            ("processando", "Processando"),
                            ("falhou", "Falhou"),
                        ],
                        default="pendente",
                        max_length=20,
                    ),
                ),
                ("payment_id", models.CharField(blank=True, max_length=100, null=True)),
                (
                    "preference_id",
                    models.CharField(blank=True, max_length=100, null=True),
                ),
                (
                    "merchant_order_id",
                    models.CharField(blank=True, max_length=100, null=True),
                ),
                ("email_pagador", models.EmailField(blank=True, max_length=254)),
                ("nome_pagador", models.CharField(blank=True, max_length=200)),
                ("descricao", models.TextField(blank=True)),
                ("dados_adicional", models.JSONField(blank=True, default=dict)),
                ("data_criacao", models.DateTimeField(auto_now_add=True)),
                ("data_atualizacao", models.DateTimeField(auto_now=True)),
                ("data_aprovacao", models.DateTimeField(blank=True, null=True)),
                (
                    "modelo",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="transacoes_pagamento",
                        to="models.modelo",
                    ),
                ),
                (
                    "usuario",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="transacoes_pagamento",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Pagamento",
                "verbose_name_plural": "Pagamentos",
                "ordering": ["-data_criacao"],
            },
        ),
        migrations.CreateModel(
            name="PremiumPagamento",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "plano",
                    models.CharField(
                        choices=[
                            ("mensal", "Mensal"),
                            ("trimestral", "Trimestral"),
                            ("semestral", "Semestral"),
                            ("anual", "Anual"),
                        ],
                        max_length=20,
                    ),
                ),
                ("data_inicio", models.DateTimeField(blank=True, null=True)),
                ("data_fim", models.DateTimeField(blank=True, null=True)),
                (
                    "pagamento",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="premium",
                        to="payments.transacaopagamento",
                    ),
                ),
            ],
            options={
                "verbose_name": "Pagamento Premium",
                "verbose_name_plural": "Pagamentos Premium",
            },
        ),
        migrations.CreateModel(
            name="BoostPagamento",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "duracao_dias",
                    models.PositiveIntegerField(
                        choices=[(7, "7 dias"), (15, "15 dias"), (30, "30 dias")]
                    ),
                ),
                ("data_inicio", models.DateTimeField(blank=True, null=True)),
                ("data_fim", models.DateTimeField(blank=True, null=True)),
                (
                    "pagamento",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="boost",
                        to="payments.transacaopagamento",
                    ),
                ),
            ],
            options={
                "verbose_name": "Boost de Pagamento",
                "verbose_name_plural": "Boosts de Pagamento",
            },
        ),
    ]
