# Generated by Django 5.2.4 on 2025-09-15 21:14

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("models", "0018_add_plano_ativo_log"),
        ("payments", "0004_remove_boost_premium_models"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Voucher",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "codigo",
                    models.CharField(
                        max_length=50, unique=True, verbose_name="Código do Voucher"
                    ),
                ),
                (
                    "nome",
                    models.CharField(max_length=100, verbose_name="Nome do Voucher"),
                ),
                ("descricao", models.TextField(blank=True, verbose_name="Descrição")),
                (
                    "tipo_desconto",
                    models.CharField(
                        choices=[
                            ("gratuito", "Gratuito"),
                            ("desconto_fixo", "Desconto Valor Fixo"),
                            ("desconto_percentual", "Desconto Percentual"),
                            ("extensao", "Extensão de Plano"),
                        ],
                        max_length=20,
                        verbose_name="Tipo de Desconto",
                    ),
                ),
                (
                    "valor_desconto",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=10,
                        null=True,
                        verbose_name="Valor do Desconto",
                    ),
                ),
                (
                    "percentual_desconto",
                    models.PositiveIntegerField(
                        blank=True, null=True, verbose_name="Percentual de Desconto (%)"
                    ),
                ),
                (
                    "quantidade_maxima",
                    models.PositiveIntegerField(
                        default=1, verbose_name="Quantidade Máxima de Uso"
                    ),
                ),
                (
                    "quantidade_usada",
                    models.PositiveIntegerField(
                        default=0, verbose_name="Quantidade Usada"
                    ),
                ),
                ("data_inicio", models.DateTimeField(verbose_name="Data de Início")),
                ("data_fim", models.DateTimeField(verbose_name="Data de Fim")),
                (
                    "categoria",
                    models.CharField(
                        choices=[
                            ("promocional", "Promocional"),
                            ("cortesia", "Cortesia"),
                            ("parceria", "Parceria"),
                            ("marketing", "Marketing"),
                            ("suporte", "Suporte"),
                        ],
                        default="promocional",
                        max_length=20,
                        verbose_name="Categoria",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("ativo", "Ativo"),
                            ("inativo", "Inativo"),
                            ("expirado", "Expirado"),
                            ("esgotado", "Esgotado"),
                        ],
                        default="ativo",
                        max_length=20,
                        verbose_name="Status",
                    ),
                ),
                (
                    "observacoes",
                    models.TextField(blank=True, verbose_name="Observações"),
                ),
                (
                    "data_criacao",
                    models.DateTimeField(
                        auto_now_add=True, verbose_name="Data de Criação"
                    ),
                ),
                (
                    "data_atualizacao",
                    models.DateTimeField(
                        auto_now=True, verbose_name="Data de Atualização"
                    ),
                ),
                (
                    "criado_por",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Criado por",
                    ),
                ),
                (
                    "modelo_especifico",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="models.modelo",
                        verbose_name="Modelo Específico",
                    ),
                ),
                (
                    "plano",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="models.planoanuncio",
                        verbose_name="Plano de Anúncio",
                    ),
                ),
            ],
            options={
                "verbose_name": "Voucher",
                "verbose_name_plural": "Vouchers",
                "ordering": ["-data_criacao"],
            },
        ),
        migrations.CreateModel(
            name="VoucherUso",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "valor_original",
                    models.DecimalField(
                        decimal_places=2, max_digits=10, verbose_name="Valor Original"
                    ),
                ),
                (
                    "valor_desconto",
                    models.DecimalField(
                        decimal_places=2,
                        max_digits=10,
                        verbose_name="Valor do Desconto",
                    ),
                ),
                (
                    "valor_final",
                    models.DecimalField(
                        decimal_places=2, max_digits=10, verbose_name="Valor Final"
                    ),
                ),
                (
                    "observacoes",
                    models.TextField(blank=True, verbose_name="Observações"),
                ),
                (
                    "data_uso",
                    models.DateTimeField(auto_now_add=True, verbose_name="Data de Uso"),
                ),
                (
                    "modelo",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="vouchers_usados",
                        to="models.modelo",
                    ),
                ),
                (
                    "transacao",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="voucher_usado",
                        to="payments.transacaopagamento",
                    ),
                ),
                (
                    "voucher",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="usos",
                        to="payments.voucher",
                    ),
                ),
            ],
            options={
                "verbose_name": "Uso de Voucher",
                "verbose_name_plural": "Usos de Vouchers",
                "ordering": ["-data_uso"],
            },
        ),
    ]
