@echo off
REM Script para executar o projeto Allure no Windows
REM Autor: Assistente AI
REM Data: %date% %time%

echo 🚀 Iniciando o projeto Allure...
echo ================================

REM Verificar se estamos no diretório correto
if not exist "manage.py" (
    echo ❌ Erro: Este script deve ser executado no diretório raiz do projeto Django
    echo    Diretório atual: %cd%
    echo    Execute: cd allure_project ^&^& run.bat
    pause
    exit /b 1
)

REM Verificar se o ambiente virtual existe
if not exist "venv" (
    echo ❌ Erro: Ambiente virtual não encontrado
    echo    Execute: python -m venv venv
    pause
    exit /b 1
)

REM Ativar o ambiente virtual
echo 📦 Ativando ambiente virtual...
call venv\Scripts\activate.bat

REM Verificar se as dependências estão instaladas
if not exist "requirements.txt" (
    echo ❌ Erro: requirements.txt não encontrado
    pause
    exit /b 1
)

REM Instalar/atualizar dependências se necessário
echo 🔧 Verificando dependências...
pip install -r requirements.txt

REM Verificar se o banco de dados está configurado
if not exist "db.sqlite3" (
    echo 🗄️  Executando migrações...
    python manage.py makemigrations
    python manage.py migrate
)

REM Compilar arquivos SASS se existirem
if exist "compile_sass.py" (
    echo 🎨 Compilando arquivos SASS...
    python compile_sass.py
)

REM Executar o servidor
echo 🌐 Iniciando servidor na porta 8010...
echo    URL: http://localhost:8010
echo    Pressione Ctrl+C para parar o servidor
echo ================================

python manage.py runserver 8010

pause
