#!/bin/bash

# Script para executar o projeto Allure
# Autor: Assistente AI
# Data: $(date)

echo "🚀 Iniciando o projeto Allure..."
echo "================================"

# Verificar se estamos no diretório correto
if [ ! -f "manage.py" ]; then
    echo "❌ Erro: Este script deve ser executado no diretório raiz do projeto Django"
    echo "   Diretório atual: $(pwd)"
    echo "   Execute: cd allure_project && ./run.sh"
    exit 1
fi

# Verificar se o ambiente virtual existe
if [ ! -d "venv" ]; then
    echo "❌ Erro: Ambiente virtual não encontrado"
    echo "   Execute: python3 -m venv venv"
    exit 1
fi

# Ativar o ambiente virtual
echo "📦 Ativando ambiente virtual..."
source venv/bin/activate

# Verificar se as dependências estão instaladas
if [ ! -f "requirements.txt" ]; then
    echo "❌ Erro: requirements.txt não encontrado"
    exit 1
fi

# Instalar/atualizar dependências se necessário
echo "🔧 Verificando dependências..."
pip install -r requirements.txt

# Verificar se o banco de dados está configurado
if [ ! -f "db.sqlite3" ]; then
    echo "🗄️  Executando migrações..."
    python manage.py makemigrations
    python manage.py migrate
fi

# Compilar arquivos SASS se existirem
if [ -f "compile_sass.py" ]; then
    echo "🎨 Compilando arquivos SASS..."
    python compile_sass.py
fi

# Executar o servidor
echo "🌐 Iniciando servidor na porta 8010..."
echo "   URL: http://localhost:8010"
echo "   Pressione Ctrl+C para parar o servidor"
echo "================================"

python manage.py runserver 8010
