// Sistema completo de municípios brasileiros
// Baseado no arquivo oficial da Receita Federal
// Total: 5.573 municípios

// Estados brasileiros com siglas
const ESTADOS_BRASIL = [
    { sigla: 'AC', nome: 'Acre' },
    { sigla: 'AL', nome: 'Alagoas' },
    { sigla: 'AP', nome: 'Amapá' },
    { sigla: 'AM', nome: 'Amazonas' },
    { sigla: 'BA', nome: 'Bahia' },
    { sigla: 'CE', nome: 'Ceará' },
    { sigla: 'DF', nome: 'Distrito Federal' },
    { sigla: 'ES', nome: 'Espírito Santo' },
    { sigla: 'GO', nome: 'Goiás' },
    { sigla: 'MA', nome: 'Maranhão' },
    { sigla: 'MT', nome: 'Mato Grosso' },
    { sigla: 'MS', nome: 'Mato Grosso do Sul' },
    { sigla: 'MG', nome: 'Minas Gerais' },
    { sigla: 'PA', nome: 'Pará' },
    { sigla: 'PB', nome: 'Paraíba' },
    { sigla: 'PR', nome: 'Paraná' },
    { sigla: 'PE', nome: 'Pernambuco' },
    { sigla: 'PI', nome: 'Piauí' },
    { sigla: 'RJ', nome: 'Rio de Janeiro' },
    { sigla: 'RN', nome: 'Rio Grande do Norte' },
    { sigla: 'RS', nome: 'Rio Grande do Sul' },
    { sigla: 'RO', nome: 'Rondônia' },
    { sigla: 'RR', nome: 'Roraima' },
    { sigla: 'SC', nome: 'Santa Catarina' },
    { sigla: 'SP', nome: 'São Paulo' },
    { sigla: 'SE', nome: 'Sergipe' },
    { sigla: 'TO', nome: 'Tocantins' }
];

// Dados completos dos municípios (estrutura otimizada)
const MUNICIPIOS_COMPLETOS = {
    'AC': [
        'Acrelândia',
        'Assis Brasil',
        'Brasiléia',
        'Bujari',
        'Capixaba',
        'Cruzeiro do Sul',
        'Epitaciolândia',
        'Feijó',
        'Jordão',
        'Manoel Urbano',
        'Marechal Thaumaturgo',
        'Mâncio Lima',
        'Plácido de Castro',
        'Porto Acre',
        'Porto Walter',
        'Rio Branco',
        'Rodrigues Alves',
        'Santa Rosa do Purus',
        'Sena Madureira',
        'Senador Guiomard',
        'Tarauacá',
        'Xapuri'
    ],
    'AL': [
        'Anadia',
        'Arapiraca',
        'Atalaia',
        'Barra de Santo Antônio',
        'Barra de São Miguel',
        'Batalha',
        'Belo Monte',
        'Belém',
        'Boca da Mata',
        'Branquinha',
        'Cacimbinhas',
        'Cajueiro',
        'Campestre',
        'Campo Alegre',
        'Campo Grande',
        'Canapi',
        'Capela',
        'Carneiros',
        'Chã Preta',
        'Coité do Nóia',
        'Colônia Leopoldina',
        'Coqueiro Seco',
        'Coruripe',
        'Craíbas',
        'Delmiro Gouveia',
        'Dois Riachos',
        'Estrela de Alagoas',
        'Feira Grande',
        'Feliz Deserto',
        'Flexeiras',
        'Girau do Ponciano',
        'Ibateguara',
        'Igaci',
        'Igreja Nova',
        'Inhapi',
        'Jacaré dos Homens',
        'Jacuípe',
        'Japaratinga',
        'Jaramataia',
        'Jequiá da Praia',
        'Joaquim Gomes',
        'Jundiá',
        'Junqueiro',
        'Lagoa da Canoa',
        'Limoeiro de Anadia',
        'Maceió',
        'Major Isidoro',
        'Mar Vermelho',
        'Maragogi',
        'Maravilha',
        'Marechal Deodoro',
        'Maribondo',
        'Mata Grande',
        'Matriz de Camaragibe',
        'Messias',
        'Minador do Negrão',
        'Monteirópolis',
        'Murici',
        'Novo Lino',
        'Olho d\'Água Grande',
        'Olho d\'Água das Flores',
        'Olho d\'Água do Casado',
        'Olivença',
        'Ouro Branco',
        'Palestina',
        'Palmeira dos Índios',
        'Pariconha',
        'Paripueira',
        'Passo de Camaragibe',
        'Paulo Jacinto',
        'Penedo',
        'Piaçabuçu',
        'Pilar',
        'Pindoba',
        'Piranhas',
        'Porto Calvo',
        'Porto Real do Colégio',
        'Porto de Pedras',
        'Poço das Trincheiras',
        'Pão de Açúcar',
        'Quebrangulo',
        'Rio Largo',
        'Roteiro',
        'Santa Luzia do Norte',
        'Santana do Ipanema',
        'Santana do Mundaú',
        'Satuba',
        'Senador Rui Palmeira',
        'São Brás',
        'São José da Laje',
        'São José da Tapera',
        'São Luís do Quitunde',
        'São Miguel dos Campos',
        'São Miguel dos Milagres',
        'São Sebastião',
        'Tanque d\'Arca',
        'Taquarana',
        'Teotônio Vilela',
        'Traipu',
        'União dos Palmares',
        'Viçosa',
        'Água Branca'
    ],
    'AM': [
        'Alvarães',
        'Amaturá',
        'Anamã',
        'Anori',
        'Apuí',
        'Atalaia do Norte',
        'Autazes',
        'Barcelos',
        'Barreirinha',
        'Benjamin Constant',
        'Beruri',
        'Boa Vista do Ramos',
        'Boca do Acre',
        'Borba',
        'Caapiranga',
        'Canutama',
        'Carauari',
        'Careiro',
        'Careiro da Várzea',
        'Coari',
        'Codajás',
        'Eirunepé',
        'Envira',
        'Fonte Boa',
        'Guajará',
        'Humaitá',
        'Ipixuna',
        'Iranduba',
        'Itacoatiara',
        'Itamarati',
        'Itapiranga',
        'Japurá',
        'Juruá',
        'Jutaí',
        'Lábrea',
        'Manacapuru',
        'Manaquiri',
        'Manaus',
        'Manicoré',
        'Maraã',
        'Maués',
        'Nhamundá',
        'Nova Olinda do Norte',
        'Novo Airão',
        'Novo Aripuanã',
        'Parintins',
        'Pauini',
        'Presidente Figueiredo',
        'Rio Preto da Eva',
        'Santa Isabel do Rio Negro',
        'Santo Antônio do Içá',
        'Silves',
        'São Gabriel da Cachoeira',
        'São Paulo de Olivença',
        'São Sebastião do Uatumã',
        'Tabatinga',
        'Tapauá',
        'Tefé',
        'Tonantins',
        'Uarini',
        'Urucará',
        'Urucurituba'
    ],
    'AP': [
        'Amapá',
        'Calçoene',
        'Cutias',
        'Ferreira Gomes',
        'Itaubal',
        'Laranjal do Jari',
        'Macapá',
        'Mazagão',
        'Oiapoque',
        'Pedra Branca do Amapari',
        'Porto Grande',
        'Pracuúba',
        'Santana',
        'Serra do Navio',
        'Tartarugalzinho',
        'Vitória do Jari'
    ],
    'BA': [
        'Abaré',
        'Abaíra',
        'Acajutiba',
        'Adustina',
        'Aiquara',
        'Alagoinhas',
        'Alcobaça',
        'Almadina',
        'Amargosa',
        'Amélia Rodrigues',
        'América Dourada',
        'Anagé',
        'Andaraí',
        'Andorinha',
        'Angical',
        'Anguera',
        'Antas',
        'Antônio Cardoso',
        'Antônio Gonçalves',
        'Aporá',
        'Apuarema',
        'Aracatu',
        'Araci',
        'Aramari',
        'Arataca',
        'Aratuípe',
        'Araçás',
        'Aurelino Leal',
        'Baianópolis',
        'Baixa Grande',
        'Banzaê',
        'Barra',
        'Barra da Estiva',
        'Barra do Choça',
        'Barra do Mendes',
        'Barra do Rocha',
        'Barreiras',
        'Barro Alto',
        'Barro Preto',
        'Barrocas',
        'Belmonte',
        'Belo Campo',
        'Biritinga',
        'Boa Nova',
        'Boa Vista do Tupim',
        'Bom Jesus da Lapa',
        'Bom Jesus da Serra',
        'Boninal',
        'Bonito',
        'Boquira',
        'Botuporã',
        'Brejolândia',
        'Brejões',
        'Brotas de Macaúbas',
        'Brumado',
        'Buerarema',
        'Buritirama',
        'Caatiba',
        'Cabaceiras do Paraguaçu',
        'Cachoeira',
        'Caculé',
        'Caetanos',
        'Caetité',
        'Cafarnaum',
        'Cairu',
        'Caldeirão Grande',
        'Camacan',
        'Camamu',
        'Camaçari',
        'Campo Alegre de Lourdes',
        'Campo Formoso',
        'Canarana',
        'Canavieiras',
        'Candeal',
        'Candeias',
        'Candiba',
        'Cansanção',
        'Canudos',
        'Canápolis',
        'Capela do Alto Alegre',
        'Capim Grosso',
        'Caravelas',
        'Caraíbas',
        'Cardeal da Silva',
        'Carinhanha',
        'Casa Nova',
        'Castro Alves',
        'Catolândia',
        'Catu',
        'Caturama',
        'Caém',
        'Central',
        'Chorrochó',
        'Cipó',
        'Coaraci',
        'Cocos',
        'Conceição da Feira',
        'Conceição do Almeida',
        'Conceição do Coité',
        'Conceição do Jacuípe',
        'Conde',
        'Condeúba',
        'Contendas do Sincorá',
        'Coração de Maria',
        'Cordeiros',
        'Coribe',
        'Coronel João Sá',
        'Correntina',
        'Cotegipe',
        'Cravolândia',
        'Cristópolis',
        'Crisópolis',
        'Cruz das Almas',
        'Curaçá',
        'Cândido Sales',
        'Cícero Dantas',
        'Dias d\'Ávila',
        'Dom Basílio',
        'Dom Macedo Costa',
        'Dário Meira',
        'Elísio Medrado',
        'Encruzilhada',
        'Entre Rios',
        'Esplanada',
        'Euclides da Cunha',
        'Eunápolis',
        'Feira da Mata',
        'Feira de Santana',
        'Filadélfia',
        'Firmino Alves',
        'Floresta Azul',
        'Formosa do Rio Preto',
        'Fátima',
        'Gandu',
        'Gavião',
        'Gentio do Ouro',
        'Glória',
        'Gongogi',
        'Governador Mangabeira',
        'Guajeru',
        'Guanambi',
        'Guaratinga',
        'Heliópolis',
        'Iaçu',
        'Ibiassucê',
        'Ibicaraí',
        'Ibicoara',
        'Ibicuí',
        'Ibipeba',
        'Ibipitanga',
        'Ibiquera',
        'Ibirapitanga',
        'Ibirapuã',
        'Ibirataia',
        'Ibitiara',
        'Ibititá',
        'Ibotirama',
        'Ichu',
        'Igaporã',
        'Igrapiúna',
        'Iguaí',
        'Ilhéus',
        'Inhambupe',
        'Ipecaetá',
        'Ipiaú',
        'Ipirá',
        'Ipupiara',
        'Irajuba',
        'Iramaia',
        'Iraquara',
        'Irará',
        'Irecê',
        'Itabela',
        'Itaberaba',
        'Itabuna',
        'Itacaré',
        'Itaeté',
        'Itagi',
        'Itagibá',
        'Itagimirim',
        'Itaguaçu da Bahia',
        'Itaju do Colônia',
        'Itajuípe',
        'Itamaraju',
        'Itamari',
        'Itambé',
        'Itanagra',
        'Itanhém',
        'Itaparica',
        'Itapebi',
        'Itapetinga',
        'Itapicuru',
        'Itapitanga',
        'Itapé',
        'Itaquara',
        'Itarantim',
        'Itatim',
        'Itiruçu',
        'Itiúba',
        'Itororó',
        'Ituaçu',
        'Ituberá',
        'Iuiu',
        'Jaborandi',
        'Jacaraci',
        'Jacobina',
        'Jaguaquara',
        'Jaguarari',
        'Jaguaripe',
        'Jandaíra',
        'Jequié',
        'Jeremoabo',
        'Jiquiriçá',
        'Jitaúna',
        'João Dourado',
        'Juazeiro',
        'Jucuruçu',
        'Jussara',
        'Jussari',
        'Jussiape',
        'Lafaiete Coutinho',
        'Lagoa Real',
        'Laje',
        'Lajedinho',
        'Lajedo do Tabocal',
        'Lajedão',
        'Lamarão',
        'Lapão',
        'Lauro de Freitas',
        'Lençóis',
        'Licínio de Almeida',
        'Livramento de Nossa Senhora',
        'Luís Eduardo Magalhães',
        'Macajuba',
        'Macarani',
        'Macaúbas',
        'Macururé',
        'Madre de Deus',
        'Maetinga',
        'Maiquinique',
        'Mairi',
        'Malhada',
        'Malhada de Pedras',
        'Manoel Vitorino',
        'Mansidão',
        'Maracás',
        'Maragogipe',
        'Maraú',
        'Marcionílio Souza',
        'Mascote',
        'Mata de São João',
        'Matina',
        'Medeiros Neto',
        'Miguel Calmon',
        'Milagres',
        'Mirangaba',
        'Mirante',
        'Monte Santo',
        'Morpará',
        'Morro do Chapéu',
        'Mortugaba',
        'Mucugê',
        'Mucuri',
        'Mulungu do Morro',
        'Mundo Novo',
        'Muniz Ferreira',
        'Muquém do São Francisco',
        'Muritiba',
        'Mutuípe',
        'Nazaré',
        'Nilo Peçanha',
        'Nordestina',
        'Nova Canaã',
        'Nova Fátima',
        'Nova Ibiá',
        'Nova Itarana',
        'Nova Redenção',
        'Nova Soure',
        'Nova Viçosa',
        'Novo Horizonte',
        'Novo Triunfo',
        'Olindina',
        'Oliveira dos Brejinhos',
        'Ouriçangas',
        'Ourolândia',
        'Palmas de Monte Alto',
        'Palmeiras',
        'Paramirim',
        'Paratinga',
        'Paripiranga',
        'Pau Brasil',
        'Paulo Afonso',
        'Pedro Alexandre',
        'Pedrão',
        'Piatã',
        'Pilão Arcado',
        'Pindaí',
        'Pindobaçu',
        'Pintadas',
        'Piraí do Norte',
        'Piripá',
        'Piritiba',
        'Planaltino',
        'Planalto',
        'Pojuca',
        'Ponto Novo',
        'Porto Seguro',
        'Potiraguá',
        'Poções',
        'Prado',
        'Presidente Dutra',
        'Presidente Jânio Quadros',
        'Presidente Tancredo Neves',
        'Pé de Serra',
        'Queimadas',
        'Quijingue',
        'Quixabeira',
        'Rafael Jambeiro',
        'Remanso',
        'Retirolândia',
        'Riacho de Santana',
        'Riachão das Neves',
        'Riachão do Jacuípe',
        'Ribeira do Amparo',
        'Ribeira do Pombal',
        'Ribeirão do Largo',
        'Rio Real',
        'Rio de Contas',
        'Rio do Antônio',
        'Rio do Pires',
        'Rodelas',
        'Ruy Barbosa',
        'Salinas da Margarida',
        'Salvador',
        'Santa Brígida',
        'Santa Bárbara',
        'Santa Cruz Cabrália',
        'Santa Cruz da Vitória',
        'Santa Inês',
        'Santa Luzia',
        'Santa Maria da Vitória',
        'Santa Rita de Cássia',
        'Santa Terezinha',
        'Santaluz',
        'Santana',
        'Santanópolis',
        'Santo Amaro',
        'Santo Antônio de Jesus',
        'Santo Estêvão',
        'Sapeaçu',
        'Saubara',
        'Saúde',
        'Seabra',
        'Sebastião Laranjeiras',
        'Senhor do Bonfim',
        'Sento Sé',
        'Serra Dourada',
        'Serra Preta',
        'Serra do Ramalho',
        'Serrinha',
        'Serrolândia',
        'Simões Filho',
        'Sobradinho',
        'Souto Soares',
        'Sátiro Dias',
        'São Desidério',
        'São Domingos',
        'São Felipe',
        'São Francisco do Conde',
        'São Félix',
        'São Félix do Coribe',
        'São Gabriel',
        'São Gonçalo dos Campos',
        'São José da Vitória',
        'São José do Jacuípe',
        'São Miguel das Matas',
        'São Sebastião do Passé',
        'Sítio do Mato',
        'Sítio do Quinto',
        'Tabocas do Brejo Velho',
        'Tanhaçu',
        'Tanque Novo',
        'Tanquinho',
        'Taperoá',
        'Tapiramutá',
        'Teixeira de Freitas',
        'Teodoro Sampaio',
        'Teofilândia',
        'Teolândia',
        'Terra Nova',
        'Tremedal',
        'Tucano',
        'Uauá',
        'Ubaitaba',
        'Ubatã',
        'Ubaíra',
        'Uibaí',
        'Umburanas',
        'Una',
        'Urandi',
        'Uruçuca',
        'Utinga',
        'Valente',
        'Valença',
        'Varzedo',
        'Vera Cruz',
        'Vereda',
        'Vitória da Conquista',
        'Várzea Nova',
        'Várzea da Roça',
        'Várzea do Poço',
        'Wagner',
        'Wanderley',
        'Wenceslau Guimarães',
        'Xique-Xique',
        'Água Fria',
        'Érico Cardoso'
    ],
    'CE': [
        'Abaiara',
        'Acarape',
        'Acaraú',
        'Acopiara',
        'Aiuaba',
        'Alcântaras',
        'Altaneira',
        'Alto Santo',
        'Amontada',
        'Antonina do Norte',
        'Apuiarés',
        'Aquiraz',
        'Aracati',
        'Aracoiaba',
        'Ararendá',
        'Araripe',
        'Aratuba',
        'Arneiroz',
        'Assaré',
        'Aurora',
        'Baixio',
        'Banabuiú',
        'Barbalha',
        'Barreira',
        'Barro',
        'Barroquinha',
        'Baturité',
        'Beberibe',
        'Bela Cruz',
        'Boa Viagem',
        'Brejo Santo',
        'Camocim',
        'Campos Sales',
        'Canindé',
        'Capistrano',
        'Caridade',
        'Caririaçu',
        'Cariré',
        'Cariús',
        'Carnaubal',
        'Cascavel',
        'Catarina',
        'Catunda',
        'Caucaia',
        'Cedro',
        'Chaval',
        'Chorozinho',
        'Choró',
        'Coreaú',
        'Crateús',
        'Crato',
        'Croatá',
        'Cruz',
        'Deputado Irapuan Pinheiro',
        'Ereré',
        'Eusébio',
        'Farias Brito',
        'Forquilha',
        'Fortaleza',
        'Fortim',
        'Frecheirinha',
        'General Sampaio',
        'Granja',
        'Granjeiro',
        'Graça',
        'Groaíras',
        'Guaiúba',
        'Guaraciaba do Norte',
        'Guaramiranga',
        'Hidrolândia',
        'Horizonte',
        'Ibaretama',
        'Ibiapina',
        'Ibicuitinga',
        'Icapuí',
        'Icó',
        'Iguatu',
        'Independência',
        'Ipaporanga',
        'Ipaumirim',
        'Ipu',
        'Ipueiras',
        'Iracema',
        'Irauçuba',
        'Itaitinga',
        'Itaiçaba',
        'Itapajé',
        'Itapipoca',
        'Itapiúna',
        'Itarema',
        'Itatira',
        'Jaguaretama',
        'Jaguaribara',
        'Jaguaribe',
        'Jaguaruana',
        'Jardim',
        'Jati',
        'Jijoca de Jericoacoara',
        'Juazeiro do Norte',
        'Jucás',
        'Lavras da Mangabeira',
        'Limoeiro do Norte',
        'Madalena',
        'Maracanaú',
        'Maranguape',
        'Marco',
        'Martinópole',
        'Massapê',
        'Mauriti',
        'Meruoca',
        'Milagres',
        'Milhã',
        'Miraíma',
        'Missão Velha',
        'Mombaça',
        'Monsenhor Tabosa',
        'Morada Nova',
        'Moraújo',
        'Morrinhos',
        'Mucambo',
        'Mulungu',
        'Nova Olinda',
        'Nova Russas',
        'Novo Oriente',
        'Ocara',
        'Orós',
        'Pacajus',
        'Pacatuba',
        'Pacoti',
        'Pacujá',
        'Palhano',
        'Palmácia',
        'Paracuru',
        'Paraipaba',
        'Parambu',
        'Paramoti',
        'Pedra Branca',
        'Penaforte',
        'Pentecoste',
        'Pereiro',
        'Pindoretama',
        'Piquet Carneiro',
        'Pires Ferreira',
        'Poranga',
        'Porteiras',
        'Potengi',
        'Potiretama',
        'Quiterianópolis',
        'Quixadá',
        'Quixelô',
        'Quixeramobim',
        'Quixeré',
        'Redenção',
        'Reriutaba',
        'Russas',
        'Saboeiro',
        'Salitre',
        'Santa Quitéria',
        'Santana do Acaraú',
        'Santana do Cariri',
        'Senador Pompeu',
        'Senador Sá',
        'Sobral',
        'Solonópole',
        'São Benedito',
        'São Gonçalo do Amarante',
        'São João do Jaguaribe',
        'São Luís do Curu',
        'Tabuleiro do Norte',
        'Tamboril',
        'Tarrafas',
        'Tauá',
        'Tejuçuoca',
        'Tianguá',
        'Trairi',
        'Tururu',
        'Ubajara',
        'Umari',
        'Umirim',
        'Uruburetama',
        'Uruoca',
        'Varjota',
        'Viçosa do Ceará',
        'Várzea Alegre'
    ],
    'DF': [
        'Brasília'
    ],
    'ES': [
        'Afonso Cláudio',
        'Alegre',
        'Alfredo Chaves',
        'Alto Rio Novo',
        'Anchieta',
        'Apiacá',
        'Aracruz',
        'Atílio Vivácqua',
        'Baixo Guandu',
        'Barra de São Francisco',
        'Boa Esperança',
        'Bom Jesus do Norte',
        'Brejetuba',
        'Cachoeiro de Itapemirim',
        'Cariacica',
        'Castelo',
        'Colatina',
        'Conceição da Barra',
        'Conceição do Castelo',
        'Divino de São Lourenço',
        'Domingos Martins',
        'Dores do Rio Preto',
        'Ecoporanga',
        'Fundão',
        'Governador Lindenberg',
        'Guarapari',
        'Guaçuí',
        'Ibatiba',
        'Ibiraçu',
        'Ibitirama',
        'Iconha',
        'Irupi',
        'Itaguaçu',
        'Itapemirim',
        'Itarana',
        'Iúna',
        'Jaguaré',
        'Jerônimo Monteiro',
        'João Neiva',
        'Laranja da Terra',
        'Linhares',
        'Mantenópolis',
        'Marataízes',
        'Marechal Floriano',
        'Marilândia',
        'Mimoso do Sul',
        'Montanha',
        'Mucurici',
        'Muniz Freire',
        'Muqui',
        'Nova Venécia',
        'Pancas',
        'Pedro Canário',
        'Pinheiros',
        'Piúma',
        'Ponto Belo',
        'Presidente Kennedy',
        'Rio Bananal',
        'Rio Novo do Sul',
        'Santa Leopoldina',
        'Santa Maria de Jetibá',
        'Santa Teresa',
        'Serra',
        'Sooretama',
        'São Domingos do Norte',
        'São Gabriel da Palha',
        'São José do Calçado',
        'São Mateus',
        'São Roque do Canaã',
        'Vargem Alta',
        'Venda Nova do Imigrante',
        'Viana',
        'Vila Pavão',
        'Vila Valério',
        'Vila Velha',
        'Vitória',
        'Água Doce do Norte',
        'Águia Branca'
    ],
    'EX': [
        ''
    ],
    'GO': [
        'Abadia de Goiás',
        'Abadiânia',
        'Acreúna',
        'Adelândia',
        'Alexânia',
        'Aloândia',
        'Alto Horizonte',
        'Alto Paraíso de Goiás',
        'Alvorada do Norte',
        'Amaralina',
        'Americano do Brasil',
        'Amorinópolis',
        'Anhanguera',
        'Anicuns',
        'Anápolis',
        'Aparecida de Goiânia',
        'Aparecida do Rio Doce',
        'Aporé',
        'Aragarças',
        'Aragoiânia',
        'Araguapaz',
        'Araçu',
        'Arenópolis',
        'Aruanã',
        'Aurilândia',
        'Avelinópolis',
        'Baliza',
        'Barro Alto',
        'Bela Vista de Goiás',
        'Bom Jardim de Goiás',
        'Bom Jesus de Goiás',
        'Bonfinópolis',
        'Bonópolis',
        'Brazabrantes',
        'Britânia',
        'Buriti Alegre',
        'Buriti de Goiás',
        'Buritinópolis',
        'Cabeceiras',
        'Cachoeira Alta',
        'Cachoeira Dourada',
        'Cachoeira de Goiás',
        'Caiapônia',
        'Caldas Novas',
        'Caldazinha',
        'Campestre de Goiás',
        'Campinaçu',
        'Campinorte',
        'Campo Alegre de Goiás',
        'Campo Limpo de Goiás',
        'Campos Belos',
        'Campos Verdes',
        'Carmo do Rio Verde',
        'Castelândia',
        'Catalão',
        'Caturaí',
        'Cavalcante',
        'Caçu',
        'Ceres',
        'Cezarina',
        'Chapadão do Céu',
        'Cidade Ocidental',
        'Cocalzinho de Goiás',
        'Colinas do Sul',
        'Corumbaíba',
        'Corumbá de Goiás',
        'Cristalina',
        'Cristianópolis',
        'Crixás',
        'Cromínia',
        'Cumari',
        'Córrego do Ouro',
        'Damianópolis',
        'Damolândia',
        'Davinópolis',
        'Diorama',
        'Divinópolis de Goiás',
        'Doverlândia',
        'Edealina',
        'Edéia',
        'Estrela do Norte',
        'Faina',
        'Fazenda Nova',
        'Firminópolis',
        'Flores de Goiás',
        'Formosa',
        'Formoso',
        'Gameleira de Goiás',
        'Goiandira',
        'Goianira',
        'Goianápolis',
        'Goianésia',
        'Goiatuba',
        'Goiás',
        'Goiânia',
        'Gouvelândia',
        'Guapó',
        'Guarani de Goiás',
        'Guaraíta',
        'Guarinos',
        'Heitoraí',
        'Hidrolina',
        'Hidrolândia',
        'Iaciara',
        'Inaciolândia',
        'Indiara',
        'Inhumas',
        'Ipameri',
        'Ipiranga de Goiás',
        'Iporá',
        'Israelândia',
        'Itaberaí',
        'Itaguari',
        'Itaguaru',
        'Itajá',
        'Itapaci',
        'Itapirapuã',
        'Itapuranga',
        'Itarumã',
        'Itauçu',
        'Itumbiara',
        'Ivolândia',
        'Jandaia',
        'Jaraguá',
        'Jataí',
        'Jaupaci',
        'Jesúpolis',
        'Joviânia',
        'Jussara',
        'Lagoa Santa',
        'Leopoldo de Bulhões',
        'Luziânia',
        'Mairipotaba',
        'Mambaí',
        'Mara Rosa',
        'Marzagão',
        'Matrinchã',
        'Maurilândia',
        'Mimoso de Goiás',
        'Minaçu',
        'Mineiros',
        'Moiporá',
        'Monte Alegre de Goiás',
        'Montes Claros de Goiás',
        'Montividiu',
        'Montividiu do Norte',
        'Morrinhos',
        'Morro Agudo de Goiás',
        'Mossâmedes',
        'Mozarlândia',
        'Mundo Novo',
        'Mutunópolis',
        'Nazário',
        'Nerópolis',
        'Niquelândia',
        'Nova América',
        'Nova Aurora',
        'Nova Crixás',
        'Nova Glória',
        'Nova Iguaçu de Goiás',
        'Nova Roma',
        'Nova Veneza',
        'Novo Brasil',
        'Novo Gama',
        'Novo Planalto',
        'Orizona',
        'Ouro Verde de Goiás',
        'Ouvidor',
        'Padre Bernardo',
        'Palestina de Goiás',
        'Palmeiras de Goiás',
        'Palmelo',
        'Palminópolis',
        'Panamá',
        'Paranaiguara',
        'Paraúna',
        'Perolândia',
        'Petrolina de Goiás',
        'Pilar de Goiás',
        'Piracanjuba',
        'Piranhas',
        'Pirenópolis',
        'Pires do Rio',
        'Planaltina',
        'Pontalina',
        'Porangatu',
        'Porteirão',
        'Portelândia',
        'Posse',
        'Professor Jamil',
        'Quirinópolis',
        'Rialma',
        'Rianápolis',
        'Rio Quente',
        'Rio Verde',
        'Rubiataba',
        'Sanclerlândia',
        'Santa Bárbara de Goiás',
        'Santa Cruz de Goiás',
        'Santa Fé de Goiás',
        'Santa Helena de Goiás',
        'Santa Isabel',
        'Santa Rita do Araguaia',
        'Santa Rita do Novo Destino',
        'Santa Rosa de Goiás',
        'Santa Tereza de Goiás',
        'Santa Terezinha de Goiás',
        'Santo Antônio da Barra',
        'Santo Antônio de Goiás',
        'Santo Antônio do Descoberto',
        'Senador Canedo',
        'Serranópolis',
        'Silvânia',
        'Simolândia',
        'São Domingos',
        'São Francisco de Goiás',
        'São João d\'Aliança',
        'São João da Paraúna',
        'São Luiz do Norte',
        'São Luís de Montes Belos',
        'São Miguel do Araguaia',
        'São Miguel do Passa Quatro',
        'São Patrício',
        'São Simão',
        'Sítio d\'Abadia',
        'Taquaral de Goiás',
        'Teresina de Goiás',
        'Terezópolis de Goiás',
        'Trindade',
        'Trombas',
        'Três Ranchos',
        'Turvelândia',
        'Turvânia',
        'Uirapuru',
        'Uruana',
        'Uruaçu',
        'Urutaí',
        'Valparaíso de Goiás',
        'Varjão',
        'Vianópolis',
        'Vicentinópolis',
        'Vila Boa',
        'Vila Propício',
        'Água Fria de Goiás',
        'Água Limpa',
        'Águas Lindas de Goiás'
    ],
    'MA': [
        'Afonso Cunha',
        'Alcântara',
        'Aldeias Altas',
        'Altamira do Maranhão',
        'Alto Alegre do Maranhão',
        'Alto Alegre do Pindaré',
        'Alto Parnaíba',
        'Amapá do Maranhão',
        'Amarante do Maranhão',
        'Anajatuba',
        'Anapurus',
        'Apicum-Açu',
        'Araguanã',
        'Araioses',
        'Arame',
        'Arari',
        'Axixá',
        'Açailândia',
        'Bacabal',
        'Bacabeira',
        'Bacuri',
        'Bacurituba',
        'Balsas',
        'Barra do Corda',
        'Barreirinhas',
        'Barão de Grajaú',
        'Bela Vista do Maranhão',
        'Belágua',
        'Benedito Leite',
        'Bequimão',
        'Bernardo do Mearim',
        'Boa Vista do Gurupi',
        'Bom Jardim',
        'Bom Jesus das Selvas',
        'Bom Lugar',
        'Brejo',
        'Brejo de Areia',
        'Buriti',
        'Buriti Bravo',
        'Buriticupu',
        'Buritirana',
        'Cachoeira Grande',
        'Cajapió',
        'Cajari',
        'Campestre do Maranhão',
        'Cantanhede',
        'Capinzal do Norte',
        'Carolina',
        'Carutapera',
        'Caxias',
        'Cedral',
        'Central do Maranhão',
        'Centro Novo do Maranhão',
        'Centro do Guilherme',
        'Chapadinha',
        'Cidelândia',
        'Codó',
        'Coelho Neto',
        'Colinas',
        'Conceição do Lago-Açu',
        'Coroatá',
        'Cururupu',
        'Cândido Mendes',
        'Davinópolis',
        'Dom Pedro',
        'Duque Bacelar',
        'Esperantinópolis',
        'Estreito',
        'Feira Nova do Maranhão',
        'Fernando Falcão',
        'Formosa da Serra Negra',
        'Fortaleza dos Nogueiras',
        'Fortuna',
        'Godofredo Viana',
        'Gonçalves Dias',
        'Governador Archer',
        'Governador Edison Lobão',
        'Governador Eugênio Barros',
        'Governador Luiz Rocha',
        'Governador Newton Bello',
        'Governador Nunes Freire',
        'Grajaú',
        'Graça Aranha',
        'Guimarães',
        'Humberto de Campos',
        'Icatu',
        'Igarapé Grande',
        'Igarapé do Meio',
        'Imperatriz',
        'Itaipava do Grajaú',
        'Itapecuru Mirim',
        'Itinga do Maranhão',
        'Jatobá',
        'Jenipapo dos Vieiras',
        'Joselândia',
        'João Lisboa',
        'Junco do Maranhão',
        'Lago Verde',
        'Lago da Pedra',
        'Lago do Junco',
        'Lago dos Rodrigues',
        'Lagoa Grande do Maranhão',
        'Lagoa do Mato',
        'Lajeado Novo',
        'Lima Campos',
        'Loreto',
        'Luís Domingues',
        'Magalhães de Almeida',
        'Maracaçumé',
        'Marajá do Sena',
        'Maranhãozinho',
        'Mata Roma',
        'Matinha',
        'Matões',
        'Matões do Norte',
        'Milagres do Maranhão',
        'Mirador',
        'Miranda do Norte',
        'Mirinzal',
        'Montes Altos',
        'Monção',
        'Morros',
        'Nina Rodrigues',
        'Nova Colinas',
        'Nova Iorque',
        'Nova Olinda do Maranhão',
        'Olho d\'Água das Cunhãs',
        'Olinda Nova do Maranhão',
        'Palmeirândia',
        'Paraibano',
        'Parnarama',
        'Passagem Franca',
        'Pastos Bons',
        'Paulino Neves',
        'Paulo Ramos',
        'Paço do Lumiar',
        'Pedreiras',
        'Pedro do Rosário',
        'Penalva',
        'Peri Mirim',
        'Peritoró',
        'Pindaré-Mirim',
        'Pinheiro',
        'Pio XII',
        'Pirapemas',
        'Porto Franco',
        'Porto Rico do Maranhão',
        'Poção de Pedras',
        'Presidente Dutra',
        'Presidente Juscelino',
        'Presidente Médici',
        'Presidente Sarney',
        'Presidente Vargas',
        'Primeira Cruz',
        'Raposa',
        'Riachão',
        'Ribamar Fiquene',
        'Rosário',
        'Sambaíba',
        'Santa Filomena do Maranhão',
        'Santa Helena',
        'Santa Inês',
        'Santa Luzia',
        'Santa Luzia do Paruá',
        'Santa Quitéria do Maranhão',
        'Santa Rita',
        'Santana do Maranhão',
        'Santo Amaro do Maranhão',
        'Santo Antônio dos Lopes',
        'Satubinha',
        'Senador Alexandre Costa',
        'Senador La Rocque',
        'Serrano do Maranhão',
        'Sucupira do Norte',
        'Sucupira do Riachão',
        'São Benedito do Rio Preto',
        'São Bento',
        'São Bernardo',
        'São Domingos do Azeitão',
        'São Domingos do Maranhão',
        'São Francisco do Brejão',
        'São Francisco do Maranhão',
        'São Félix de Balsas',
        'São José de Ribamar',
        'São José dos Basílios',
        'São João Batista',
        'São João do Carú',
        'São João do Paraíso',
        'São João do Soter',
        'São João dos Patos',
        'São Luís',
        'São Luís Gonzaga do Maranhão',
        'São Mateus do Maranhão',
        'São Pedro da Água Branca',
        'São Pedro dos Crentes',
        'São Raimundo das Mangabeiras',
        'São Raimundo do Doca Bezerra',
        'São Roberto',
        'São Vicente Ferrer',
        'Sítio Novo',
        'Tasso Fragoso',
        'Timbiras',
        'Timon',
        'Trizidela do Vale',
        'Tufilândia',
        'Tuntum',
        'Turiaçu',
        'Turilândia',
        'Tutóia',
        'Urbano Santos',
        'Vargem Grande',
        'Viana',
        'Vila Nova dos Martírios',
        'Vitorino Freire',
        'Vitória do Mearim',
        'Zé Doca',
        'Água Doce do Maranhão'
    ],
    'MG': [
        'Abadia dos Dourados',
        'Abaeté',
        'Abre Campo',
        'Acaiaca',
        'Aguanil',
        'Aimorés',
        'Aiuruoca',
        'Alagoa',
        'Albertina',
        'Alfenas',
        'Alfredo Vasconcelos',
        'Almenara',
        'Alpercata',
        'Alpinópolis',
        'Alterosa',
        'Alto Caparaó',
        'Alto Jequitibá',
        'Alto Rio Doce',
        'Alvarenga',
        'Alvinópolis',
        'Alvorada de Minas',
        'Além Paraíba',
        'Amparo do Serra',
        'Andradas',
        'Andrelândia',
        'Angelândia',
        'Antônio Carlos',
        'Antônio Dias',
        'Antônio Prado de Minas',
        'Aracitaba',
        'Araguari',
        'Arantina',
        'Araponga',
        'Araporã',
        'Arapuá',
        'Araxá',
        'Araçaí',
        'Araçuaí',
        'Araújos',
        'Arceburgo',
        'Arcos',
        'Areado',
        'Argirita',
        'Aricanduva',
        'Arinos',
        'Astolfo Dutra',
        'Ataléia',
        'Augusto de Lima',
        'Açucena',
        'Baependi',
        'Baldim',
        'Bambuí',
        'Bandeira',
        'Bandeira do Sul',
        'Barbacena',
        'Barra Longa',
        'Barroso',
        'Barão de Cocais',
        'Barão de Monte Alto',
        'Bela Vista de Minas',
        'Belmiro Braga',
        'Belo Horizonte',
        'Belo Oriente',
        'Belo Vale',
        'Berilo',
        'Berizal',
        'Bertópolis',
        'Betim',
        'Bias Fortes',
        'Bicas',
        'Biquinhas',
        'Boa Esperança',
        'Bocaina de Minas',
        'Bocaiúva',
        'Bom Despacho',
        'Bom Jardim de Minas',
        'Bom Jesus da Penha',
        'Bom Jesus do Amparo',
        'Bom Jesus do Galho',
        'Bom Repouso',
        'Bom Sucesso',
        'Bonfim',
        'Bonfinópolis de Minas',
        'Bonito de Minas',
        'Borda da Mata',
        'Botelhos',
        'Botumirim',
        'Brasilândia de Minas',
        'Brasília de Minas',
        'Brazópolis',
        'Braúnas',
        'Brumadinho',
        'Brás Pires',
        'Bueno Brandão',
        'Buenópolis',
        'Bugre',
        'Buritis',
        'Buritizeiro',
        'Cabeceira Grande',
        'Cabo Verde',
        'Cachoeira Dourada',
        'Cachoeira da Prata',
        'Cachoeira de Minas',
        'Cachoeira de Pajeú',
        'Caetanópolis',
        'Caeté',
        'Caiana',
        'Cajuri',
        'Caldas',
        'Camacho',
        'Camanducaia',
        'Cambuquira',
        'Cambuí',
        'Campanha',
        'Campanário',
        'Campestre',
        'Campina Verde',
        'Campo Azul',
        'Campo Belo',
        'Campo Florido',
        'Campo do Meio',
        'Campos Altos',
        'Campos Gerais',
        'Cana Verde',
        'Canaã',
        'Candeias',
        'Cantagalo',
        'Canápolis',
        'Caparaó',
        'Capela Nova',
        'Capelinha',
        'Capetinga',
        'Capim Branco',
        'Capinópolis',
        'Capitão Andrade',
        'Capitão Enéas',
        'Capitólio',
        'Caputira',
        'Caranaíba',
        'Carandaí',
        'Carangola',
        'Caratinga',
        'Caraí',
        'Carbonita',
        'Careaçu',
        'Carlos Chagas',
        'Carmo da Cachoeira',
        'Carmo da Mata',
        'Carmo de Minas',
        'Carmo do Cajuru',
        'Carmo do Paranaíba',
        'Carmo do Rio Claro',
        'Carmésia',
        'Carmópolis de Minas',
        'Carneirinho',
        'Carrancas',
        'Carvalhos',
        'Carvalhópolis',
        'Casa Grande',
        'Cascalho Rico',
        'Cataguases',
        'Catas Altas',
        'Catas Altas da Noruega',
        'Catuji',
        'Catuti',
        'Caxambu',
        'Cedro do Abaeté',
        'Central de Minas',
        'Centralina',
        'Chalé',
        'Chapada Gaúcha',
        'Chapada do Norte',
        'Chiador',
        'Chácara',
        'Cipotânea',
        'Claraval',
        'Claro dos Poções',
        'Cláudio',
        'Coimbra',
        'Coluna',
        'Comendador Gomes',
        'Comercinho',
        'Conceição da Aparecida',
        'Conceição da Barra de Minas',
        'Conceição das Alagoas',
        'Conceição das Pedras',
        'Conceição de Ipanema',
        'Conceição do Mato Dentro',
        'Conceição do Pará',
        'Conceição do Rio Verde',
        'Conceição dos Ouros',
        'Confins',
        'Congonhal',
        'Congonhas',
        'Congonhas do Norte',
        'Conquista',
        'Conselheiro Lafaiete',
        'Conselheiro Pena',
        'Consolação',
        'Contagem',
        'Coqueiral',
        'Coração de Jesus',
        'Cordisburgo',
        'Cordislândia',
        'Corinto',
        'Coroaci',
        'Coromandel',
        'Coronel Fabriciano',
        'Coronel Murta',
        'Coronel Pacheco',
        'Coronel Xavier Chaves',
        'Couto de Magalhães de Minas',
        'Cristais',
        'Cristiano Otoni',
        'Cristina',
        'Cristália',
        'Crisólita',
        'Crucilândia',
        'Cruzeiro da Fortaleza',
        'Cruzília',
        'Cuparaque',
        'Curral de Dentro',
        'Curvelo',
        'Cássia',
        'Córrego Danta',
        'Córrego Fundo',
        'Córrego Novo',
        'Córrego do Bom Jesus',
        'Cônego Marinho',
        'Datas',
        'Delfim Moreira',
        'Delfinópolis',
        'Delta',
        'Descoberto',
        'Desterro de Entre Rios',
        'Desterro do Melo',
        'Diamantina',
        'Diogo de Vasconcelos',
        'Dionísio',
        'Divino',
        'Divino das Laranjeiras',
        'Divinolândia de Minas',
        'Divinésia',
        'Divinópolis',
        'Divisa Alegre',
        'Divisa Nova',
        'Divisópolis',
        'Dom Bosco',
        'Dom Cavati',
        'Dom Joaquim',
        'Dom Silvério',
        'Dom Viçoso',
        'Dona Euzébia',
        'Dores de Campos',
        'Dores de Guanhães',
        'Dores do Indaiá',
        'Dores do Turvo',
        'Doresópolis',
        'Douradoquara',
        'Durandé',
        'Elói Mendes',
        'Engenheiro Caldas',
        'Engenheiro Navarro',
        'Entre Folhas',
        'Entre Rios de Minas',
        'Ervália',
        'Esmeraldas',
        'Espera Feliz',
        'Espinosa',
        'Espírito Santo do Dourado',
        'Estiva',
        'Estrela Dalva',
        'Estrela do Indaiá',
        'Estrela do Sul',
        'Eugenópolis',
        'Ewbank da Câmara',
        'Extrema',
        'Fama',
        'Faria Lemos',
        'Felisburgo',
        'Felixlândia',
        'Felício dos Santos',
        'Fernandes Tourinho',
        'Ferros',
        'Fervedouro',
        'Florestal',
        'Formiga',
        'Formoso',
        'Fortaleza de Minas',
        'Fortuna de Minas',
        'Francisco Badaró',
        'Francisco Dumont',
        'Francisco Sá',
        'Franciscópolis',
        'Frei Gaspar',
        'Frei Inocêncio',
        'Frei Lagonegro',
        'Fronteira',
        'Fronteira dos Vales',
        'Fruta de Leite',
        'Frutal',
        'Funilândia',
        'Galiléia',
        'Gameleiras',
        'Glaucilândia',
        'Goiabeira',
        'Goianá',
        'Gonzaga',
        'Gonçalves',
        'Gouveia',
        'Governador Valadares',
        'Grupiara',
        'Grão Mogol',
        'Guanhães',
        'Guapé',
        'Guaraciaba',
        'Guaraciama',
        'Guarani',
        'Guaranésia',
        'Guarará',
        'Guarda-Mor',
        'Guaxupé',
        'Guidoval',
        'Guimarânia',
        'Guiricema',
        'Gurinhatã',
        'Heliodora',
        'Iapu',
        'Ibertioga',
        'Ibiaí',
        'Ibiracatu',
        'Ibiraci',
        'Ibirité',
        'Ibitiúra de Minas',
        'Ibituruna',
        'Ibiá',
        'Icaraí de Minas',
        'Igarapé',
        'Igaratinga',
        'Iguatama',
        'Ijaci',
        'Ilicínea',
        'Imbé de Minas',
        'Inconfidentes',
        'Indaiabira',
        'Indianópolis',
        'Ingaí',
        'Inhapim',
        'Inhaúma',
        'Inimutaba',
        'Ipaba',
        'Ipanema',
        'Ipatinga',
        'Ipiaçu',
        'Ipuiúna',
        'Iraí de Minas',
        'Itabira',
        'Itabirinha',
        'Itabirito',
        'Itacambira',
        'Itacarambi',
        'Itaguara',
        'Itaipé',
        'Itajubá',
        'Itamarandiba',
        'Itamarati de Minas',
        'Itambacuri',
        'Itambé do Mato Dentro',
        'Itamogi',
        'Itamonte',
        'Itanhandu',
        'Itanhomi',
        'Itaobim',
        'Itapagipe',
        'Itapecerica',
        'Itapeva',
        'Itatiaiuçu',
        'Itaverava',
        'Itaú de Minas',
        'Itaúna',
        'Itinga',
        'Itueta',
        'Ituiutaba',
        'Itumirim',
        'Iturama',
        'Itutinga',
        'Jaboticatubas',
        'Jacinto',
        'Jacutinga',
        'Jacuí',
        'Jaguaraçu',
        'Jampruca',
        'Janaúba',
        'Januária',
        'Japaraíba',
        'Japonvar',
        'Jaíba',
        'Jeceaba',
        'Jenipapo de Minas',
        'Jequeri',
        'Jequitaí',
        'Jequitibá',
        'Jequitinhonha',
        'Jesuânia',
        'Joanésia',
        'Joaquim Felício',
        'Joaíma',
        'Jordânia',
        'Josenópolis',
        'José Gonçalves de Minas',
        'José Raydan',
        'João Monlevade',
        'João Pinheiro',
        'Juatuba',
        'Juiz de Fora',
        'Juramento',
        'Juruaia',
        'Juvenília',
        'Ladainha',
        'Lagamar',
        'Lagoa Dourada',
        'Lagoa Formosa',
        'Lagoa Grande',
        'Lagoa Santa',
        'Lagoa da Prata',
        'Lagoa dos Patos',
        'Lajinha',
        'Lambari',
        'Lamim',
        'Laranjal',
        'Lassance',
        'Lavras',
        'Leandro Ferreira',
        'Leme do Prado',
        'Leopoldina',
        'Liberdade',
        'Lima Duarte',
        'Limeira do Oeste',
        'Lontra',
        'Luisburgo',
        'Luislândia',
        'Luminárias',
        'Luz',
        'Machacalis',
        'Machado',
        'Madre de Deus de Minas',
        'Malacacheta',
        'Mamonas',
        'Manga',
        'Manhuaçu',
        'Manhumirim',
        'Mantena',
        'Mar de Espanha',
        'Maravilhas',
        'Maria da Fé',
        'Mariana',
        'Marilac',
        'Maripá de Minas',
        'Marliéria',
        'Marmelópolis',
        'Martinho Campos',
        'Martins Soares',
        'Mata Verde',
        'Materlândia',
        'Mateus Leme',
        'Mathias Lobato',
        'Matias Barbosa',
        'Matias Cardoso',
        'Matipó',
        'Mato Verde',
        'Matozinhos',
        'Matutina',
        'Medeiros',
        'Medina',
        'Mendes Pimentel',
        'Mercês',
        'Mesquita',
        'Minas Novas',
        'Minduri',
        'Mirabela',
        'Miradouro',
        'Miravânia',
        'Miraí',
        'Moeda',
        'Moema',
        'Monjolos',
        'Monsenhor Paulo',
        'Montalvânia',
        'Monte Alegre de Minas',
        'Monte Azul',
        'Monte Belo',
        'Monte Carmelo',
        'Monte Formoso',
        'Monte Santo de Minas',
        'Monte Sião',
        'Montes Claros',
        'Montezuma',
        'Morada Nova de Minas',
        'Morro da Garça',
        'Morro do Pilar',
        'Munhoz',
        'Muriaé',
        'Mutum',
        'Muzambinho',
        'Mário Campos',
        'Nacip Raydan',
        'Nanuque',
        'Naque',
        'Natalândia',
        'Natércia',
        'Nazareno',
        'Nepomuceno',
        'Ninheira',
        'Nova Belém',
        'Nova Era',
        'Nova Lima',
        'Nova Módica',
        'Nova Ponte',
        'Nova Porteirinha',
        'Nova Resende',
        'Nova Serrana',
        'Nova União',
        'Novo Cruzeiro',
        'Novo Oriente de Minas',
        'Novorizonte',
        'Olaria',
        'Olhos-d\'Água',
        'Oliveira',
        'Oliveira Fortes',
        'Olímpio Noronha',
        'Onça de Pitangui',
        'Oratórios',
        'Orizânia',
        'Ouro Branco',
        'Ouro Fino',
        'Ouro Preto',
        'Ouro Verde de Minas',
        'Padre Carvalho',
        'Padre Paraíso',
        'Pai Pedro',
        'Paineiras',
        'Pains',
        'Paiva',
        'Palma',
        'Palmópolis',
        'Papagaios',
        'Paracatu',
        'Paraguaçu',
        'Paraisópolis',
        'Paraopeba',
        'Pará de Minas',
        'Passa Quatro',
        'Passa Tempo',
        'Passa Vinte',
        'Passabém',
        'Passos',
        'Patis',
        'Patos de Minas',
        'Patrocínio',
        'Patrocínio do Muriaé',
        'Paula Cândido',
        'Paulistas',
        'Pavão',
        'Pedra Azul',
        'Pedra Bonita',
        'Pedra Dourada',
        'Pedra do Anta',
        'Pedra do Indaiá',
        'Pedralva',
        'Pedras de Maria da Cruz',
        'Pedrinópolis',
        'Pedro Leopoldo',
        'Pedro Teixeira',
        'Pequeri',
        'Pequi',
        'Perdigão',
        'Perdizes',
        'Perdões',
        'Periquito',
        'Pescador',
        'Peçanha',
        'Piau',
        'Piedade de Caratinga',
        'Piedade de Ponte Nova',
        'Piedade do Rio Grande',
        'Piedade dos Gerais',
        'Pimenta',
        'Pingo-d\'Água',
        'Pintópolis',
        'Piracema',
        'Pirajuba',
        'Piranga',
        'Piranguinho',
        'Piranguçu',
        'Pirapetinga',
        'Pirapora',
        'Piraúba',
        'Pitangui',
        'Piumhi',
        'Planura',
        'Pocrane',
        'Pompéu',
        'Ponte Nova',
        'Ponto Chique',
        'Ponto dos Volantes',
        'Porteirinha',
        'Porto Firme',
        'Poté',
        'Pouso Alegre',
        'Pouso Alto',
        'Poço Fundo',
        'Poços de Caldas',
        'Prados',
        'Prata',
        'Pratinha',
        'Pratápolis',
        'Presidente Bernardes',
        'Presidente Juscelino',
        'Presidente Kubitschek',
        'Presidente Olegário',
        'Prudente de Morais',
        'Quartel Geral',
        'Queluzito',
        'Raposos',
        'Raul Soares',
        'Recreio',
        'Reduto',
        'Resende Costa',
        'Resplendor',
        'Ressaquinha',
        'Riachinho',
        'Riacho dos Machados',
        'Ribeirão Vermelho',
        'Ribeirão das Neves',
        'Rio Acima',
        'Rio Casca',
        'Rio Doce',
        'Rio Espera',
        'Rio Manso',
        'Rio Novo',
        'Rio Paranaíba',
        'Rio Pardo de Minas',
        'Rio Piracicaba',
        'Rio Pomba',
        'Rio Preto',
        'Rio Vermelho',
        'Rio do Prado',
        'Ritápolis',
        'Rochedo de Minas',
        'Rodeiro',
        'Romaria',
        'Rosário da Limeira',
        'Rubelita',
        'Rubim',
        'Sabará',
        'Sabinópolis',
        'Sacramento',
        'Salinas',
        'Salto da Divisa',
        'Santa Bárbara',
        'Santa Bárbara do Leste',
        'Santa Bárbara do Monte Verde',
        'Santa Bárbara do Tugúrio',
        'Santa Cruz de Minas',
        'Santa Cruz de Salinas',
        'Santa Cruz do Escalvado',
        'Santa Efigênia de Minas',
        'Santa Fé de Minas',
        'Santa Helena de Minas',
        'Santa Juliana',
        'Santa Luzia',
        'Santa Margarida',
        'Santa Maria de Itabira',
        'Santa Maria do Salto',
        'Santa Maria do Suaçuí',
        'Santa Rita de Caldas',
        'Santa Rita de Ibitipoca',
        'Santa Rita de Jacutinga',
        'Santa Rita de Minas',
        'Santa Rita do Itueto',
        'Santa Rita do Sapucaí',
        'Santa Rosa da Serra',
        'Santa Vitória',
        'Santana da Vargem',
        'Santana de Cataguases',
        'Santana de Pirapama',
        'Santana do Deserto',
        'Santana do Garambéu',
        'Santana do Jacaré',
        'Santana do Manhuaçu',
        'Santana do Paraíso',
        'Santana do Riacho',
        'Santana dos Montes',
        'Santo Antônio do Amparo',
        'Santo Antônio do Aventureiro',
        'Santo Antônio do Grama',
        'Santo Antônio do Itambé',
        'Santo Antônio do Jacinto',
        'Santo Antônio do Monte',
        'Santo Antônio do Retiro',
        'Santo Antônio do Rio Abaixo',
        'Santo Hipólito',
        'Santos Dumont',
        'Sapucaí-Mirim',
        'Sardoá',
        'Sarzedo',
        'Sem-Peixe',
        'Senador Amaral',
        'Senador Cortes',
        'Senador Firmino',
        'Senador José Bento',
        'Senador Modestino Gonçalves',
        'Senhora de Oliveira',
        'Senhora do Porto',
        'Senhora dos Remédios',
        'Sericita',
        'Seritinga',
        'Serra Azul de Minas',
        'Serra da Saudade',
        'Serra do Salitre',
        'Serra dos Aimorés',
        'Serrania',
        'Serranos',
        'Serranópolis de Minas',
        'Serro',
        'Sete Lagoas',
        'Setubinha',
        'Silveirânia',
        'Silvianópolis',
        'Simonésia',
        'Simão Pereira',
        'Sobrália',
        'Soledade de Minas',
        'São Bento Abade',
        'São Brás do Suaçuí',
        'São Domingos das Dores',
        'São Domingos do Prata',
        'São Francisco',
        'São Francisco de Paula',
        'São Francisco de Sales',
        'São Francisco do Glória',
        'São Félix de Minas',
        'São Geraldo',
        'São Geraldo da Piedade',
        'São Geraldo do Baixio',
        'São Gonçalo do Abaeté',
        'São Gonçalo do Pará',
        'São Gonçalo do Rio Abaixo',
        'São Gonçalo do Rio Preto',
        'São Gonçalo do Sapucaí',
        'São Gotardo',
        'São Joaquim de Bicas',
        'São José da Barra',
        'São José da Lapa',
        'São José da Safira',
        'São José da Varginha',
        'São José do Alegre',
        'São José do Divino',
        'São José do Goiabal',
        'São José do Jacuri',
        'São José do Mantimento',
        'São João Batista do Glória',
        'São João Evangelista',
        'São João Nepomuceno',
        'São João da Lagoa',
        'São João da Mata',
        'São João da Ponte',
        'São João das Missões',
        'São João del Rei',
        'São João do Manhuaçu',
        'São João do Manteninha',
        'São João do Oriente',
        'São João do Pacuí',
        'São João do Paraíso',
        'São Lourenço',
        'São Miguel do Anta',
        'São Pedro da União',
        'São Pedro do Suaçuí',
        'São Pedro dos Ferros',
        'São Romão',
        'São Roque de Minas',
        'São Sebastião da Bela Vista',
        'São Sebastião da Vargem Alegre',
        'São Sebastião do Anta',
        'São Sebastião do Maranhão',
        'São Sebastião do Oeste',
        'São Sebastião do Paraíso',
        'São Sebastião do Rio Preto',
        'São Sebastião do Rio Verde',
        'São Tiago',
        'São Tomás de Aquino',
        'São Tomé das Letras',
        'São Vicente de Minas',
        'Tabuleiro',
        'Taiobeiras',
        'Taparuba',
        'Tapira',
        'Tapiraí',
        'Taquaraçu de Minas',
        'Tarumirim',
        'Teixeiras',
        'Teófilo Otoni',
        'Timóteo',
        'Tiradentes',
        'Tiros',
        'Tocantins',
        'Tocos do Moji',
        'Toledo',
        'Tombos',
        'Três Corações',
        'Três Marias',
        'Três Pontas',
        'Tumiritinga',
        'Tupaciguara',
        'Turmalina',
        'Turvolândia',
        'Ubaporanga',
        'Ubaí',
        'Uberaba',
        'Uberlândia',
        'Ubá',
        'Umburatiba',
        'Unaí',
        'União de Minas',
        'Uruana de Minas',
        'Urucuia',
        'Urucânia',
        'Vargem Alegre',
        'Vargem Bonita',
        'Vargem Grande do Rio Pardo',
        'Varginha',
        'Varjão de Minas',
        'Varzelândia',
        'Vazante',
        'Verdelândia',
        'Veredinha',
        'Vermelho Novo',
        'Veríssimo',
        'Vespasiano',
        'Vieiras',
        'Virgem da Lapa',
        'Virginópolis',
        'Virgolândia',
        'Virgínia',
        'Visconde do Rio Branco',
        'Viçosa',
        'Volta Grande',
        'Várzea da Palma',
        'Wenceslau Braz',
        'Água Boa',
        'Água Comprida',
        'Águas Formosas',
        'Águas Vermelhas'
    ],
    'MS': [
        '',
        'Alcinópolis',
        'Amambai',
        'Anastácio',
        'Anaurilândia',
        'Angélica',
        'Antônio João',
        'Aparecida do Taboado',
        'Aquidauana',
        'Aral Moreira',
        'Bandeirantes',
        'Bataguassu',
        'Batayporã',
        'Bela Vista',
        'Bodoquena',
        'Bonito',
        'Brasilândia',
        'Caarapó',
        'Camapuã',
        'Campo Grande',
        'Caracol',
        'Cassilândia',
        'Chapadão do Sul',
        'Corguinho',
        'Corumbá',
        'Costa Rica',
        'Coxim',
        'Deodápolis',
        'Dois Irmãos do Buriti',
        'Douradina',
        'Dourados',
        'Eldorado',
        'Figueirão',
        'Fátima do Sul',
        'Glória de Dourados',
        'Guia Lopes da Laguna',
        'Iguatemi',
        'Inocência',
        'Itaporã',
        'Itaquiraí',
        'Ivinhema',
        'Japorã',
        'Jaraguari',
        'Jardim',
        'Jateí',
        'Juti',
        'Ladário',
        'Laguna Carapã',
        'Maracaju',
        'Miranda',
        'Mundo Novo',
        'Naviraí',
        'Nioaque',
        'Nova Alvorada do Sul',
        'Nova Andradina',
        'Novo Horizonte do Sul',
        'Paranaíba',
        'Paranhos',
        'Paraíso das Águas',
        'Pedro Gomes',
        'Ponta Porã',
        'Porto Murtinho',
        'Ribas do Rio Pardo',
        'Rio Brilhante',
        'Rio Negro',
        'Rio Verde de Mato Grosso',
        'Rochedo',
        'Santa Rita do Pardo',
        'Selvíria',
        'Sete Quedas',
        'Sidrolândia',
        'Sonora',
        'São Gabriel do Oeste',
        'Tacuru',
        'Taquarussu',
        'Terenos',
        'Três Lagoas',
        'Vicentina',
        'Água Clara'
    ],
    'MT': [
        'Acorizal',
        'Alta Floresta',
        'Alto Araguaia',
        'Alto Boa Vista',
        'Alto Garças',
        'Alto Paraguai',
        'Alto Taquari',
        'Apiacás',
        'Araguaiana',
        'Araguainha',
        'Araputanga',
        'Arenápolis',
        'Aripuanã',
        'Barra do Bugres',
        'Barra do Garças',
        'Barão de Melgaço',
        'Bom Jesus do Araguaia',
        'Brasnorte',
        'Campinápolis',
        'Campo Novo do Parecis',
        'Campo Verde',
        'Campos de Júlio',
        'Canabrava do Norte',
        'Canarana',
        'Carlinda',
        'Castanheira',
        'Chapada dos Guimarães',
        'Cláudia',
        'Cocalinho',
        'Colniza',
        'Colíder',
        'Comodoro',
        'Confresa',
        'Conquista D\'Oeste',
        'Cotriguaçu',
        'Cuiabá',
        'Curvelândia',
        'Cáceres',
        'Denise',
        'Diamantino',
        'Dom Aquino',
        'Feliz Natal',
        'Figueirópolis D\'Oeste',
        'Gaúcha do Norte',
        'General Carneiro',
        'Glória D\'Oeste',
        'Guarantã do Norte',
        'Guiratinga',
        'Indiavaí',
        'Ipiranga do Norte',
        'Itanhangá',
        'Itaúba',
        'Itiquira',
        'Jaciara',
        'Jangada',
        'Jauru',
        'Juara',
        'Juruena',
        'Juscimeira',
        'Juína',
        'Lambari D\'Oeste',
        'Lucas do Rio Verde',
        'Luciara',
        'Marcelândia',
        'Matupá',
        'Mirassol d\'Oeste',
        'Nobres',
        'Nortelândia',
        'Nossa Senhora do Livramento',
        'Nova Bandeirantes',
        'Nova Brasilândia',
        'Nova Canaã do Norte',
        'Nova Guarita',
        'Nova Lacerda',
        'Nova Marilândia',
        'Nova Maringá',
        'Nova Monte Verde',
        'Nova Mutum',
        'Nova Nazaré',
        'Nova Olímpia',
        'Nova Santa Helena',
        'Nova Ubiratã',
        'Nova Xavantina',
        'Novo Horizonte do Norte',
        'Novo Mundo',
        'Novo Santo Antônio',
        'Novo São Joaquim',
        'Paranatinga',
        'Paranaíta',
        'Pedra Preta',
        'Peixoto de Azevedo',
        'Planalto da Serra',
        'Poconé',
        'Pontal do Araguaia',
        'Ponte Branca',
        'Pontes e Lacerda',
        'Porto Alegre do Norte',
        'Porto Esperidião',
        'Porto Estrela',
        'Porto dos Gaúchos',
        'Poxoréu',
        'Primavera do Leste',
        'Querência',
        'Reserva do Cabaçal',
        'Ribeirão Cascalheira',
        'Ribeirãozinho',
        'Rio Branco',
        'Rondolândia',
        'Rondonópolis',
        'Rosário Oeste',
        'Salto do Céu',
        'Santa Carmem',
        'Santa Cruz do Xingu',
        'Santa Rita do Trivelato',
        'Santa Terezinha',
        'Santo Afonso',
        'Santo Antônio do Leste',
        'Santo Antônio do Leverger',
        'Sapezal',
        'Serra Nova Dourada',
        'Sinop',
        'Sorriso',
        'São Félix do Araguaia',
        'São José do Povo',
        'São José do Rio Claro',
        'São José do Xingu',
        'São José dos Quatro Marcos',
        'São Pedro da Cipa',
        'Tabaporã',
        'Tangará da Serra',
        'Tapurah',
        'Terra Nova do Norte',
        'Tesouro',
        'Torixoréu',
        'União do Sul',
        'Vale de São Domingos',
        'Vera',
        'Vila Bela da Santíssima Trindade',
        'Vila Rica',
        'Várzea Grande',
        'Água Boa'
    ],
    'PA': [
        'Abaetetuba',
        'Abel Figueiredo',
        'Acará',
        'Afuá',
        'Alenquer',
        'Almeirim',
        'Altamira',
        'Anajás',
        'Ananindeua',
        'Anapu',
        'Augusto Corrêa',
        'Aurora do Pará',
        'Aveiro',
        'Bagre',
        'Baião',
        'Bannach',
        'Barcarena',
        'Belterra',
        'Belém',
        'Benevides',
        'Bom Jesus do Tocantins',
        'Bonito',
        'Bragança',
        'Brasil Novo',
        'Brejo Grande do Araguaia',
        'Breu Branco',
        'Breves',
        'Bujaru',
        'Cachoeira do Arari',
        'Cachoeira do Piriá',
        'Cametá',
        'Canaã dos Carajás',
        'Capanema',
        'Capitão Poço',
        'Castanhal',
        'Chaves',
        'Colares',
        'Conceição do Araguaia',
        'Concórdia do Pará',
        'Cumaru do Norte',
        'Curionópolis',
        'Curralinho',
        'Curuá',
        'Curuçá',
        'Dom Eliseu',
        'Eldorado do Carajás',
        'Faro',
        'Floresta do Araguaia',
        'Garrafão do Norte',
        'Goianésia do Pará',
        'Gurupá',
        'Igarapé-Açu',
        'Igarapé-Miri',
        'Inhangapi',
        'Ipixuna do Pará',
        'Irituia',
        'Itaituba',
        'Itupiranga',
        'Jacareacanga',
        'Jacundá',
        'Juruti',
        'Limoeiro do Ajuru',
        'Magalhães Barata',
        'Marabá',
        'Maracanã',
        'Marapanim',
        'Marituba',
        'Medicilândia',
        'Melgaço',
        'Mocajuba',
        'Moju',
        'Mojuí dos Campos',
        'Monte Alegre',
        'Muaná',
        'Mãe do Rio',
        'Nova Esperança do Piriá',
        'Nova Ipixuna',
        'Nova Timboteua',
        'Novo Progresso',
        'Novo Repartimento',
        'Oeiras do Pará',
        'Oriximiná',
        'Ourilândia do Norte',
        'Ourém',
        'Pacajá',
        'Palestina do Pará',
        'Paragominas',
        'Parauapebas',
        'Pau D\'Arco',
        'Peixe-Boi',
        'Piçarra',
        'Placas',
        'Ponta de Pedras',
        'Portel',
        'Porto de Moz',
        'Prainha',
        'Primavera',
        'Quatipuru',
        'Redenção',
        'Rio Maria',
        'Rondon do Pará',
        'Rurópolis',
        'Salinópolis',
        'Salvaterra',
        'Santa Bárbara do Pará',
        'Santa Cruz do Arari',
        'Santa Izabel do Pará',
        'Santa Luzia do Pará',
        'Santa Maria das Barreiras',
        'Santa Maria do Pará',
        'Santana do Araguaia',
        'Santarém',
        'Santarém Novo',
        'Santo Antônio do Tauá',
        'Sapucaia',
        'Senador José Porfírio',
        'Soure',
        'São Caetano de Odivelas',
        'São Domingos do Araguaia',
        'São Domingos do Capim',
        'São Francisco do Pará',
        'São Félix do Xingu',
        'São Geraldo do Araguaia',
        'São João da Ponta',
        'São João de Pirabas',
        'São João do Araguaia',
        'São Miguel do Guamá',
        'São Sebastião da Boa Vista',
        'Tailândia',
        'Terra Alta',
        'Terra Santa',
        'Tomé-Açu',
        'Tracuateua',
        'Trairão',
        'Tucumã',
        'Tucuruí',
        'Ulianópolis',
        'Uruará',
        'Vigia',
        'Viseu',
        'Vitória do Xingu',
        'Xinguara',
        'Água Azul do Norte',
        'Óbidos'
    ],
    'PB': [
        'Aguiar',
        'Alagoa Grande',
        'Alagoa Nova',
        'Alagoinha',
        'Alcantil',
        'Algodão de Jandaíra',
        'Alhandra',
        'Amparo',
        'Aparecida',
        'Arara',
        'Araruna',
        'Araçagi',
        'Areia',
        'Areia de Baraúnas',
        'Areial',
        'Aroeiras',
        'Assunção',
        'Bananeiras',
        'Baraúna',
        'Barra de Santa Rosa',
        'Barra de Santana',
        'Barra de São Miguel',
        'Bayeux',
        'Baía da Traição',
        'Belém',
        'Belém do Brejo do Cruz',
        'Bernardino Batista',
        'Boa Ventura',
        'Boa Vista',
        'Bom Jesus',
        'Bom Sucesso',
        'Bonito de Santa Fé',
        'Boqueirão',
        'Borborema',
        'Brejo do Cruz',
        'Brejo dos Santos',
        'Caaporã',
        'Cabaceiras',
        'Cabedelo',
        'Cachoeira dos Índios',
        'Cacimba de Areia',
        'Cacimba de Dentro',
        'Cacimbas',
        'Caiçara',
        'Cajazeiras',
        'Cajazeirinhas',
        'Caldas Brandão',
        'Camalaú',
        'Campina Grande',
        'Capim',
        'Caraúbas',
        'Carrapateira',
        'Casserengue',
        'Catingueira',
        'Catolé do Rocha',
        'Caturité',
        'Conceição',
        'Condado',
        'Conde',
        'Congo',
        'Coremas',
        'Coxixola',
        'Cruz do Espírito Santo',
        'Cubati',
        'Cuitegi',
        'Cuité',
        'Cuité de Mamanguape',
        'Curral Velho',
        'Curral de Cima',
        'Damião',
        'Desterro',
        'Diamante',
        'Dona Inês',
        'Duas Estradas',
        'Emas',
        'Esperança',
        'Fagundes',
        'Frei Martinho',
        'Gado Bravo',
        'Guarabira',
        'Gurinhém',
        'Gurjão',
        'Ibiara',
        'Igaracy',
        'Imaculada',
        'Ingá',
        'Itabaiana',
        'Itaporanga',
        'Itapororoca',
        'Itatuba',
        'Jacaraú',
        'Jericó',
        'Joca Claudino',
        'João Pessoa',
        'Juarez Távora',
        'Juazeirinho',
        'Junco do Seridó',
        'Juripiranga',
        'Juru',
        'Lagoa',
        'Lagoa Seca',
        'Lagoa de Dentro',
        'Lastro',
        'Livramento',
        'Logradouro',
        'Lucena',
        'Malta',
        'Mamanguape',
        'Manaíra',
        'Marcação',
        'Mari',
        'Marizópolis',
        'Massaranduba',
        'Mataraca',
        'Matinhas',
        'Mato Grosso',
        'Maturéia',
        'Mogeiro',
        'Montadas',
        'Monte Horebe',
        'Monteiro',
        'Mulungu',
        'Mãe d\'Água',
        'Natuba',
        'Nazarezinho',
        'Nova Floresta',
        'Nova Olinda',
        'Nova Palmeira',
        'Olho d\'Água',
        'Olivedos',
        'Ouro Velho',
        'Parari',
        'Passagem',
        'Patos',
        'Paulista',
        'Pedra Branca',
        'Pedra Lavrada',
        'Pedras de Fogo',
        'Pedro Régis',
        'Piancó',
        'Picuí',
        'Pilar',
        'Pilões',
        'Pilõezinhos',
        'Pirpirituba',
        'Pitimbu',
        'Pocinhos',
        'Pombal',
        'Poço Dantas',
        'Poço de José de Moura',
        'Prata',
        'Princesa Isabel',
        'Puxinanã',
        'Queimadas',
        'Quixaba',
        'Remígio',
        'Riacho de Santo Antônio',
        'Riacho dos Cavalos',
        'Riachão',
        'Riachão do Bacamarte',
        'Riachão do Poço',
        'Rio Tinto',
        'Salgadinho',
        'Salgado de São Félix',
        'Santa Cecília',
        'Santa Cruz',
        'Santa Helena',
        'Santa Inês',
        'Santa Luzia',
        'Santa Rita',
        'Santa Teresinha',
        'Santana de Mangueira',
        'Santana dos Garrotes',
        'Santo André',
        'Sapé',
        'Serra Branca',
        'Serra Grande',
        'Serra Redonda',
        'Serra da Raiz',
        'Serraria',
        'Sertãozinho',
        'Sobrado',
        'Soledade',
        'Solânea',
        'Sossêgo',
        'Sousa',
        'Sumé',
        'São Bentinho',
        'São Bento',
        'São Domingos',
        'São Domingos do Cariri',
        'São Francisco',
        'São José da Lagoa Tapada',
        'São José de Caiana',
        'São José de Espinharas',
        'São José de Piranhas',
        'São José de Princesa',
        'São José do Bonfim',
        'São José do Brejo do Cruz',
        'São José do Sabugi',
        'São José dos Cordeiros',
        'São José dos Ramos',
        'São João do Cariri',
        'São João do Rio do Peixe',
        'São João do Tigre',
        'São Mamede',
        'São Miguel de Taipu',
        'São Sebastião de Lagoa de Roça',
        'São Sebastião do Umbuzeiro',
        'São Vicente do Seridó',
        'Tacima',
        'Taperoá',
        'Tavares',
        'Teixeira',
        'Tenório',
        'Triunfo',
        'Uiraúna',
        'Umbuzeiro',
        'Vieirópolis',
        'Vista Serrana',
        'Várzea',
        'Zabelê',
        'Água Branca'
    ],
    'PE': [
        'Abreu e Lima',
        'Afogados da Ingazeira',
        'Afrânio',
        'Agrestina',
        'Alagoinha',
        'Aliança',
        'Altinho',
        'Amaraji',
        'Angelim',
        'Araripina',
        'Araçoiaba',
        'Arcoverde',
        'Barra de Guabiraba',
        'Barreiros',
        'Belo Jardim',
        'Belém de Maria',
        'Belém do São Francisco',
        'Betânia',
        'Bezerros',
        'Bodocó',
        'Bom Conselho',
        'Bom Jardim',
        'Bonito',
        'Brejinho',
        'Brejo da Madre de Deus',
        'Brejão',
        'Buenos Aires',
        'Buíque',
        'Cabo de Santo Agostinho',
        'Cabrobó',
        'Cachoeirinha',
        'Caetés',
        'Calumbi',
        'Calçado',
        'Camaragibe',
        'Camocim de São Félix',
        'Camutanga',
        'Canhotinho',
        'Capoeiras',
        'Carnaubeira da Penha',
        'Carnaíba',
        'Carpina',
        'Caruaru',
        'Casinhas',
        'Catende',
        'Cedro',
        'Chã Grande',
        'Chã de Alegria',
        'Condado',
        'Correntes',
        'Cortês',
        'Cumaru',
        'Cupira',
        'Custódia',
        'Dormentes',
        'Escada',
        'Exu',
        'Feira Nova',
        'Fernando de Noronha',
        'Ferreiros',
        'Flores',
        'Floresta',
        'Frei Miguelinho',
        'Gameleira',
        'Garanhuns',
        'Glória do Goitá',
        'Goiana',
        'Granito',
        'Gravatá',
        'Iati',
        'Ibimirim',
        'Ibirajuba',
        'Igarassu',
        'Iguaracy',
        'Ilha de Itamaracá',
        'Inajá',
        'Ingazeira',
        'Ipojuca',
        'Ipubi',
        'Itacuruba',
        'Itambé',
        'Itapetim',
        'Itapissuma',
        'Itaquitinga',
        'Itaíba',
        'Jaboatão dos Guararapes',
        'Jaqueira',
        'Jataúba',
        'Jatobá',
        'Joaquim Nabuco',
        'João Alfredo',
        'Jucati',
        'Jupi',
        'Jurema',
        'Lagoa Grande',
        'Lagoa de Itaenga',
        'Lagoa do Carro',
        'Lagoa do Ouro',
        'Lagoa dos Gatos',
        'Lajedo',
        'Limoeiro',
        'Macaparana',
        'Machados',
        'Manari',
        'Maraial',
        'Mirandiba',
        'Moreilândia',
        'Moreno',
        'Nazaré da Mata',
        'Olinda',
        'Orobó',
        'Orocó',
        'Ouricuri',
        'Palmares',
        'Palmeirina',
        'Panelas',
        'Paranatama',
        'Parnamirim',
        'Passira',
        'Paudalho',
        'Paulista',
        'Pedra',
        'Pesqueira',
        'Petrolina',
        'Petrolândia',
        'Pombos',
        'Poção',
        'Primavera',
        'Quipapá',
        'Quixaba',
        'Recife',
        'Riacho das Almas',
        'Ribeirão',
        'Rio Formoso',
        'Sairé',
        'Salgadinho',
        'Salgueiro',
        'Saloá',
        'Sanharó',
        'Santa Cruz',
        'Santa Cruz da Baixa Verde',
        'Santa Cruz do Capibaribe',
        'Santa Filomena',
        'Santa Maria da Boa Vista',
        'Santa Maria do Cambucá',
        'Santa Terezinha',
        'Serra Talhada',
        'Serrita',
        'Sertânia',
        'Sirinhaém',
        'Solidão',
        'Surubim',
        'São Benedito do Sul',
        'São Bento do Una',
        'São Caitano',
        'São Joaquim do Monte',
        'São José da Coroa Grande',
        'São José do Belmonte',
        'São José do Egito',
        'São João',
        'São Lourenço da Mata',
        'São Vicente Férrer',
        'Tabira',
        'Tacaimbó',
        'Tacaratu',
        'Tamandaré',
        'Taquaritinga do Norte',
        'Terezinha',
        'Terra Nova',
        'Timbaúba',
        'Toritama',
        'Tracunhaém',
        'Trindade',
        'Triunfo',
        'Tupanatinga',
        'Tuparetama',
        'Venturosa',
        'Verdejante',
        'Vertente do Lério',
        'Vertentes',
        'Vicência',
        'Vitória de Santo Antão',
        'Xexéu',
        'Água Preta',
        'Águas Belas'
    ],
    'PI': [
        'Acauã',
        'Agricolândia',
        'Alagoinha do Piauí',
        'Alegrete do Piauí',
        'Alto Longá',
        'Altos',
        'Alvorada do Gurguéia',
        'Amarante',
        'Angical do Piauí',
        'Antônio Almeida',
        'Anísio de Abreu',
        'Aroazes',
        'Aroeiras do Itaim',
        'Arraial',
        'Assunção do Piauí',
        'Avelino Lopes',
        'Baixa Grande do Ribeiro',
        'Barra D\'Alcântara',
        'Barras',
        'Barreiras do Piauí',
        'Barro Duro',
        'Batalha',
        'Bela Vista do Piauí',
        'Belém do Piauí',
        'Beneditinos',
        'Bertolínia',
        'Betânia do Piauí',
        'Boa Hora',
        'Bocaina',
        'Bom Jesus',
        'Bom Princípio do Piauí',
        'Bonfim do Piauí',
        'Boqueirão do Piauí',
        'Brasileira',
        'Brejo do Piauí',
        'Buriti dos Lopes',
        'Buriti dos Montes',
        'Cabeceiras do Piauí',
        'Cajazeiras do Piauí',
        'Cajueiro da Praia',
        'Caldeirão Grande do Piauí',
        'Campinas do Piauí',
        'Campo Alegre do Fidalgo',
        'Campo Grande do Piauí',
        'Campo Largo do Piauí',
        'Campo Maior',
        'Canavieira',
        'Canto do Buriti',
        'Capitão Gervásio Oliveira',
        'Capitão de Campos',
        'Caracol',
        'Caraúbas do Piauí',
        'Caridade do Piauí',
        'Castelo do Piauí',
        'Caxingó',
        'Cocal',
        'Cocal de Telha',
        'Cocal dos Alves',
        'Coivaras',
        'Colônia do Gurguéia',
        'Colônia do Piauí',
        'Conceição do Canindé',
        'Coronel José Dias',
        'Corrente',
        'Cristalândia do Piauí',
        'Cristino Castro',
        'Curimatá',
        'Currais',
        'Curral Novo do Piauí',
        'Curralinhos',
        'Demerval Lobão',
        'Dirceu Arcoverde',
        'Dom Expedito Lopes',
        'Dom Inocêncio',
        'Domingos Mourão',
        'Elesbão Veloso',
        'Eliseu Martins',
        'Esperantina',
        'Fartura do Piauí',
        'Flores do Piauí',
        'Floresta do Piauí',
        'Floriano',
        'Francinópolis',
        'Francisco Ayres',
        'Francisco Macedo',
        'Francisco Santos',
        'Fronteiras',
        'Geminiano',
        'Gilbués',
        'Guadalupe',
        'Guaribas',
        'Hugo Napoleão',
        'Ilha Grande',
        'Inhuma',
        'Ipiranga do Piauí',
        'Isaías Coelho',
        'Itainópolis',
        'Itaueira',
        'Jacobina do Piauí',
        'Jaicós',
        'Jardim do Mulato',
        'Jatobá do Piauí',
        'Jerumenha',
        'Joaquim Pires',
        'Joca Marques',
        'José de Freitas',
        'João Costa',
        'Juazeiro do Piauí',
        'Jurema',
        'Júlio Borges',
        'Lagoa Alegre',
        'Lagoa de São Francisco',
        'Lagoa do Barro do Piauí',
        'Lagoa do Piauí',
        'Lagoa do Sítio',
        'Lagoinha do Piauí',
        'Landri Sales',
        'Luzilândia',
        'Luís Correia',
        'Madeiro',
        'Manoel Emídio',
        'Marcolândia',
        'Marcos Parente',
        'Massapê do Piauí',
        'Matias Olímpio',
        'Miguel Alves',
        'Miguel Leão',
        'Milton Brandão',
        'Monsenhor Gil',
        'Monsenhor Hipólito',
        'Monte Alegre do Piauí',
        'Morro Cabeça no Tempo',
        'Morro do Chapéu do Piauí',
        'Murici dos Portelas',
        'Nazaré do Piauí',
        'Nazária',
        'Nossa Senhora de Nazaré',
        'Nossa Senhora dos Remédios',
        'Nova Santa Rita',
        'Novo Oriente do Piauí',
        'Novo Santo Antônio',
        'Oeiras',
        'Olho D\'Água do Piauí',
        'Padre Marcos',
        'Paes Landim',
        'Pajeú do Piauí',
        'Palmeira do Piauí',
        'Palmeirais',
        'Paquetá',
        'Parnaguá',
        'Parnaíba',
        'Passagem Franca do Piauí',
        'Patos do Piauí',
        'Pau D\'Arco do Piauí',
        'Paulistana',
        'Pavussu',
        'Pedro II',
        'Pedro Laurentino',
        'Picos',
        'Pimenteiras',
        'Pio IX',
        'Piracuruca',
        'Piripiri',
        'Porto',
        'Porto Alegre do Piauí',
        'Prata do Piauí',
        'Queimada Nova',
        'Redenção do Gurguéia',
        'Regeneração',
        'Riacho Frio',
        'Ribeira do Piauí',
        'Ribeiro Gonçalves',
        'Rio Grande do Piauí',
        'Santa Cruz do Piauí',
        'Santa Cruz dos Milagres',
        'Santa Filomena',
        'Santa Luz',
        'Santa Rosa do Piauí',
        'Santana do Piauí',
        'Santo Antônio de Lisboa',
        'Santo Antônio dos Milagres',
        'Santo Inácio do Piauí',
        'Sebastião Barros',
        'Sebastião Leal',
        'Sigefredo Pacheco',
        'Simplício Mendes',
        'Simões',
        'Socorro do Piauí',
        'Sussuapara',
        'São Braz do Piauí',
        'São Francisco de Assis do Piauí',
        'São Francisco do Piauí',
        'São Félix do Piauí',
        'São Gonçalo do Gurguéia',
        'São Gonçalo do Piauí',
        'São José do Divino',
        'São José do Peixe',
        'São José do Piauí',
        'São João da Canabrava',
        'São João da Fronteira',
        'São João da Serra',
        'São João da Varjota',
        'São João do Arraial',
        'São João do Piauí',
        'São Julião',
        'São Lourenço do Piauí',
        'São Luis do Piauí',
        'São Miguel da Baixa Grande',
        'São Miguel do Fidalgo',
        'São Miguel do Tapuio',
        'São Pedro do Piauí',
        'São Raimundo Nonato',
        'Tamboril do Piauí',
        'Tanque do Piauí',
        'Teresina',
        'União',
        'Uruçuí',
        'Valença do Piauí',
        'Vera Mendes',
        'Vila Nova do Piauí',
        'Várzea Branca',
        'Várzea Grande',
        'Wall Ferraz',
        'Água Branca'
    ],
    'PR': [
        'Abatiá',
        'Adrianópolis',
        'Agudos do Sul',
        'Almirante Tamandaré',
        'Altamira do Paraná',
        'Alto Paraná',
        'Alto Paraíso',
        'Alto Piquiri',
        'Altônia',
        'Alvorada do Sul',
        'Amaporã',
        'Ampére',
        'Anahy',
        'Andirá',
        'Antonina',
        'Antônio Olinto',
        'Apucarana',
        'Arapongas',
        'Arapoti',
        'Arapuã',
        'Araruna',
        'Araucária',
        'Ariranha do Ivaí',
        'Assaí',
        'Assis Chateaubriand',
        'Astorga',
        'Atalaia',
        'Balsa Nova',
        'Bandeirantes',
        'Barbosa Ferraz',
        'Barra do Jacaré',
        'Barracão',
        'Bela Vista da Caroba',
        'Bela Vista do Paraíso',
        'Bituruna',
        'Boa Esperança',
        'Boa Esperança do Iguaçu',
        'Boa Ventura de São Roque',
        'Boa Vista da Aparecida',
        'Bocaiúva do Sul',
        'Bom Jesus do Sul',
        'Bom Sucesso',
        'Bom Sucesso do Sul',
        'Borrazópolis',
        'Braganey',
        'Brasilândia do Sul',
        'Cafeara',
        'Cafelândia',
        'Cafezal do Sul',
        'Califórnia',
        'Cambará',
        'Cambira',
        'Cambé',
        'Campina Grande do Sul',
        'Campina da Lagoa',
        'Campina do Simão',
        'Campo Bonito',
        'Campo Largo',
        'Campo Magro',
        'Campo Mourão',
        'Campo do Tenente',
        'Candói',
        'Cantagalo',
        'Capanema',
        'Capitão Leônidas Marques',
        'Carambeí',
        'Carlópolis',
        'Cascavel',
        'Castro',
        'Catanduvas',
        'Centenário do Sul',
        'Cerro Azul',
        'Chopinzinho',
        'Cianorte',
        'Cidade Gaúcha',
        'Clevelândia',
        'Colombo',
        'Colorado',
        'Congonhinhas',
        'Conselheiro Mairinck',
        'Contenda',
        'Corbélia',
        'Cornélio Procópio',
        'Coronel Domingos Soares',
        'Coronel Vivida',
        'Corumbataí do Sul',
        'Cruz Machado',
        'Cruzeiro do Iguaçu',
        'Cruzeiro do Oeste',
        'Cruzeiro do Sul',
        'Cruzmaltina',
        'Curitiba',
        'Curiúva',
        'Cândido de Abreu',
        'Céu Azul',
        'Diamante D\'Oeste',
        'Diamante do Norte',
        'Diamante do Sul',
        'Dois Vizinhos',
        'Douradina',
        'Doutor Camargo',
        'Doutor Ulysses',
        'Engenheiro Beltrão',
        'Entre Rios do Oeste',
        'Enéas Marques',
        'Esperança Nova',
        'Espigão Alto do Iguaçu',
        'Farol',
        'Faxinal',
        'Fazenda Rio Grande',
        'Fernandes Pinheiro',
        'Figueira',
        'Flor da Serra do Sul',
        'Floraí',
        'Floresta',
        'Florestópolis',
        'Flórida',
        'Formosa do Oeste',
        'Foz do Iguaçu',
        'Foz do Jordão',
        'Francisco Alves',
        'Francisco Beltrão',
        'Fênix',
        'General Carneiro',
        'Godoy Moreira',
        'Goioerê',
        'Goioxim',
        'Grandes Rios',
        'Guairaçá',
        'Guamiranga',
        'Guapirama',
        'Guaporema',
        'Guaraci',
        'Guaraniaçu',
        'Guarapuava',
        'Guaraqueçaba',
        'Guaratuba',
        'Guaíra',
        'Honório Serpa',
        'Ibaiti',
        'Ibema',
        'Ibiporã',
        'Icaraíma',
        'Iguaraçu',
        'Iguatu',
        'Imbaú',
        'Imbituva',
        'Inajá',
        'Indianópolis',
        'Inácio Martins',
        'Ipiranga',
        'Iporã',
        'Iracema do Oeste',
        'Irati',
        'Iretama',
        'Itaguajé',
        'Itaipulândia',
        'Itambaracá',
        'Itambé',
        'Itapejara d\'Oeste',
        'Itaperuçu',
        'Itaúna do Sul',
        'Ivaiporã',
        'Ivatuba',
        'Ivaté',
        'Ivaí',
        'Jaboti',
        'Jacarezinho',
        'Jaguapitã',
        'Jaguariaíva',
        'Jandaia do Sul',
        'Janiópolis',
        'Japira',
        'Japurá',
        'Jardim Alegre',
        'Jardim Olinda',
        'Jataizinho',
        'Jesuítas',
        'Joaquim Távora',
        'Jundiaí do Sul',
        'Juranda',
        'Jussara',
        'Kaloré',
        'Lapa',
        'Laranjal',
        'Laranjeiras do Sul',
        'Leópolis',
        'Lidianópolis',
        'Lindoeste',
        'Loanda',
        'Lobato',
        'Londrina',
        'Luiziana',
        'Lunardelli',
        'Lupionópolis',
        'Mallet',
        'Mamborê',
        'Mandaguari',
        'Mandaguaçu',
        'Mandirituba',
        'Manfrinópolis',
        'Mangueirinha',
        'Manoel Ribas',
        'Marechal Cândido Rondon',
        'Maria Helena',
        'Marialva',
        'Marilena',
        'Mariluz',
        'Marilândia do Sul',
        'Maringá',
        'Maripá',
        'Mariópolis',
        'Marmeleiro',
        'Marquinho',
        'Marumbi',
        'Matelândia',
        'Matinhos',
        'Mato Rico',
        'Mauá da Serra',
        'Medianeira',
        'Mercedes',
        'Mirador',
        'Miraselva',
        'Missal',
        'Moreira Sales',
        'Morretes',
        'Munhoz de Melo',
        'Nossa Senhora das Graças',
        'Nova Aliança do Ivaí',
        'Nova América da Colina',
        'Nova Aurora',
        'Nova Cantu',
        'Nova Esperança',
        'Nova Esperança do Sudoeste',
        'Nova Fátima',
        'Nova Laranjeiras',
        'Nova Londrina',
        'Nova Olímpia',
        'Nova Prata do Iguaçu',
        'Nova Santa Bárbara',
        'Nova Santa Rosa',
        'Nova Tebas',
        'Novo Itacolomi',
        'Ortigueira',
        'Ourizona',
        'Ouro Verde do Oeste',
        'Paiçandu',
        'Palmas',
        'Palmeira',
        'Palmital',
        'Palotina',
        'Paranacity',
        'Paranaguá',
        'Paranapoema',
        'Paranavaí',
        'Paraíso do Norte',
        'Pato Bragado',
        'Pato Branco',
        'Paula Freitas',
        'Paulo Frontin',
        'Peabiru',
        'Perobal',
        'Pinhais',
        'Pinhal de São Bento',
        'Pinhalão',
        'Pinhão',
        'Piraquara',
        'Piraí do Sul',
        'Pitanga',
        'Pitangueiras',
        'Piên',
        'Planaltina do Paraná',
        'Planalto',
        'Ponta Grossa',
        'Pontal do Paraná',
        'Porecatu',
        'Porto Amazonas',
        'Porto Barreiro',
        'Porto Rico',
        'Porto Vitória',
        'Prado Ferreira',
        'Pranchita',
        'Presidente Castelo Branco',
        'Primeiro de Maio',
        'Prudentópolis',
        'Pérola',
        'Pérola d\'Oeste',
        'Quarto Centenário',
        'Quatiguá',
        'Quatro Barras',
        'Quatro Pontes',
        'Quedas do Iguaçu',
        'Querência do Norte',
        'Quinta do Sol',
        'Quitandinha',
        'Ramilândia',
        'Rancho Alegre',
        'Rancho Alegre D\'Oeste',
        'Realeza',
        'Rebouças',
        'Renascença',
        'Reserva',
        'Reserva do Iguaçu',
        'Ribeirão Claro',
        'Ribeirão do Pinhal',
        'Rio Azul',
        'Rio Bom',
        'Rio Bonito do Iguaçu',
        'Rio Branco do Ivaí',
        'Rio Branco do Sul',
        'Rio Negro',
        'Rolândia',
        'Roncador',
        'Rondon',
        'Rosário do Ivaí',
        'Sabáudia',
        'Salgado Filho',
        'Salto do Itararé',
        'Salto do Lontra',
        'Santa Amélia',
        'Santa Cecília do Pavão',
        'Santa Cruz de Monte Castelo',
        'Santa Fé',
        'Santa Helena',
        'Santa Inês',
        'Santa Isabel do Ivaí',
        'Santa Izabel do Oeste',
        'Santa Lúcia',
        'Santa Maria do Oeste',
        'Santa Mariana',
        'Santa Mônica',
        'Santa Tereza do Oeste',
        'Santa Terezinha de Itaipu',
        'Santana do Itararé',
        'Santo Antônio da Platina',
        'Santo Antônio do Caiuá',
        'Santo Antônio do Paraíso',
        'Santo Antônio do Sudoeste',
        'Santo Inácio',
        'Sapopema',
        'Sarandi',
        'Saudade do Iguaçu',
        'Sengés',
        'Serranópolis do Iguaçu',
        'Sertaneja',
        'Sertanópolis',
        'Siqueira Campos',
        'Sulina',
        'São Carlos do Ivaí',
        'São Jerônimo da Serra',
        'São Jorge d\'Oeste',
        'São Jorge do Ivaí',
        'São Jorge do Patrocínio',
        'São José da Boa Vista',
        'São José das Palmeiras',
        'São José dos Pinhais',
        'São João',
        'São João do Caiuá',
        'São João do Ivaí',
        'São João do Triunfo',
        'São Manoel do Paraná',
        'São Mateus do Sul',
        'São Miguel do Iguaçu',
        'São Pedro do Iguaçu',
        'São Pedro do Ivaí',
        'São Pedro do Paraná',
        'São Sebastião da Amoreira',
        'São Tomé',
        'Tamarana',
        'Tamboara',
        'Tapejara',
        'Tapira',
        'Teixeira Soares',
        'Telêmaco Borba',
        'Terra Boa',
        'Terra Rica',
        'Terra Roxa',
        'Tibagi',
        'Tijucas do Sul',
        'Toledo',
        'Tomazina',
        'Três Barras do Paraná',
        'Tunas do Paraná',
        'Tuneiras do Oeste',
        'Tupãssi',
        'Turvo',
        'Ubiratã',
        'Umuarama',
        'Uniflor',
        'União da Vitória',
        'Uraí',
        'Ventania',
        'Vera Cruz do Oeste',
        'Verê',
        'Virmond',
        'Vitorino',
        'Wenceslau Braz',
        'Xambrê',
        'Ângulo'
    ],
    'RJ': [
        'Angra dos Reis',
        'Aperibé',
        'Araruama',
        'Areal',
        'Armação dos Búzios',
        'Arraial do Cabo',
        'Barra Mansa',
        'Barra do Piraí',
        'Belford Roxo',
        'Bom Jardim',
        'Bom Jesus do Itabapoana',
        'Cabo Frio',
        'Cachoeiras de Macacu',
        'Cambuci',
        'Campos dos Goytacazes',
        'Cantagalo',
        'Carapebus',
        'Cardoso Moreira',
        'Carmo',
        'Casimiro de Abreu',
        'Comendador Levy Gasparian',
        'Conceição de Macabu',
        'Cordeiro',
        'Duas Barras',
        'Duque de Caxias',
        'Engenheiro Paulo de Frontin',
        'Guapimirim',
        'Iguaba Grande',
        'Itaboraí',
        'Itaguaí',
        'Italva',
        'Itaocara',
        'Itaperuna',
        'Itatiaia',
        'Japeri',
        'Laje do Muriaé',
        'Macaé',
        'Macuco',
        'Magé',
        'Mangaratiba',
        'Maricá',
        'Mendes',
        'Mesquita',
        'Miguel Pereira',
        'Miracema',
        'Natividade',
        'Nilópolis',
        'Niterói',
        'Nova Friburgo',
        'Nova Iguaçu',
        'Paracambi',
        'Paraty',
        'Paraíba do Sul',
        'Paty do Alferes',
        'Petrópolis',
        'Pinheiral',
        'Piraí',
        'Porciúncula',
        'Porto Real',
        'Quatis',
        'Queimados',
        'Quissamã',
        'Resende',
        'Rio Bonito',
        'Rio Claro',
        'Rio das Flores',
        'Rio das Ostras',
        'Rio de Janeiro',
        'Santa Maria Madalena',
        'Santo Antônio de Pádua',
        'Sapucaia',
        'Saquarema',
        'Seropédica',
        'Silva Jardim',
        'Sumidouro',
        'São Fidélis',
        'São Francisco de Itabapoana',
        'São Gonçalo',
        'São José de Ubá',
        'São José do Vale do Rio Preto',
        'São João da Barra',
        'São João de Meriti',
        'São Pedro da Aldeia',
        'São Sebastião do Alto',
        'Tanguá',
        'Teresópolis',
        'Trajano de Moraes',
        'Três Rios',
        'Valença',
        'Varre-Sai',
        'Vassouras',
        'Volta Redonda'
    ],
    'RN': [
        'Acari',
        'Afonso Bezerra',
        'Alexandria',
        'Almino Afonso',
        'Alto do Rodrigues',
        'Angicos',
        'Antônio Martins',
        'Apodi',
        'Areia Branca',
        'Arês',
        'Açu',
        'Baraúna',
        'Barcelona',
        'Baía Formosa',
        'Bento Fernandes',
        'Bodó',
        'Bom Jesus',
        'Brejinho',
        'Caicó',
        'Caiçara do Norte',
        'Caiçara do Rio do Vento',
        'Campo Grande',
        'Campo Redondo',
        'Canguaretama',
        'Caraúbas',
        'Carnaubais',
        'Carnaúba dos Dantas',
        'Ceará-Mirim',
        'Cerro Corá',
        'Coronel Ezequiel',
        'Coronel João Pessoa',
        'Cruzeta',
        'Currais Novos',
        'Doutor Severiano',
        'Encanto',
        'Equador',
        'Espírito Santo',
        'Extremoz',
        'Felipe Guerra',
        'Fernando Pedroza',
        'Florânia',
        'Francisco Dantas',
        'Frutuoso Gomes',
        'Galinhos',
        'Goianinha',
        'Governador Dix-Sept Rosado',
        'Grossos',
        'Guamaré',
        'Ielmo Marinho',
        'Ipanguaçu',
        'Ipueira',
        'Itajá',
        'Itaú',
        'Jandaíra',
        'Janduís',
        'Januário Cicco',
        'Japi',
        'Jardim de Angicos',
        'Jardim de Piranhas',
        'Jardim do Seridó',
        'Jaçanã',
        'José da Penha',
        'João Câmara',
        'João Dias',
        'Jucurutu',
        'Jundiá',
        'Lagoa Nova',
        'Lagoa Salgada',
        'Lagoa d\'Anta',
        'Lagoa de Pedras',
        'Lagoa de Velhos',
        'Lajes',
        'Lajes Pintadas',
        'Lucrécia',
        'Luís Gomes',
        'Macau',
        'Macaíba',
        'Major Sales',
        'Marcelino Vieira',
        'Martins',
        'Maxaranguape',
        'Messias Targino',
        'Montanhas',
        'Monte Alegre',
        'Monte das Gameleiras',
        'Mossoró',
        'Natal',
        'Nova Cruz',
        'Nísia Floresta',
        'Olho d\'Água do Borges',
        'Ouro Branco',
        'Paraná',
        'Parazinho',
        'Paraú',
        'Parelhas',
        'Parnamirim',
        'Passa e Fica',
        'Passagem',
        'Patu',
        'Pau dos Ferros',
        'Pedra Grande',
        'Pedra Preta',
        'Pedro Avelino',
        'Pedro Velho',
        'Pendências',
        'Pilões',
        'Portalegre',
        'Porto do Mangue',
        'Poço Branco',
        'Pureza',
        'Rafael Fernandes',
        'Rafael Godeiro',
        'Riacho da Cruz',
        'Riacho de Santana',
        'Riachuelo',
        'Rio do Fogo',
        'Rodolfo Fernandes',
        'Ruy Barbosa',
        'Santa Cruz',
        'Santa Maria',
        'Santana do Matos',
        'Santana do Seridó',
        'Santo Antônio',
        'Senador Elói de Souza',
        'Senador Georgino Avelino',
        'Serra Caiada',
        'Serra Negra do Norte',
        'Serra de São Bento',
        'Serra do Mel',
        'Serrinha',
        'Serrinha dos Pintos',
        'Severiano Melo',
        'São Bento do Norte',
        'São Bento do Trairí',
        'São Fernando',
        'São Francisco do Oeste',
        'São Gonçalo do Amarante',
        'São José de Mipibu',
        'São José do Campestre',
        'São José do Seridó',
        'São João do Sabugi',
        'São Miguel',
        'São Miguel do Gostoso',
        'São Paulo do Potengi',
        'São Pedro',
        'São Rafael',
        'São Tomé',
        'São Vicente',
        'Sítio Novo',
        'Taboleiro Grande',
        'Taipu',
        'Tangará',
        'Tenente Ananias',
        'Tenente Laurentino Cruz',
        'Tibau',
        'Tibau do Sul',
        'Timbaúba dos Batistas',
        'Touros',
        'Triunfo Potiguar',
        'Umarizal',
        'Upanema',
        'Venha-Ver',
        'Vera Cruz',
        'Vila Flor',
        'Viçosa',
        'Várzea',
        'Água Nova'
    ],
    'RO': [
        'Alta Floresta D\'Oeste',
        'Alto Alegre dos Parecis',
        'Alto Paraíso',
        'Alvorada D\'Oeste',
        'Ariquemes',
        'Buritis',
        'Cabixi',
        'Cacaulândia',
        'Cacoal',
        'Campo Novo de Rondônia',
        'Candeias do Jamari',
        'Castanheiras',
        'Cerejeiras',
        'Chupinguaia',
        'Colorado do Oeste',
        'Corumbiara',
        'Costa Marques',
        'Cujubim',
        'Espigão D\'Oeste',
        'Governador Jorge Teixeira',
        'Guajará-Mirim',
        'Itapuã do Oeste',
        'Jaru',
        'Ji-Paraná',
        'Machadinho D\'Oeste',
        'Ministro Andreazza',
        'Mirante da Serra',
        'Monte Negro',
        'Nova Brasilândia D\'Oeste',
        'Nova Mamoré',
        'Nova União',
        'Novo Horizonte do Oeste',
        'Ouro Preto do Oeste',
        'Parecis',
        'Pimenta Bueno',
        'Pimenteiras do Oeste',
        'Porto Velho',
        'Presidente Médici',
        'Primavera de Rondônia',
        'Rio Crespo',
        'Rolim de Moura',
        'Santa Luzia D\'Oeste',
        'Seringueiras',
        'São Felipe D\'Oeste',
        'São Francisco do Guaporé',
        'São Miguel do Guaporé',
        'Teixeirópolis',
        'Theobroma',
        'Urupá',
        'Vale do Anari',
        'Vale do Paraíso',
        'Vilhena'
    ],
    'RR': [
        'Alto Alegre',
        'Amajari',
        'Boa Vista',
        'Bonfim',
        'Cantá',
        'Caracaraí',
        'Caroebe',
        'Iracema',
        'Mucajaí',
        'Normandia',
        'Pacaraima',
        'Rorainópolis',
        'São João da Baliza',
        'São Luiz',
        'Uiramutã'
    ],
    'RS': [
        'Aceguá',
        'Agudo',
        'Ajuricaba',
        'Alecrim',
        'Alegrete',
        'Alegria',
        'Almirante Tamandaré do Sul',
        'Alpestre',
        'Alto Alegre',
        'Alto Feliz',
        'Alvorada',
        'Amaral Ferrador',
        'Ametista do Sul',
        'André da Rocha',
        'Anta Gorda',
        'Antônio Prado',
        'Arambaré',
        'Araricá',
        'Aratiba',
        'Arroio Grande',
        'Arroio do Meio',
        'Arroio do Padre',
        'Arroio do Sal',
        'Arroio do Tigre',
        'Arroio dos Ratos',
        'Arvorezinha',
        'Augusto Pestana',
        'Bagé',
        'Balneário Pinhal',
        'Barra Funda',
        'Barra do Guarita',
        'Barra do Quaraí',
        'Barra do Ribeiro',
        'Barra do Rio Azul',
        'Barracão',
        'Barros Cassal',
        'Barão',
        'Barão de Cotegipe',
        'Barão do Triunfo',
        'Benjamin Constant do Sul',
        'Bento Gonçalves',
        'Boa Vista das Missões',
        'Boa Vista do Buricá',
        'Boa Vista do Cadeado',
        'Boa Vista do Incra',
        'Boa Vista do Sul',
        'Bom Jesus',
        'Bom Princípio',
        'Bom Progresso',
        'Bom Retiro do Sul',
        'Boqueirão do Leão',
        'Bossoroca',
        'Bozano',
        'Braga',
        'Brochier',
        'Butiá',
        'Cacequi',
        'Cachoeira do Sul',
        'Cachoeirinha',
        'Cacique Doble',
        'Caibaté',
        'Caiçara',
        'Camaquã',
        'Camargo',
        'Cambará do Sul',
        'Campestre da Serra',
        'Campina das Missões',
        'Campinas do Sul',
        'Campo Bom',
        'Campo Novo',
        'Campos Borges',
        'Candelária',
        'Candiota',
        'Canela',
        'Canguçu',
        'Canoas',
        'Canudos do Vale',
        'Capela de Santana',
        'Capitão',
        'Capivari do Sul',
        'Capão Bonito do Sul',
        'Capão da Canoa',
        'Capão do Cipó',
        'Capão do Leão',
        'Carazinho',
        'Caraá',
        'Carlos Barbosa',
        'Carlos Gomes',
        'Casca',
        'Caseiros',
        'Catuípe',
        'Caxias do Sul',
        'Caçapava do Sul',
        'Centenário',
        'Cerrito',
        'Cerro Branco',
        'Cerro Grande',
        'Cerro Grande do Sul',
        'Cerro Largo',
        'Chapada',
        'Charqueadas',
        'Charrua',
        'Chiapetta',
        'Chuvisca',
        'Chuí',
        'Cidreira',
        'Ciríaco',
        'Colinas',
        'Colorado',
        'Condor',
        'Constantina',
        'Coqueiro Baixo',
        'Coqueiros do Sul',
        'Coronel Barros',
        'Coronel Bicaco',
        'Coronel Pilar',
        'Cotiporã',
        'Coxilha',
        'Crissiumal',
        'Cristal',
        'Cristal do Sul',
        'Cruz Alta',
        'Cruzaltense',
        'Cruzeiro do Sul',
        'Cândido Godói',
        'David Canabarro',
        'Derrubadas',
        'Dezesseis de Novembro',
        'Dilermando de Aguiar',
        'Dois Irmãos',
        'Dois Irmãos das Missões',
        'Dois Lajeados',
        'Dom Feliciano',
        'Dom Pedrito',
        'Dom Pedro de Alcântara',
        'Dona Francisca',
        'Doutor Maurício Cardoso',
        'Doutor Ricardo',
        'Eldorado do Sul',
        'Encantado',
        'Encruzilhada do Sul',
        'Engenho Velho',
        'Entre Rios do Sul',
        'Entre-Ijuís',
        'Erebango',
        'Erechim',
        'Ernestina',
        'Erval Grande',
        'Erval Seco',
        'Esmeralda',
        'Esperança do Sul',
        'Espumoso',
        'Estação',
        'Esteio',
        'Estrela',
        'Estrela Velha',
        'Estância Velha',
        'Eugênio de Castro',
        'Fagundes Varela',
        'Farroupilha',
        'Faxinal do Soturno',
        'Faxinalzinho',
        'Fazenda Vilanova',
        'Feliz',
        'Flores da Cunha',
        'Floriano Peixoto',
        'Fontoura Xavier',
        'Formigueiro',
        'Forquetinha',
        'Fortaleza dos Valos',
        'Frederico Westphalen',
        'Garibaldi',
        'Garruchos',
        'Gaurama',
        'General Câmara',
        'Gentil',
        'Getúlio Vargas',
        'Giruá',
        'Glorinha',
        'Gramado',
        'Gramado Xavier',
        'Gramado dos Loureiros',
        'Gravataí',
        'Guabiju',
        'Guaporé',
        'Guarani das Missões',
        'Guaíba',
        'Harmonia',
        'Herval',
        'Herveiras',
        'Horizontina',
        'Hulha Negra',
        'Humaitá',
        'Ibarama',
        'Ibiaçá',
        'Ibiraiaras',
        'Ibirapuitã',
        'Ibirubá',
        'Igrejinha',
        'Ijuí',
        'Ilópolis',
        'Imbé',
        'Imigrante',
        'Independência',
        'Inhacorá',
        'Ipiranga do Sul',
        'Ipê',
        'Iraí',
        'Itaara',
        'Itacurubi',
        'Itapuca',
        'Itaqui',
        'Itati',
        'Itatiba do Sul',
        'Ivorá',
        'Ivoti',
        'Jaboticaba',
        'Jacuizinho',
        'Jacutinga',
        'Jaguari',
        'Jaguarão',
        'Jaquirana',
        'Jari',
        'Jóia',
        'Júlio de Castilhos',
        'Lagoa Bonita do Sul',
        'Lagoa Vermelha',
        'Lagoa dos Três Cantos',
        'Lagoão',
        'Lajeado',
        'Lajeado do Bugre',
        'Lavras do Sul',
        'Liberato Salzano',
        'Lindolfo Collor',
        'Linha Nova',
        'Machadinho',
        'Mampituba',
        'Manoel Viana',
        'Maquiné',
        'Maratá',
        'Marau',
        'Marcelino Ramos',
        'Mariana Pimentel',
        'Mariano Moro',
        'Marques de Souza',
        'Mata',
        'Mato Castelhano',
        'Mato Leitão',
        'Mato Queimado',
        'Maximiliano de Almeida',
        'Maçambará',
        'Minas do Leão',
        'Miraguaí',
        'Montauri',
        'Monte Alegre dos Campos',
        'Monte Belo do Sul',
        'Montenegro',
        'Mormaço',
        'Morrinhos do Sul',
        'Morro Redondo',
        'Morro Reuter',
        'Mostardas',
        'Muitos Capões',
        'Muliterno',
        'Muçum',
        'Nicolau Vergueiro',
        'Nonoai',
        'Nova Alvorada',
        'Nova Araçá',
        'Nova Bassano',
        'Nova Boa Vista',
        'Nova Bréscia',
        'Nova Candelária',
        'Nova Esperança do Sul',
        'Nova Hartz',
        'Nova Palma',
        'Nova Petrópolis',
        'Nova Prata',
        'Nova Pádua',
        'Nova Ramada',
        'Nova Roma do Sul',
        'Nova Santa Rita',
        'Novo Barreiro',
        'Novo Cabrais',
        'Novo Hamburgo',
        'Novo Machado',
        'Novo Tiradentes',
        'Novo Xingu',
        'Não-Me-Toque',
        'Osório',
        'Paim Filho',
        'Palmares do Sul',
        'Palmeira das Missões',
        'Palmitinho',
        'Panambi',
        'Pantano Grande',
        'Paraí',
        'Paraíso do Sul',
        'Pareci Novo',
        'Parobé',
        'Passa Sete',
        'Passo Fundo',
        'Passo do Sobrado',
        'Paulo Bento',
        'Paverama',
        'Pedras Altas',
        'Pedro Osório',
        'Pejuçara',
        'Pelotas',
        'Picada Café',
        'Pinhal',
        'Pinhal Grande',
        'Pinhal da Serra',
        'Pinheirinho do Vale',
        'Pinheiro Machado',
        'Pinto Bandeira',
        'Pirapó',
        'Piratini',
        'Planalto',
        'Ponte Preta',
        'Pontão',
        'Porto Alegre',
        'Porto Lucena',
        'Porto Mauá',
        'Porto Vera Cruz',
        'Porto Xavier',
        'Portão',
        'Pouso Novo',
        'Poço das Antas',
        'Presidente Lucena',
        'Progresso',
        'Protásio Alves',
        'Putinga',
        'Quaraí',
        'Quatro Irmãos',
        'Quevedos',
        'Quinze de Novembro',
        'Redentora',
        'Relvado',
        'Restinga Sêca',
        'Rio Grande',
        'Rio Pardo',
        'Rio dos Índios',
        'Riozinho',
        'Roca Sales',
        'Rodeio Bonito',
        'Rolador',
        'Rolante',
        'Ronda Alta',
        'Rondinha',
        'Roque Gonzales',
        'Rosário do Sul',
        'Sagrada Família',
        'Saldanha Marinho',
        'Salto do Jacuí',
        'Salvador das Missões',
        'Salvador do Sul',
        'Sananduva',
        'Sant\'Ana do Livramento',
        'Santa Bárbara do Sul',
        'Santa Cecília do Sul',
        'Santa Clara do Sul',
        'Santa Cruz do Sul',
        'Santa Margarida do Sul',
        'Santa Maria',
        'Santa Maria do Herval',
        'Santa Rosa',
        'Santa Tereza',
        'Santa Vitória do Palmar',
        'Santana da Boa Vista',
        'Santiago',
        'Santo Antônio da Patrulha',
        'Santo Antônio das Missões',
        'Santo Antônio do Palma',
        'Santo Antônio do Planalto',
        'Santo Augusto',
        'Santo Cristo',
        'Santo Expedito do Sul',
        'Santo Ângelo',
        'Sapiranga',
        'Sapucaia do Sul',
        'Sarandi',
        'Seberi',
        'Sede Nova',
        'Segredo',
        'Selbach',
        'Senador Salgado Filho',
        'Sentinela do Sul',
        'Serafina Corrêa',
        'Sertão',
        'Sertão Santana',
        'Sete de Setembro',
        'Severiano de Almeida',
        'Silveira Martins',
        'Sinimbu',
        'Sobradinho',
        'Soledade',
        'São Borja',
        'São Domingos do Sul',
        'São Francisco de Assis',
        'São Francisco de Paula',
        'São Gabriel',
        'São Jerônimo',
        'São Jorge',
        'São José das Missões',
        'São José do Herval',
        'São José do Hortêncio',
        'São José do Inhacorá',
        'São José do Norte',
        'São José do Ouro',
        'São José do Sul',
        'São José dos Ausentes',
        'São João da Urtiga',
        'São João do Polêsine',
        'São Leopoldo',
        'São Lourenço do Sul',
        'São Luiz Gonzaga',
        'São Marcos',
        'São Martinho',
        'São Martinho da Serra',
        'São Miguel das Missões',
        'São Nicolau',
        'São Paulo das Missões',
        'São Pedro da Serra',
        'São Pedro das Missões',
        'São Pedro do Butiá',
        'São Pedro do Sul',
        'São Sebastião do Caí',
        'São Sepé',
        'São Valentim',
        'São Valentim do Sul',
        'São Valério do Sul',
        'São Vendelino',
        'São Vicente do Sul',
        'Sério',
        'Tabaí',
        'Tapejara',
        'Tapera',
        'Tapes',
        'Taquara',
        'Taquari',
        'Taquaruçu do Sul',
        'Tavares',
        'Tenente Portela',
        'Terra de Areia',
        'Teutônia',
        'Tio Hugo',
        'Tiradentes do Sul',
        'Toropi',
        'Torres',
        'Tramandaí',
        'Travesseiro',
        'Trindade do Sul',
        'Triunfo',
        'Três Arroios',
        'Três Cachoeiras',
        'Três Coroas',
        'Três Forquilhas',
        'Três Palmeiras',
        'Três Passos',
        'Três de Maio',
        'Tucunduva',
        'Tunas',
        'Tupanci do Sul',
        'Tupanciretã',
        'Tupandi',
        'Tuparendi',
        'Turuçu',
        'Ubiretama',
        'Unistalda',
        'União da Serra',
        'Uruguaiana',
        'Vacaria',
        'Vale Real',
        'Vale Verde',
        'Vale do Sol',
        'Vanini',
        'Venâncio Aires',
        'Vera Cruz',
        'Veranópolis',
        'Vespasiano Corrêa',
        'Viadutos',
        'Viamão',
        'Vicente Dutra',
        'Victor Graeff',
        'Vila Flores',
        'Vila Lângaro',
        'Vila Maria',
        'Vila Nova do Sul',
        'Vista Alegre',
        'Vista Alegre do Prata',
        'Vista Gaúcha',
        'Vitória das Missões',
        'Westfália',
        'Xangri-lá',
        'Água Santa',
        'Áurea'
    ],
    'SC': [
        'Abdon Batista',
        'Abelardo Luz',
        'Agrolândia',
        'Agronômica',
        'Alfredo Wagner',
        'Alto Bela Vista',
        'Anchieta',
        'Angelina',
        'Anita Garibaldi',
        'Anitápolis',
        'Antônio Carlos',
        'Apiúna',
        'Arabutã',
        'Araquari',
        'Araranguá',
        'Armazém',
        'Arroio Trinta',
        'Arvoredo',
        'Ascurra',
        'Atalanta',
        'Aurora',
        'Balneário Arroio do Silva',
        'Balneário Barra do Sul',
        'Balneário Camboriú',
        'Balneário Gaivota',
        'Balneário Piçarras',
        'Balneário Rincão',
        'Bandeirante',
        'Barra Bonita',
        'Barra Velha',
        'Bela Vista do Toldo',
        'Belmonte',
        'Benedito Novo',
        'Biguaçu',
        'Blumenau',
        'Bocaina do Sul',
        'Bom Jardim da Serra',
        'Bom Jesus',
        'Bom Jesus do Oeste',
        'Bom Retiro',
        'Bombinhas',
        'Botuverá',
        'Braço do Norte',
        'Braço do Trombudo',
        'Brunópolis',
        'Brusque',
        'Caibi',
        'Calmon',
        'Camboriú',
        'Campo Alegre',
        'Campo Belo do Sul',
        'Campo Erê',
        'Campos Novos',
        'Canelinha',
        'Canoinhas',
        'Capinzal',
        'Capivari de Baixo',
        'Capão Alto',
        'Catanduvas',
        'Caxambu do Sul',
        'Caçador',
        'Celso Ramos',
        'Cerro Negro',
        'Chapadão do Lageado',
        'Chapecó',
        'Cocal do Sul',
        'Concórdia',
        'Cordilheira Alta',
        'Coronel Freitas',
        'Coronel Martins',
        'Correia Pinto',
        'Corupá',
        'Criciúma',
        'Cunha Porã',
        'Cunhataí',
        'Curitibanos',
        'Descanso',
        'Dionísio Cerqueira',
        'Dona Emma',
        'Doutor Pedrinho',
        'Entre Rios',
        'Ermo',
        'Erval Velho',
        'Faxinal dos Guedes',
        'Flor do Sertão',
        'Florianópolis',
        'Formosa do Sul',
        'Forquilhinha',
        'Fraiburgo',
        'Frei Rogério',
        'Galvão',
        'Garopaba',
        'Garuva',
        'Gaspar',
        'Governador Celso Ramos',
        'Gravatal',
        'Grão-Pará',
        'Guabiruba',
        'Guaraciaba',
        'Guaramirim',
        'Guarujá do Sul',
        'Guatambú',
        'Herval d\'Oeste',
        'Ibiam',
        'Ibicaré',
        'Ibirama',
        'Ilhota',
        'Imaruí',
        'Imbituba',
        'Imbuia',
        'Indaial',
        'Iomerê',
        'Ipira',
        'Iporã do Oeste',
        'Ipuaçu',
        'Ipumirim',
        'Iraceminha',
        'Irani',
        'Irati',
        'Irineópolis',
        'Itaiópolis',
        'Itajaí',
        'Itapema',
        'Itapiranga',
        'Itapoá',
        'Ituporanga',
        'Itá',
        'Içara',
        'Jaborá',
        'Jacinto Machado',
        'Jaguaruna',
        'Jaraguá do Sul',
        'Jardinópolis',
        'Joaçaba',
        'Joinville',
        'José Boiteux',
        'Jupiá',
        'Lacerdópolis',
        'Lages',
        'Laguna',
        'Lajeado Grande',
        'Laurentino',
        'Lauro Müller',
        'Lebon Régis',
        'Leoberto Leal',
        'Lindóia do Sul',
        'Lontras',
        'Luiz Alves',
        'Luzerna',
        'Macieira',
        'Mafra',
        'Major Gercino',
        'Major Vieira',
        'Maracajá',
        'Maravilha',
        'Marema',
        'Massaranduba',
        'Matos Costa',
        'Meleiro',
        'Mirim Doce',
        'Modelo',
        'Mondaí',
        'Monte Carlo',
        'Monte Castelo',
        'Morro Grande',
        'Morro da Fumaça',
        'Navegantes',
        'Nova Erechim',
        'Nova Itaberaba',
        'Nova Trento',
        'Nova Veneza',
        'Novo Horizonte',
        'Orleans',
        'Otacílio Costa',
        'Ouro',
        'Ouro Verde',
        'Paial',
        'Painel',
        'Palhoça',
        'Palma Sola',
        'Palmeira',
        'Palmitos',
        'Papanduva',
        'Paraíso',
        'Passo de Torres',
        'Passos Maia',
        'Paulo Lopes',
        'Pedras Grandes',
        'Penha',
        'Peritiba',
        'Pescaria Brava',
        'Petrolândia',
        'Pinhalzinho',
        'Pinheiro Preto',
        'Piratuba',
        'Planalto Alegre',
        'Pomerode',
        'Ponte Alta',
        'Ponte Alta do Norte',
        'Ponte Serrada',
        'Porto Belo',
        'Porto União',
        'Pouso Redondo',
        'Praia Grande',
        'Presidente Castello Branco',
        'Presidente Getúlio',
        'Presidente Nereu',
        'Princesa',
        'Quilombo',
        'Rancho Queimado',
        'Rio Fortuna',
        'Rio Negrinho',
        'Rio Rufino',
        'Rio das Antas',
        'Rio do Campo',
        'Rio do Oeste',
        'Rio do Sul',
        'Rio dos Cedros',
        'Riqueza',
        'Rodeio',
        'Romelândia',
        'Salete',
        'Saltinho',
        'Salto Veloso',
        'Sangão',
        'Santa Cecília',
        'Santa Helena',
        'Santa Rosa de Lima',
        'Santa Rosa do Sul',
        'Santa Terezinha',
        'Santa Terezinha do Progresso',
        'Santiago do Sul',
        'Santo Amaro da Imperatriz',
        'Saudades',
        'Schroeder',
        'Seara',
        'Serra Alta',
        'Siderópolis',
        'Sombrio',
        'Sul Brasil',
        'São Bento do Sul',
        'São Bernardino',
        'São Bonifácio',
        'São Carlos',
        'São Cristóvão do Sul',
        'São Domingos',
        'São Francisco do Sul',
        'São Joaquim',
        'São José',
        'São José do Cedro',
        'São José do Cerrito',
        'São João Batista',
        'São João do Itaperiú',
        'São João do Oeste',
        'São João do Sul',
        'São Lourenço do Oeste',
        'São Ludgero',
        'São Martinho',
        'São Miguel da Boa Vista',
        'São Miguel do Oeste',
        'São Pedro de Alcântara',
        'Taió',
        'Tangará',
        'Tigrinhos',
        'Tijucas',
        'Timbé do Sul',
        'Timbó',
        'Timbó Grande',
        'Treviso',
        'Treze Tílias',
        'Treze de Maio',
        'Trombudo Central',
        'Três Barras',
        'Tubarão',
        'Tunápolis',
        'Turvo',
        'União do Oeste',
        'Urubici',
        'Urupema',
        'Urussanga',
        'Vargem',
        'Vargem Bonita',
        'Vargeão',
        'Vidal Ramos',
        'Videira',
        'Vitor Meireles',
        'Witmarsum',
        'Xanxerê',
        'Xavantina',
        'Xaxim',
        'Zortéa',
        'Água Doce',
        'Águas Frias',
        'Águas Mornas',
        'Águas de Chapecó'
    ],
    'SE': [
        'Amparo do São Francisco',
        'Aquidabã',
        'Aracaju',
        'Arauá',
        'Areia Branca',
        'Barra dos Coqueiros',
        'Boquim',
        'Brejo Grande',
        'Campo do Brito',
        'Canhoba',
        'Canindé de São Francisco',
        'Capela',
        'Carira',
        'Carmópolis',
        'Cedro de São João',
        'Cristinápolis',
        'Cumbe',
        'Divina Pastora',
        'Estância',
        'Feira Nova',
        'Frei Paulo',
        'Gararu',
        'General Maynard',
        'Gracho Cardoso',
        'Ilha das Flores',
        'Indiaroba',
        'Itabaiana',
        'Itabaianinha',
        'Itabi',
        'Itaporanga d\'Ajuda',
        'Japaratuba',
        'Japoatã',
        'Lagarto',
        'Laranjeiras',
        'Macambira',
        'Malhada dos Bois',
        'Malhador',
        'Maruim',
        'Moita Bonita',
        'Monte Alegre de Sergipe',
        'Muribeca',
        'Neópolis',
        'Nossa Senhora Aparecida',
        'Nossa Senhora da Glória',
        'Nossa Senhora das Dores',
        'Nossa Senhora de Lourdes',
        'Nossa Senhora do Socorro',
        'Pacatuba',
        'Pedra Mole',
        'Pedrinhas',
        'Pinhão',
        'Pirambu',
        'Porto da Folha',
        'Poço Redondo',
        'Poço Verde',
        'Propriá',
        'Riachuelo',
        'Riachão do Dantas',
        'Ribeirópolis',
        'Rosário do Catete',
        'Salgado',
        'Santa Luzia do Itanhy',
        'Santa Rosa de Lima',
        'Santana do São Francisco',
        'Santo Amaro das Brotas',
        'Simão Dias',
        'Siriri',
        'São Cristóvão',
        'São Domingos',
        'São Francisco',
        'São Miguel do Aleixo',
        'Telha',
        'Tobias Barreto',
        'Tomar do Geru',
        'Umbaúba'
    ],
    'SP': [
        'Adamantina',
        'Adolfo',
        'Aguaí',
        'Agudos',
        'Alambari',
        'Alfredo Marcondes',
        'Altair',
        'Altinópolis',
        'Alto Alegre',
        'Alumínio',
        'Alvinlândia',
        'Americana',
        'Amparo',
        'Américo Brasiliense',
        'Américo de Campos',
        'Analândia',
        'Andradina',
        'Angatuba',
        'Anhembi',
        'Anhumas',
        'Aparecida',
        'Aparecida d\'Oeste',
        'Apiaí',
        'Aramina',
        'Arandu',
        'Arapeí',
        'Araraquara',
        'Araras',
        'Araçariguama',
        'Araçatuba',
        'Araçoiaba da Serra',
        'Arco-Íris',
        'Arealva',
        'Areias',
        'Areiópolis',
        'Ariranha',
        'Artur Nogueira',
        'Arujá',
        'Aspásia',
        'Assis',
        'Atibaia',
        'Auriflama',
        'Avanhandava',
        'Avaré',
        'Avaí',
        'Bady Bassitt',
        'Balbinos',
        'Bananal',
        'Barbosa',
        'Bariri',
        'Barra Bonita',
        'Barra do Chapéu',
        'Barra do Turvo',
        'Barretos',
        'Barrinha',
        'Barueri',
        'Barão de Antonina',
        'Bastos',
        'Batatais',
        'Bauru',
        'Bebedouro',
        'Bento de Abreu',
        'Bernardino de Campos',
        'Bertioga',
        'Bilac',
        'Birigui',
        'Biritiba Mirim',
        'Boa Esperança do Sul',
        'Bocaina',
        'Bofete',
        'Boituva',
        'Bom Jesus dos Perdões',
        'Bom Sucesso de Itararé',
        'Boracéia',
        'Borborema',
        'Borebi',
        'Borá',
        'Botucatu',
        'Bragança Paulista',
        'Braúna',
        'Brejo Alegre',
        'Brodowski',
        'Brotas',
        'Buri',
        'Buritama',
        'Buritizal',
        'Bálsamo',
        'Cabreúva',
        'Cabrália Paulista',
        'Cachoeira Paulista',
        'Caconde',
        'Cafelândia',
        'Caiabu',
        'Caieiras',
        'Caiuá',
        'Cajamar',
        'Cajati',
        'Cajobi',
        'Cajuru',
        'Campina do Monte Alegre',
        'Campinas',
        'Campo Limpo Paulista',
        'Campos Novos Paulista',
        'Campos do Jordão',
        'Cananéia',
        'Canas',
        'Canitar',
        'Capela do Alto',
        'Capivari',
        'Capão Bonito',
        'Caraguatatuba',
        'Carapicuíba',
        'Cardoso',
        'Casa Branca',
        'Castilho',
        'Catanduva',
        'Catiguá',
        'Caçapava',
        'Cedral',
        'Cerqueira César',
        'Cerquilho',
        'Cesário Lange',
        'Charqueada',
        'Chavantes',
        'Clementina',
        'Colina',
        'Colômbia',
        'Conchal',
        'Conchas',
        'Cordeirópolis',
        'Coroados',
        'Coronel Macedo',
        'Corumbataí',
        'Cosmorama',
        'Cosmópolis',
        'Cotia',
        'Cravinhos',
        'Cristais Paulista',
        'Cruzeiro',
        'Cruzália',
        'Cubatão',
        'Cunha',
        'Cássia dos Coqueiros',
        'Cândido Mota',
        'Cândido Rodrigues',
        'Descalvado',
        'Diadema',
        'Dirce Reis',
        'Divinolândia',
        'Dobrada',
        'Dois Córregos',
        'Dolcinópolis',
        'Dourado',
        'Dracena',
        'Duartina',
        'Dumont',
        'Echaporã',
        'Eldorado',
        'Elias Fausto',
        'Elisiário',
        'Embaúba',
        'Embu das Artes',
        'Embu-Guaçu',
        'Emilianópolis',
        'Engenheiro Coelho',
        'Espírito Santo do Pinhal',
        'Espírito Santo do Turvo',
        'Estiva Gerbi',
        'Estrela d\'Oeste',
        'Estrela do Norte',
        'Euclides da Cunha Paulista',
        'Fartura',
        'Fernando Prestes',
        'Fernandópolis',
        'Fernão',
        'Ferraz de Vasconcelos',
        'Flora Rica',
        'Floreal',
        'Florínea',
        'Flórida Paulista',
        'Franca',
        'Francisco Morato',
        'Franco da Rocha',
        'Gabriel Monteiro',
        'Garça',
        'Gastão Vidigal',
        'Gavião Peixoto',
        'General Salgado',
        'Getulina',
        'Glicério',
        'Guaimbê',
        'Guaiçara',
        'Guapiara',
        'Guapiaçu',
        'Guaraci',
        'Guarani d\'Oeste',
        'Guarantã',
        'Guararapes',
        'Guararema',
        'Guaratinguetá',
        'Guaraçaí',
        'Guareí',
        'Guariba',
        'Guarujá',
        'Guarulhos',
        'Guará',
        'Guatapará',
        'Guaíra',
        'Guzolândia',
        'Gália',
        'Herculândia',
        'Holambra',
        'Hortolândia',
        'Iacanga',
        'Iacri',
        'Iaras',
        'Ibaté',
        'Ibirarema',
        'Ibirá',
        'Ibitinga',
        'Ibiúna',
        'Icém',
        'Iepê',
        'Igarapava',
        'Igaratá',
        'Igaraçu do Tietê',
        'Iguape',
        'Ilha Comprida',
        'Ilha Solteira',
        'Ilhabela',
        'Indaiatuba',
        'Indiana',
        'Indiaporã',
        'Inúbia Paulista',
        'Ipaussu',
        'Iperó',
        'Ipeúna',
        'Ipiguá',
        'Iporanga',
        'Ipuã',
        'Iracemápolis',
        'Irapuru',
        'Irapuã',
        'Itaberá',
        'Itajobi',
        'Itaju',
        'Itanhaém',
        'Itaoca',
        'Itapecerica da Serra',
        'Itapetininga',
        'Itapeva',
        'Itapevi',
        'Itapira',
        'Itapirapuã Paulista',
        'Itaporanga',
        'Itapura',
        'Itapuí',
        'Itaquaquecetuba',
        'Itararé',
        'Itariri',
        'Itatiba',
        'Itatinga',
        'Itaí',
        'Itirapina',
        'Itirapuã',
        'Itobi',
        'Itu',
        'Itupeva',
        'Ituverava',
        'Itápolis',
        'Jaborandi',
        'Jaboticabal',
        'Jacareí',
        'Jaci',
        'Jacupiranga',
        'Jaguariúna',
        'Jales',
        'Jambeiro',
        'Jandira',
        'Jardinópolis',
        'Jarinu',
        'Jaú',
        'Jeriquara',
        'Joanópolis',
        'José Bonifácio',
        'João Ramalho',
        'Jumirim',
        'Jundiaí',
        'Junqueirópolis',
        'Juquitiba',
        'Juquiá',
        'Júlio Mesquita',
        'Lagoinha',
        'Laranjal Paulista',
        'Lavrinhas',
        'Lavínia',
        'Leme',
        'Lençóis Paulista',
        'Limeira',
        'Lindóia',
        'Lins',
        'Lorena',
        'Lourdes',
        'Louveira',
        'Lucianópolis',
        'Lucélia',
        'Luiziânia',
        'Lupércio',
        'Lutécia',
        'Luís Antônio',
        'Macatuba',
        'Macaubal',
        'Macedônia',
        'Magda',
        'Mairinque',
        'Mairiporã',
        'Manduri',
        'Marabá Paulista',
        'Maracaí',
        'Marapoama',
        'Marinópolis',
        'Mariápolis',
        'Martinópolis',
        'Marília',
        'Matão',
        'Mauá',
        'Mendonça',
        'Meridiano',
        'Mesópolis',
        'Miguelópolis',
        'Mineiros do Tietê',
        'Mira Estrela',
        'Miracatu',
        'Mirandópolis',
        'Mirante do Paranapanema',
        'Mirassol',
        'Mirassolândia',
        'Mococa',
        'Mogi Guaçu',
        'Mogi Mirim',
        'Mogi das Cruzes',
        'Mombuca',
        'Mongaguá',
        'Monte Alegre do Sul',
        'Monte Alto',
        'Monte Aprazível',
        'Monte Azul Paulista',
        'Monte Castelo',
        'Monte Mor',
        'Monteiro Lobato',
        'Monções',
        'Morro Agudo',
        'Morungaba',
        'Motuca',
        'Murutinga do Sul',
        'Nantes',
        'Narandiba',
        'Natividade da Serra',
        'Nazaré Paulista',
        'Neves Paulista',
        'Nhandeara',
        'Nipoã',
        'Nova Aliança',
        'Nova Campina',
        'Nova Canaã Paulista',
        'Nova Castilho',
        'Nova Europa',
        'Nova Granada',
        'Nova Guataporanga',
        'Nova Independência',
        'Nova Luzitânia',
        'Nova Odessa',
        'Novais',
        'Novo Horizonte',
        'Nuporanga',
        'Ocauçu',
        'Olímpia',
        'Onda Verde',
        'Oriente',
        'Orindiúva',
        'Orlândia',
        'Osasco',
        'Oscar Bressane',
        'Osvaldo Cruz',
        'Ourinhos',
        'Ouro Verde',
        'Ouroeste',
        'Pacaembu',
        'Palestina',
        'Palmares Paulista',
        'Palmeira d\'Oeste',
        'Palmital',
        'Panorama',
        'Paraguaçu Paulista',
        'Paraibuna',
        'Paranapanema',
        'Paranapuã',
        'Parapuã',
        'Paraíso',
        'Pardinho',
        'Pariquera-Açu',
        'Parisi',
        'Patrocínio Paulista',
        'Paulicéia',
        'Paulistânia',
        'Paulo de Faria',
        'Paulínia',
        'Pederneiras',
        'Pedra Bela',
        'Pedranópolis',
        'Pedregulho',
        'Pedreira',
        'Pedrinhas Paulista',
        'Pedro de Toledo',
        'Penápolis',
        'Pereira Barreto',
        'Pereiras',
        'Peruíbe',
        'Piacatu',
        'Piedade',
        'Pilar do Sul',
        'Pindamonhangaba',
        'Pindorama',
        'Pinhalzinho',
        'Piquerobi',
        'Piquete',
        'Piracaia',
        'Piracicaba',
        'Piraju',
        'Pirajuí',
        'Pirangi',
        'Pirapora do Bom Jesus',
        'Pirapozinho',
        'Pirassununga',
        'Piratininga',
        'Pitangueiras',
        'Planalto',
        'Platina',
        'Poloni',
        'Pompéia',
        'Pongaí',
        'Pontal',
        'Pontalinda',
        'Pontes Gestal',
        'Populina',
        'Porangaba',
        'Porto Feliz',
        'Porto Ferreira',
        'Potim',
        'Potirendaba',
        'Poá',
        'Pracinha',
        'Pradópolis',
        'Praia Grande',
        'Pratânia',
        'Presidente Alves',
        'Presidente Bernardes',
        'Presidente Epitácio',
        'Presidente Prudente',
        'Presidente Venceslau',
        'Promissão',
        'Quadra',
        'Quatá',
        'Queiroz',
        'Queluz',
        'Quintana',
        'Rafard',
        'Rancharia',
        'Redenção da Serra',
        'Regente Feijó',
        'Reginópolis',
        'Registro',
        'Restinga',
        'Ribeira',
        'Ribeirão Bonito',
        'Ribeirão Branco',
        'Ribeirão Corrente',
        'Ribeirão Grande',
        'Ribeirão Pires',
        'Ribeirão Preto',
        'Ribeirão do Sul',
        'Ribeirão dos Índios',
        'Rifaina',
        'Rincão',
        'Rinópolis',
        'Rio Claro',
        'Rio Grande da Serra',
        'Rio das Pedras',
        'Riolândia',
        'Riversul',
        'Rosana',
        'Roseira',
        'Rubinéia',
        'Rubiácea',
        'Sabino',
        'Sagres',
        'Sales',
        'Sales Oliveira',
        'Salesópolis',
        'Salmourão',
        'Saltinho',
        'Salto',
        'Salto Grande',
        'Salto de Pirapora',
        'Sandovalina',
        'Santa Adélia',
        'Santa Albertina',
        'Santa Branca',
        'Santa Bárbara d\'Oeste',
        'Santa Clara d\'Oeste',
        'Santa Cruz da Conceição',
        'Santa Cruz da Esperança',
        'Santa Cruz das Palmeiras',
        'Santa Cruz do Rio Pardo',
        'Santa Ernestina',
        'Santa Fé do Sul',
        'Santa Gertrudes',
        'Santa Isabel',
        'Santa Lúcia',
        'Santa Maria da Serra',
        'Santa Mercedes',
        'Santa Rita d\'Oeste',
        'Santa Rita do Passa Quatro',
        'Santa Rosa de Viterbo',
        'Santa Salete',
        'Santana da Ponte Pensa',
        'Santana de Parnaíba',
        'Santo Anastácio',
        'Santo André',
        'Santo Antônio da Alegria',
        'Santo Antônio de Posse',
        'Santo Antônio do Aracanguá',
        'Santo Antônio do Jardim',
        'Santo Antônio do Pinhal',
        'Santo Expedito',
        'Santos',
        'Santópolis do Aguapeí',
        'Sarapuí',
        'Sarutaiá',
        'Sebastianópolis do Sul',
        'Serra Azul',
        'Serra Negra',
        'Serrana',
        'Sertãozinho',
        'Sete Barras',
        'Severínia',
        'Silveiras',
        'Socorro',
        'Sorocaba',
        'Sud Mennucci',
        'Sumaré',
        'Suzano',
        'Suzanápolis',
        'São Bento do Sapucaí',
        'São Bernardo do Campo',
        'São Caetano do Sul',
        'São Carlos',
        'São Francisco',
        'São Joaquim da Barra',
        'São José da Bela Vista',
        'São José do Barreiro',
        'São José do Rio Pardo',
        'São José do Rio Preto',
        'São José dos Campos',
        'São João da Boa Vista',
        'São João das Duas Pontes',
        'São João de Iracema',
        'São João do Pau d\'Alho',
        'São Lourenço da Serra',
        'São Luiz do Paraitinga',
        'São Manuel',
        'São Miguel Arcanjo',
        'São Paulo',
        'São Pedro',
        'São Pedro do Turvo',
        'São Roque',
        'São Sebastião',
        'São Sebastião da Grama',
        'São Simão',
        'São Vicente',
        'Tabapuã',
        'Tabatinga',
        'Taboão da Serra',
        'Taciba',
        'Taguaí',
        'Taiaçu',
        'Taiúva',
        'Tambaú',
        'Tanabi',
        'Tapiratiba',
        'Tapiraí',
        'Taquaral',
        'Taquaritinga',
        'Taquarituba',
        'Taquarivaí',
        'Tarabai',
        'Tarumã',
        'Tatuí',
        'Taubaté',
        'Tejupá',
        'Teodoro Sampaio',
        'Terra Roxa',
        'Tietê',
        'Timburi',
        'Torre de Pedra',
        'Torrinha',
        'Trabiju',
        'Tremembé',
        'Três Fronteiras',
        'Tuiuti',
        'Tupi Paulista',
        'Tupã',
        'Turiúba',
        'Turmalina',
        'Ubarana',
        'Ubatuba',
        'Ubirajara',
        'Uchoa',
        'União Paulista',
        'Uru',
        'Urupês',
        'Urânia',
        'Valentim Gentil',
        'Valinhos',
        'Valparaíso',
        'Vargem',
        'Vargem Grande Paulista',
        'Vargem Grande do Sul',
        'Vera Cruz',
        'Vinhedo',
        'Viradouro',
        'Vista Alegre do Alto',
        'Vitória Brasil',
        'Votorantim',
        'Votuporanga',
        'Várzea Paulista',
        'Zacarias',
        'Águas da Prata',
        'Águas de Lindóia',
        'Águas de Santa Bárbara',
        'Águas de São Pedro',
        'Álvares Florence',
        'Álvares Machado',
        'Álvaro de Carvalho',
        'Óleo'
    ],
    'TO': [
        'Abreulândia',
        'Aguiarnópolis',
        'Aliança do Tocantins',
        'Almas',
        'Alvorada',
        'Ananás',
        'Angico',
        'Aparecida do Rio Negro',
        'Aragominas',
        'Araguacema',
        'Araguanã',
        'Araguatins',
        'Araguaçu',
        'Araguaína',
        'Arapoema',
        'Arraias',
        'Augustinópolis',
        'Aurora do Tocantins',
        'Axixá do Tocantins',
        'Babaçulândia',
        'Bandeirantes do Tocantins',
        'Barra do Ouro',
        'Barrolândia',
        'Bernardo Sayão',
        'Bom Jesus do Tocantins',
        'Brasilândia do Tocantins',
        'Brejinho de Nazaré',
        'Buriti do Tocantins',
        'Cachoeirinha',
        'Campos Lindos',
        'Cariri do Tocantins',
        'Carmolândia',
        'Carrasco Bonito',
        'Caseara',
        'Centenário',
        'Chapada da Natividade',
        'Chapada de Areia',
        'Colinas do Tocantins',
        'Colméia',
        'Combinado',
        'Conceição do Tocantins',
        'Couto Magalhães',
        'Cristalândia',
        'Crixás do Tocantins',
        'Darcinópolis',
        'Dianópolis',
        'Divinópolis do Tocantins',
        'Dois Irmãos do Tocantins',
        'Dueré',
        'Esperantina',
        'Figueirópolis',
        'Filadélfia',
        'Formoso do Araguaia',
        'Fátima',
        'Goianorte',
        'Goiatins',
        'Guaraí',
        'Gurupi',
        'Ipueiras',
        'Itacajá',
        'Itaguatins',
        'Itapiratins',
        'Itaporã do Tocantins',
        'Jaú do Tocantins',
        'Juarina',
        'Lagoa da Confusão',
        'Lagoa do Tocantins',
        'Lajeado',
        'Lavandeira',
        'Lizarda',
        'Luzinópolis',
        'Marianópolis do Tocantins',
        'Mateiros',
        'Maurilândia do Tocantins',
        'Miracema do Tocantins',
        'Miranorte',
        'Monte Santo do Tocantins',
        'Monte do Carmo',
        'Muricilândia',
        'Natividade',
        'Nazaré',
        'Nova Olinda',
        'Nova Rosalândia',
        'Novo Acordo',
        'Novo Alegre',
        'Novo Jardim',
        'Oliveira de Fátima',
        'Palmas',
        'Palmeirante',
        'Palmeiras do Tocantins',
        'Palmeirópolis',
        'Paranã',
        'Paraíso do Tocantins',
        'Pau D\'Arco',
        'Pedro Afonso',
        'Peixe',
        'Pequizeiro',
        'Pindorama do Tocantins',
        'Piraquê',
        'Pium',
        'Ponte Alta do Bom Jesus',
        'Ponte Alta do Tocantins',
        'Porto Alegre do Tocantins',
        'Porto Nacional',
        'Praia Norte',
        'Presidente Kennedy',
        'Pugmil',
        'Recursolândia',
        'Riachinho',
        'Rio Sono',
        'Rio da Conceição',
        'Rio dos Bois',
        'Sampaio',
        'Sandolândia',
        'Santa Fé do Araguaia',
        'Santa Maria do Tocantins',
        'Santa Rita do Tocantins',
        'Santa Rosa do Tocantins',
        'Santa Tereza do Tocantins',
        'Santa Terezinha do Tocantins',
        'Silvanópolis',
        'Sucupira',
        'São Bento do Tocantins',
        'São Félix do Tocantins',
        'São Miguel do Tocantins',
        'São Salvador do Tocantins',
        'São Sebastião do Tocantins',
        'São Valério',
        'Sítio Novo do Tocantins',
        'Tabocão',
        'Taguatinga',
        'Taipas do Tocantins',
        'Talismã',
        'Tocantinópolis',
        'Tocantínia',
        'Tupirama',
        'Tupiratins',
        'Wanderlândia',
        'Xambioá'
    ],
};

// Função para popular o select de estados
function popularEstados() {
    const selectEstado = document.getElementById('estado');
    if (!selectEstado) {
        return;
    }
    
    selectEstado.innerHTML = '<option value="">Selecione o estado</option>';
    
    ESTADOS_BRASIL.forEach(estado => {
        const option = document.createElement('option');
        option.value = estado.sigla;
        option.textContent = `${estado.sigla} - ${estado.nome}`;
        selectEstado.appendChild(option);
    });
    
}

// Função para filtrar municípios por estado
function filtrarMunicipios(estado) {
    if (!estado) {
        return [];
    }
    
    const municipios = MUNICIPIOS_COMPLETOS[estado] || [];
    return municipios.sort();
}

// Função para criar autocompletar de cidade
function criarAutocompletarCidade() {
    const campoCidade = document.getElementById('cidade');
    const campoEstado = document.getElementById('estado');
    
    if (!campoCidade || !campoEstado) {
        return;
    }
    
    // Criar container para sugestões
    const sugestoesContainer = document.createElement('div');
    sugestoesContainer.id = 'sugestoes-cidade';
    sugestoesContainer.className = 'sugestoes-autocompletar';
    campoCidade.parentNode.appendChild(sugestoesContainer);
    
    // Evento de digitação na cidade
    campoCidade.addEventListener('input', function() {
        const valor = this.value.toLowerCase();
        const estado = campoEstado.value;
        
        if (valor.length < 2 || !estado) {
            sugestoesContainer.innerHTML = '';
            sugestoesContainer.style.display = 'none';
            return;
        }
        
        const municipios = filtrarMunicipios(estado);
        
        const sugestoes = municipios.filter(municipio => 
            municipio.toLowerCase().includes(valor)
        ).slice(0, 10);
        
        if (sugestoes.length > 0) {
            sugestoesContainer.innerHTML = sugestoes.map(municipio => 
                `<div class="sugestao-item" onclick="selecionarCidade('${municipio}')">${municipio}</div>`
            ).join('');
            sugestoesContainer.style.display = 'block';
        } else {
            sugestoesContainer.innerHTML = '';
            sugestoesContainer.style.display = 'none';
        }
    });
    
            // Evento de mudança no estado
        campoEstado.addEventListener('change', function() {
        campoCidade.value = '';
        sugestoesContainer.innerHTML = '';
        sugestoesContainer.style.display = 'none';
        
        // Limpar validação da cidade
        campoCidade.classList.remove('campo-valido', 'campo-invalido');
        const feedback = document.getElementById('feedback-cidade');
        if (feedback) feedback.innerHTML = '';
    });
    
    // Esconder sugestões ao clicar fora
    document.addEventListener('click', function(e) {
        if (!campoCidade.contains(e.target) && !sugestoesContainer.contains(e.target)) {
            sugestoesContainer.style.display = 'none';
        }
    });
    
        }

// Função para selecionar cidade
function selecionarCidade(cidade) {
    const campoCidade = document.getElementById('cidade');
    const sugestoesContainer = document.getElementById('sugestoes-cidade');
    
    if (campoCidade) {
        campoCidade.value = cidade;
        
        // Disparar evento de validação
        const event = new Event('input');
        campoCidade.dispatchEvent(event);
    }
    
    if (sugestoesContainer) {
        sugestoesContainer.style.display = 'none';
    }
}

// Função para validar cidade
function validarCidade(cidade, estado) {
    if (!estado || !cidade) {
        return false;
    }
    
    const municipios = filtrarMunicipios(estado);
    const cidadeExiste = municipios.some(municipio => 
        municipio.toLowerCase() === cidade.toLowerCase()
    );
    
    return cidadeExiste;
}

// Inicializar quando o DOM estiver carregado
document.addEventListener('DOMContentLoaded', function() {
    // Primeiro popular estados
    popularEstados();
    
    // Depois criar autocompletar de cidade
    setTimeout(() => {
        criarAutocompletarCidade();
    }, 100);
});
