#!/usr/bin/env python
"""
Script para atualizar as fotos de perfil das modelos
"""
import os
import django

# Configurar Django
os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'allure_project.settings')
django.setup()

from models.models import Modelo, FotoModelo

def update_profile_photos():
    """Atualiza as fotos de perfil das modelos"""
    print("🔄 Atualizando fotos de perfil das modelos...")
    
    modelos_atualizadas = 0
    
    for modelo in Modelo.objects.all():
        try:
            # Buscar foto de perfil da modelo
            foto_perfil = modelo.fotos.filter(categoria='rosto').first()
            
            if foto_perfil:
                # Atualizar o campo foto_perfil da modelo
                modelo.foto_perfil = foto_perfil.imagem
                modelo.save()
                print(f"✅ {modelo.nome_exibicao}: foto de perfil atualizada")
                modelos_atualizadas += 1
            else:
                print(f"⚠️  {modelo.nome_exibicao}: nenhuma foto de perfil encontrada")
                
        except Exception as e:
            print(f"❌ Erro ao atualizar {modelo.nome_exibicao}: {e}")
    
    print(f"🎉 {modelos_atualizadas} modelos tiveram fotos de perfil atualizadas!")

def verify_photos():
    """Verifica se as fotos estão sendo exibidas corretamente"""
    print("\n🔍 Verificando fotos das modelos...")
    
    for modelo in Modelo.objects.all():
        print(f"\n📸 {modelo.nome_exibicao}:")
        print(f"   - Foto de perfil: {modelo.foto_perfil}")
        print(f"   - Total de fotos: {modelo.fotos.count()}")
        
        # Listar algumas fotos
        fotos = modelo.fotos.all()[:3]
        for foto in fotos:
            print(f"   - {foto.categoria}: {foto.imagem}")

if __name__ == '__main__':
    update_profile_photos()
    verify_photos() 