# 🔧 Guia de Administração - Sistema de Gestão de Agência

## 👨‍💼 Perfil do Administrador

Como administrador, você tem acesso completo ao sistema e é responsável por:
- **Gestão de usuários** e permissões
- **Configuração do sistema**
- **Backup e manutenção**
- **Relatórios e análises**
- **Suporte técnico**

---

## 🔐 Acesso Administrativo

### Credenciais de Administrador
- **Usuário**: `admin`
- **Senha**: `admin123`
- **URL Admin**: http://localhost:8000/admin

### Primeiro Acesso
1. **Acesse** http://localhost:8000/admin
2. **Faça login** com as credenciais acima
3. **Altere a senha** imediatamente por segurança

---

## 👥 Gestão de Usuários

### Criando Novos Usuários

#### Via Admin Django:
1. **Acesse** Admin → Authentication and Authorization → Users
2. **Clique** em "Add User"
3. **Preencha**:
   - Username (obrigatório)
   - Email (obrigatório)
   - Password (obrigatório)
4. **Clique** em "Save"

#### Via Comando Django:
```bash
python manage.py createsuperuser
```

### Gerenciando Grupos e Permissões

#### Grupos Disponíveis:
1. **Gerentes** (40 permissões)
   - Acesso completo a projetos
   - Gestão de equipes
   - Relatórios gerenciais

2. **Colaboradores** (12 permissões)
   - Visualização de projetos
   - Edição de suas tarefas
   - Controle de tempo

3. **Clientes** (6 permissões)
   - Visualização de seus projetos
   - Acompanhamento de progresso

#### Adicionando Usuário a Grupo:
1. **Acesse** Admin → Users
2. **Clique** no usuário
3. **Selecione** o grupo desejado
4. **Clique** em "Save"

### Configurando Permissões Específicas

#### Permissões por App:
- **client**: add, change, delete, view
- **collaborator**: add, change, delete, view
- **project**: add, change, delete, view
- **task**: add, change, delete, view
- **notification**: add, change, delete, view

---

## 🏢 Gestão de Clientes

### Criando Cliente
1. **Acesse** Admin → Clients → Clients
2. **Clique** em "Add Client"
3. **Preencha**:
   - **Nome**: Nome da empresa
   - **CNPJ**: CNPJ válido
   - **Email**: Email de contato
   - **Telefone**: Telefone principal
   - **Endereço**: Endereço completo
   - **Ativo**: Marque se o cliente está ativo
4. **Clique** em "Save"

### Editando Cliente
1. **Acesse** a lista de clientes
2. **Clique** no cliente desejado
3. **Faça** as alterações necessárias
4. **Clique** em "Save"

### Desativando Cliente
1. **Acesse** o cliente
2. **Desmarque** o campo "Ativo"
3. **Clique** em "Save"

---

## 👥 Gestão de Colaboradores

### Criando Colaborador
1. **Acesse** Admin → Collaborators → Collaborators
2. **Clique** em "Add Collaborator"
3. **Preencha**:
   - **User**: Selecione o usuário Django
   - **Nome**: Nome completo
   - **Email**: Email profissional
   - **Área**: Área de trabalho
   - **Cargo**: Cargo na empresa
   - **Telefone**: Telefone de contato
   - **Data de Admissão**: Data de contratação
   - **Ativo**: Marque se está ativo
4. **Clique** em "Save"

### Gerenciando Áreas
1. **Acesse** Admin → Collaborators → Areas
2. **Crie novas áreas** conforme necessário
3. **Edite áreas existentes**
4. **Desative áreas** não utilizadas

### Áreas Padrão:
- Desenvolvimento
- Design
- Marketing
- Vendas
- Suporte
- Gestão de Projetos
- Recursos Humanos
- Financeiro
- Qualidade
- Infraestrutura

---

## 📊 Gestão de Projetos

### Criando Projeto
1. **Acesse** Admin → Projects → Projects
2. **Clique** em "Add Project"
3. **Preencha**:
   - **Nome**: Nome do projeto
   - **Portfolio**: Portfolio associado
   - **Workspace**: Workspace do projeto
   - **Cliente**: Cliente do projeto
   - **Cronograma**: Data de início e fim
   - **Status**: Status atual
   - **Prioridade**: Prioridade do projeto
   - **Orçamento**: Orçamento previsto
   - **Esforço Estimado**: Horas estimadas
4. **Clique** em "Save"

### Status de Projetos:
- **Planejamento**: Projeto em fase de planejamento
- **Em Andamento**: Projeto em execução
- **Concluído**: Projeto finalizado
- **Cancelado**: Projeto cancelado
- **Pausado**: Projeto temporariamente pausado

### Prioridades:
- **Baixa**: Prioridade baixa
- **Média**: Prioridade média
- **Alta**: Prioridade alta

---

## 📋 Gestão de Tarefas

### Criando Tarefa
1. **Acesse** Admin → Tasks → Tasks
2. **Clique** em "Add Task"
3. **Preencha**:
   - **Nome**: Nome da tarefa
   - **Grupo**: Grupo da tarefa
   - **Descrição**: Descrição detalhada
   - **Responsável**: Colaborador responsável
   - **Cronograma**: Data de início e fim
   - **Status**: Status atual
   - **Prioridade**: Prioridade da tarefa
   - **Esforço Estimado**: Horas estimadas
   - **Dependências**: Tarefas das quais depende
4. **Clique** em "Save"

### Status de Tarefas:
- **Não Iniciada**: Tarefa ainda não iniciada
- **Em Andamento**: Tarefa em execução
- **Pausada**: Tarefa temporariamente pausada
- **Concluída**: Tarefa finalizada
- **Cancelada**: Tarefa cancelada

---

## 🔔 Sistema de Notificações

### Configurando Notificações
1. **Acesse** Admin → Notifications → Notifications
2. **Visualize** todas as notificações
3. **Gerencie** status de leitura
4. **Configure** tipos de notificação

### Tipos de Notificação:
- **Tarefa Atribuída**: Nova tarefa atribuída
- **Prazo Próximo**: Tarefa com prazo próximo
- **Tarefa Atrasada**: Tarefa fora do prazo
- **Tarefa Concluída**: Tarefa finalizada
- **Comentário**: Novo comentário em tarefa

### Configurando Email
```python
# settings.py
EMAIL_BACKEND = 'django.core.mail.backends.smtp.EmailBackend'
EMAIL_HOST = 'smtp.gmail.com'
EMAIL_PORT = 587
EMAIL_USE_TLS = True
EMAIL_HOST_USER = 'seu-email@gmail.com'
EMAIL_HOST_PASSWORD = 'sua-senha'
```

---

## 📈 Relatórios e Análises

### Relatórios Disponíveis

#### 1. Progresso de Projetos
- Status de todos os projetos
- Progresso percentual
- Prazos e atrasos

#### 2. Produtividade por Colaborador
- Horas trabalhadas
- Tarefas concluídas
- Eficiência

#### 3. Análise de Prazos
- Tarefas atrasadas
- Tarefas no prazo
- Tendências

#### 4. Custos por Projeto
- Orçamento vs. Realizado
- Análise de custos
- ROI

### Gerando Relatórios
1. **Acesse** a seção de relatórios
2. **Selecione** o tipo de relatório
3. **Configure** filtros (período, projeto, colaborador)
4. **Clique** em "Gerar Relatório"
5. **Exporte** em PDF ou Excel

---

## 🔒 Backup e Segurança

### Backup do Banco de Dados

#### Backup Manual:
```bash
# SQLite
cp db.sqlite3 backup_$(date +%Y%m%d_%H%M%S).sqlite3

# PostgreSQL
pg_dump gestao_agencia > backup_$(date +%Y%m%d_%H%M%S).sql
```

#### Backup Automático:
```bash
#!/bin/bash
# backup_script.sh
DATE=$(date +%Y%m%d_%H%M%S)
cp db.sqlite3 backup_$DATE.sqlite3
tar -czf media_backup_$DATE.tar.gz media/
find . -name "backup_*.sqlite3" -mtime +7 -delete
```

#### Configurando Cron:
```bash
# Adicionar ao crontab
0 2 * * * /path/to/backup_script.sh
```

### Segurança

#### Senhas Fortes:
- Mínimo 8 caracteres
- Letras maiúsculas e minúsculas
- Números e símbolos
- Não usar senhas comuns

#### Controle de Acesso:
- Revisar permissões regularmente
- Remover usuários inativos
- Monitorar logs de acesso

#### Logs de Segurança:
```bash
# Verificar logs
tail -f django.log | grep "ERROR\|WARNING"
```

---

## 🛠️ Manutenção do Sistema

### Comandos de Manutenção

#### Verificar Sistema:
```bash
python manage.py check
```

#### Aplicar Migrações:
```bash
python manage.py migrate
```

#### Coletar Arquivos Estáticos:
```bash
python manage.py collectstatic
```

#### Limpar Cache:
```bash
python manage.py clearcache
```

### Limpeza de Dados

#### Notificações Antigas:
```python
# No shell Django
from notification.models import Notification
from django.utils import timezone
from datetime import timedelta

# Remover notificações com mais de 30 dias
Notification.objects.filter(
    created_at__lt=timezone.now()-timedelta(days=30)
).delete()
```

#### Logs Antigos:
```bash
# Limpar logs antigos
find . -name "*.log" -mtime +30 -delete
```

### Monitoramento

#### Verificar Status:
```bash
# Verificar se o servidor está rodando
curl -s -o /dev/null -w "%{http_code}" http://localhost:8000/

# Verificar uso de disco
df -h

# Verificar uso de memória
free -h
```

---

## 🚨 Solução de Problemas

### Problemas Comuns

#### 1. Erro de Migração
```bash
# Solução
python manage.py migrate --fake-initial
```

#### 2. Arquivos Estáticos Não Carregam
```bash
# Solução
python manage.py collectstatic --clear
```

#### 3. Celery Não Funciona
```bash
# Verificar Redis
redis-cli ping

# Reiniciar Celery
pkill -f celery
celery -A gestao_agencia worker --loglevel=info
```

#### 4. Erro de Permissão
```bash
# Verificar permissões
chmod +x start.sh
chmod -R 755 staticfiles/
```

#### 5. Banco de Dados Corrompido
```bash
# Backup e restauração
cp db.sqlite3 backup.sqlite3
python manage.py migrate --fake-initial
```

### Logs e Diagnóstico

#### Logs do Django:
```bash
tail -f django.log
```

#### Logs do Celery:
```bash
celery -A gestao_agencia worker --loglevel=debug
```

#### Verificar Configurações:
```bash
python manage.py check --deploy
```

---

## 📞 Suporte e Contato

### Informações de Contato
- **Email**: admin@gestaoagencia.com
- **Telefone**: (11) 99999-9999
- **Horário**: Segunda a Sexta, 9h às 18h

### Escalação de Problemas
1. **Nível 1**: Problemas básicos (reset de senha, acesso)
2. **Nível 2**: Problemas técnicos (erros, bugs)
3. **Nível 3**: Problemas críticos (sistema fora do ar)

### Documentação Adicional
- **Documentação Técnica**: `DOCUMENTACAO_COMPLETA.md`
- **Guia do Usuário**: `GUIA_USUARIO.md`
- **API REST**: `/api/`

---

## 📋 Checklist de Administração

### Diário:
- [ ] Verificar logs de erro
- [ ] Monitorar uso de recursos
- [ ] Verificar backups

### Semanal:
- [ ] Revisar usuários ativos
- [ ] Verificar permissões
- [ ] Analisar relatórios
- [ ] Atualizar documentação

### Mensal:
- [ ] Backup completo
- [ ] Limpeza de dados antigos
- [ ] Revisão de segurança
- [ ] Atualização do sistema

### Trimestral:
- [ ] Auditoria de permissões
- [ ] Revisão de performance
- [ ] Planejamento de melhorias
- [ ] Treinamento da equipe

---

**🔧 Este guia deve ser consultado regularmente para manter o sistema funcionando de forma otimizada.**

*Para dúvidas específicas ou problemas não cobertos neste guia, consulte a documentação técnica completa ou entre em contato com o suporte.* 