# 🚀 **DEPLOY CLOUDEZ - Sistema de Gestão de Agência**

## ✅ **CLOUDEZ COM PYTHON PRÉ-CONFIGURADO**

Baseado na [documentação oficial da Cloudez](https://help.cloudez.io/subir-aplicacao-customizada-em-python/), criamos uma solução completa para seu projeto Django!

---

## 🏗️ **ESTRUTURA DA CLOUDEZ**

```
/srv/gestao.blackbeans.com.br/
├── .virtualenv/3.7/          # Ambiente virtual Python
├── www/                      # Código da aplicação
├── etc/nginx/conf.d/         # Configuração Nginx
├── start_cloudez.sh          # Script de inicialização
└── gestao.service            # Serviço systemd
```

---

## 🚀 **PASSOS PARA DEPLOY**

### **1. PREPARAR NO PAINEL CLOUDEZ**

1. **Criar aplicação Python** no painel da Cloudez
2. **Escolher domínio**: `gestao.blackbeans.com.br`
3. **Selecionar Python 3.7** (ou versão disponível)
4. **Aguardar criação** do ambiente

### **2. PREPARAR PROJETO LOCAL**

```bash
# Compactar projeto (excluindo arquivos desnecessários)
tar -czf gestao_agencia_cloudez.tar.gz \
    --exclude=venv \
    --exclude=__pycache__ \
    --exclude=.git \
    --exclude=*.pyc \
    --exclude=.coverage \
    --exclude=htmlcov \
    .
```

### **3. UPLOAD PARA CLOUDEZ**

#### **Opção A: Via SSH**
```bash
# Conectar via SSH
ssh usuario@seu-servidor-cloudez.com

# Navegar para diretório
cd /srv/gestao.blackbeans.com.br/

# Fazer upload do arquivo .tar.gz
# (via SCP, SFTP ou painel da Cloudez)

# Extrair
tar -xzf gestao_agencia_cloudez.tar.gz -C www/
```

#### **Opção B: Via Painel**
1. Acessar painel da Cloudez
2. Ir em **Gerenciador de Arquivos**
3. Navegar para `/srv/gestao.seudominio.com/www/`
4. Fazer upload dos arquivos

### **4. EXECUTAR DEPLOY**

```bash
# Conectar via SSH
ssh usuario@seu-servidor-cloudez.com

# Navegar para diretório do projeto
cd /srv/gestao.blackbeans.com.br/www/

# Executar deploy
./deploy_cloudez.sh
```

---

## 📁 **ARQUIVOS CRIADOS**

### **1. `start_cloudez.sh`** - Script de inicialização
- Ativa ambiente virtual da Cloudez
- Executa migrações
- Coleta arquivos estáticos
- Inicia Gunicorn

### **2. `gestao.service`** - Serviço systemd
- Configura serviço automático
- Define variáveis de ambiente
- Configura restart automático

### **3. `proxy.conf`** - Configuração Nginx
- Proxy para aplicação Django
- Servir arquivos estáticos
- Configurações de cache

### **4. `deploy_cloudez.sh`** - Script de deploy
- Deploy completo automatizado
- Configuração de ambiente
- Verificação de status

---

## ⚙️ **CONFIGURAÇÕES IMPORTANTES**

### **1. Variáveis de Ambiente (.env)**
```bash
# Django
SECRET_KEY=sua-chave-secreta-muito-segura
DEBUG=False
ALLOWED_HOSTS=gestao.blackbeans.com.br

# Banco de dados (SQLite para Cloudez)
DATABASE_URL=sqlite:///db.sqlite3

# Email
EMAIL_HOST=smtp.gmail.com
EMAIL_PORT=587
EMAIL_HOST_USER=seu-email@gmail.com
EMAIL_HOST_PASSWORD=sua-senha-app
```

### **2. Configuração Django (settings.py)**
```python
# Já configurado para usar variáveis de ambiente
SECRET_KEY = os.environ.get('SECRET_KEY', 'default-key')
DEBUG = os.environ.get('DEBUG', 'False').lower() == 'true'
ALLOWED_HOSTS = os.environ.get('ALLOWED_HOSTS', 'localhost').split(',')
```

---

## 🔧 **COMANDOS ÚTEIS**

### **Gerenciar Serviço**
```bash
# Status do serviço
sudo systemctl status gestao

# Reiniciar serviço
sudo systemctl restart gestao

# Parar serviço
sudo systemctl stop gestao

# Ver logs
sudo journalctl -u gestao -f
```

### **Gerenciar Aplicação**
```bash
# Ativar ambiente virtual
source /srv/gestao.blackbeans.com.br/.virtualenv/3.7/bin/activate

# Navegar para aplicação
cd /srv/gestao.blackbeans.com.br/www/

# Executar comandos Django
python manage.py shell
python manage.py createsuperuser
python manage.py collectstatic
```

### **Gerenciar Nginx**
```bash
# Verificar configuração
sudo nginx -t

# Reiniciar Nginx
sudo systemctl restart nginx

# Ver logs
sudo tail -f /var/log/nginx/error.log
```

---

## 🌐 **CONFIGURAÇÃO DE DOMÍNIO**

### **1. DNS**
```
Tipo: A
Nome: gestao
Valor: IP_DO_SERVIDOR_CLOUDEZ
```

### **2. SSL/HTTPS**
- A Cloudez geralmente fornece SSL automático
- Verificar no painel se está ativo

---

## 📊 **MONITORAMENTO**

### **Logs da Aplicação**
```bash
# Logs do serviço
sudo journalctl -u gestao -f

# Logs do Nginx
sudo tail -f /var/log/nginx/access.log
sudo tail -f /var/log/nginx/error.log

# Logs do Django
tail -f /srv/gestao.blackbeans.com.br/www/django.log
```

### **Status dos Serviços**
```bash
# Verificar todos os serviços
sudo systemctl status gestao nginx

# Verificar processos
ps aux | grep gunicorn
ps aux | grep nginx
```

---

## 🚨 **TROUBLESHOOTING**

### **Problema: Erro 502 Bad Gateway**
```bash
# Verificar se o serviço está rodando
sudo systemctl status gestao

# Verificar se a porta está em uso
netstat -tlnp | grep 8050

# Reiniciar serviço
sudo systemctl restart gestao
```

### **Problema: Arquivos estáticos não carregam**
```bash
# Coletar arquivos estáticos
cd /srv/gestao.blackbeans.com.br/www/
python manage.py collectstatic --noinput

# Verificar permissões
sudo chown -R www-data:www-data staticfiles/
```

### **Problema: Migrações não funcionam**
```bash
# Verificar banco de dados
python manage.py showmigrations

# Executar migrações
python manage.py migrate --verbosity=2
```

---

## 🎯 **CHECKLIST DE DEPLOY**

### ✅ **Pré-Deploy**
- [ ] Aplicação Python criada no painel Cloudez
- [ ] Projeto testado localmente
- [ ] Arquivos compactados
- [ ] Variáveis de ambiente configuradas

### ✅ **Deploy**
- [ ] Arquivos enviados para servidor
- [ ] Script de deploy executado
- [ ] Serviço iniciado
- [ ] Nginx configurado

### ✅ **Pós-Deploy**
- [ ] Site acessível
- [ ] Login funcionando
- [ ] Logs sem erros
- [ ] SSL funcionando

---

## 🎉 **RESULTADO FINAL**

Após o deploy, você terá:
- 🌐 **Site rodando**: `https://gestao.blackbeans.com.br`
- 🔐 **Admin**: `https://gestao.blackbeans.com.br/admin`
- ⚡ **Performance**: Gunicorn + Nginx
- 🔒 **Segurança**: SSL automático
- 📊 **Monitoramento**: Logs completos

---

## 📞 **SUPORTE**

- **Documentação Cloudez**: [https://help.cloudez.io/subir-aplicacao-customizada-em-python/](https://help.cloudez.io/subir-aplicacao-customizada-em-python/)
- **Logs**: `sudo journalctl -u gestao -f`
- **Status**: `sudo systemctl status gestao`

**🚀 Pronto para deploy na Cloudez!** 