# 👥 Guia do Usuário - Sistema de Gestão de Agência

## 🚀 Primeiros Passos

### 1. Acessando o Sistema

1. **Abra seu navegador**
2. **Digite**: `http://localhost:8000`
3. **Faça login** com suas credenciais

### 2. Credenciais de Acesso

| Função | Usuário | Senha |
|--------|---------|-------|
| **Administrador** | `admin` | `admin123` |
| **Gerente** | `gerente` | `123456` |
| **Desenvolvedora** | `ana.dev` | `123456` |
| **Designer** | `carlos.design` | `123456` |
| **Marketing** | `maria.marketing` | `123456` |

---

## 📊 Dashboard - Sua Central de Controle

### O que você vê no Dashboard:

1. **📈 Estatísticas Gerais**
   - Projetos ativos
   - Tarefas pendentes
   - Tarefas atrasadas
   - Progresso geral

2. **📋 Projetos Recentes**
   - Últimos projetos criados
   - Status de cada projeto
   - Progresso percentual

3. **⏰ Tarefas Pendentes**
   - Suas tarefas não iniciadas
   - Tarefas em andamento
   - Prazos próximos

4. **🔔 Notificações**
   - Alertas importantes
   - Tarefas atribuídas
   - Prazos vencendo

---

## 🎯 Como Usar o Sistema

### 📝 Criando uma Nova Tarefa

#### Passo a Passo:

1. **Acesse o menu "Tarefas"**
2. **Clique em "Nova Tarefa"**
3. **Preencha os campos**:
   - **Nome**: "Desenvolver página de login"
   - **Grupo**: Selecione o grupo (ex: "Desenvolvimento")
   - **Descrição**: "Criar página de login responsiva com validação"
   - **Responsável**: Selecione você mesmo ou outro colaborador
   - **Data de Início**: 15/01/2024
   - **Data de Fim**: 20/01/2024
   - **Prioridade**: Média
   - **Esforço Estimado**: 8 horas
4. **Clique em "Salvar"**

#### Dicas:
- Use nomes claros e objetivos
- Descreva bem o que precisa ser feito
- Defina prazos realistas
- Escolha a prioridade adequada

### ⏱️ Controlando o Tempo

#### Iniciando o Trabalho:
1. **Vá para a lista de tarefas**
2. **Encontre sua tarefa**
3. **Clique no botão "▶️ Iniciar"**
4. **O cronômetro começará a contar**

#### Pausando o Trabalho:
1. **Durante o trabalho, clique em "⏸️ Pausar"**
2. **O tempo será salvo automaticamente**
3. **Para retomar, clique em "▶️ Iniciar" novamente**

#### Finalizando a Tarefa:
1. **Clique em "✅ Concluir"**
2. **Confirme a conclusão**
3. **A tarefa mudará para "Concluída"**

### 📊 Visualizando Projetos

#### Lista de Projetos:
1. **Acesse "Projetos" no menu**
2. **Veja todos os projetos ativos**
3. **Clique em um projeto para ver detalhes**

#### Detalhes do Projeto:
- **Informações gerais**
- **Boards disponíveis**
- **Progresso geral**
- **Equipe envolvida**
- **Cronograma**

### 🎨 Usando os Boards Kanban

#### O que são Boards:
- **Quadros visuais** para organizar tarefas
- **Colunas** representam status (A Fazer, Em Andamento, Concluído)
- **Cartões** representam tarefas

#### Como usar:
1. **Acesse um projeto**
2. **Clique em um Board**
3. **Arraste tarefas** entre as colunas
4. **Clique em uma tarefa** para ver detalhes

#### Exemplo de Board:
```
┌─────────────┬─────────────────┬─────────────┐
│   A Fazer   │  Em Andamento   │  Concluído  │
├─────────────┼─────────────────┼─────────────┤
│ Tarefa 1    │ Tarefa 2        │ Tarefa 3    │
│ Tarefa 4    │ Tarefa 5        │ Tarefa 6    │
└─────────────┴─────────────────┴─────────────┘
```

---

## 🔔 Sistema de Notificações

### Tipos de Notificação:

1. **📋 Tarefa Atribuída**
   - Quando alguém te atribui uma tarefa
   - Clique para ver os detalhes

2. **⏰ Prazo Próximo**
   - Tarefa com prazo vencendo em 24h
   - Ação: Inicie ou atualize o status

3. **🚨 Tarefa Atrasada**
   - Tarefa fora do prazo
   - Ação: Atualize o prazo ou status

4. **✅ Tarefa Concluída**
   - Tarefa finalizada por você ou outro
   - Confirmação de conclusão

### Gerenciando Notificações:

1. **Clique no ícone 🔔 no topo**
2. **Veja notificações não lidas**
3. **Clique em uma notificação** para marcá-la como lida
4. **Acesse "Todas as Notificações"** para ver histórico

---

## 👥 Trabalhando em Equipe

### 📞 Comunicando com a Equipe:

1. **Use a descrição das tarefas** para explicar o que precisa ser feito
2. **Atualize o status** regularmente para manter todos informados
3. **Use comentários** nas tarefas para discussões específicas

### 🤝 Colaborando em Projetos:

1. **Visualize o progresso** dos outros no board
2. **Respeite os prazos** definidos
3. **Comunique bloqueios** ou problemas
4. **Ajude colegas** quando possível

### 📈 Acompanhando o Progresso:

1. **Dashboard**: Visão geral do projeto
2. **Boards**: Status detalhado das tarefas
3. **Relatórios**: Análises e estatísticas

---

## 🎨 Personalizando sua Experiência

### 🔧 Configurações do Perfil:

1. **Clique no seu nome** no canto superior direito
2. **Acesse "Meu Perfil"**
3. **Edite suas informações**:
   - Nome completo
   - Email
   - Telefone
   - Foto de perfil

### 📱 Preferências de Notificação:

1. **Acesse "Configurações"**
2. **Configure notificações**:
   - Email para novas tarefas
   - Alertas de prazo
   - Notificações de conclusão

### 🎯 Filtros e Busca:

1. **Use a barra de busca** para encontrar tarefas
2. **Aplique filtros** por:
   - Status
   - Responsável
   - Projeto
   - Data

---

## 🚨 Resolução de Problemas

### ❌ Problemas Comuns:

#### "Não consigo acessar o sistema"
- **Verifique**: URL correta (http://localhost:8000)
- **Verifique**: Credenciais corretas
- **Solução**: Contate o administrador

#### "Tarefa não aparece"
- **Verifique**: Filtros aplicados
- **Verifique**: Se você é responsável
- **Solução**: Use a busca ou remova filtros

#### "Cronômetro não funciona"
- **Verifique**: Se a tarefa está ativa
- **Verifique**: Conexão com internet
- **Solução**: Recarregue a página

#### "Notificações não chegam"
- **Verifique**: Configurações de notificação
- **Verifique**: Email cadastrado
- **Solução**: Atualize configurações

### 📞 Onde Pedir Ajuda:

1. **Administrador do Sistema**: Para problemas técnicos
2. **Gerente do Projeto**: Para dúvidas sobre tarefas
3. **Documentação**: Este guia e documentação técnica
4. **Suporte**: Email ou chat interno

---

## 💡 Dicas e Boas Práticas

### ✅ Dicas para Produtividade:

1. **Organize suas tarefas** por prioridade
2. **Use o cronômetro** para controlar seu tempo
3. **Atualize status** regularmente
4. **Comunique bloqueios** rapidamente
5. **Revise tarefas** antes de marcar como concluída

### 🎯 Dicas para Gestão de Tempo:

1. **Estime bem** o esforço necessário
2. **Defina prazos realistas**
3. **Use o cronômetro** para melhorar estimativas
4. **Revise progresso** diariamente
5. **Ajuste prazos** quando necessário

### 🤝 Dicas para Trabalho em Equipe:

1. **Seja claro** nas descrições
2. **Atualize status** para manter todos informados
3. **Ajude colegas** quando possível
4. **Comunique problemas** rapidamente
5. **Celebre conquistas** da equipe

---

## 📚 Recursos Adicionais

### 🔗 Links Úteis:

- **Documentação Técnica**: `DOCUMENTACAO_COMPLETA.md`
- **API REST**: `/api/` (para desenvolvedores)
- **Admin Django**: `/admin/` (para administradores)

### 📖 Próximos Passos:

1. **Explore todas as funcionalidades**
2. **Crie suas primeiras tarefas**
3. **Experimente o cronômetro**
4. **Configure suas notificações**
5. **Colabore com a equipe**

---

**🎉 Parabéns! Você está pronto para usar o Sistema de Gestão de Agência!**

*Este guia foi criado para ajudá-lo a aproveitar ao máximo o sistema. Em caso de dúvidas, consulte a documentação técnica ou entre em contato com o suporte.* 