# 🚀 **DEPLOY UWSGI - Sistema de Gestão de Agência**

## ✅ **SIM! ESCOLHA A OPÇÃO PYTHON COM UWSGI**

Essa é a **melhor escolha** para seu projeto Django!

---

## 🎯 **POR QUE UWSGI É PERFEITO**

### **✅ Vantagens**
- **Performance**: Muito mais rápido que servidor de desenvolvimento
- **Estabilidade**: Produção-ready, usado por grandes sites
- **Configuração**: Já vem pré-configurado no seu servidor
- **Compatibilidade**: Perfeito para Django
- **Recursos**: Processos múltiplos, threads, cache

### **🏗️ Arquitetura**
```
Nginx/Apache → uWSGI → Django → Banco de Dados
```

---

## 🚀 **PASSOS PARA DEPLOY**

### **1. PREPARAR PROJETO LOCAL**
```bash
# Compactar projeto
tar -czf gestao_agencia.tar.gz --exclude=venv --exclude=__pycache__ --exclude=.git .

# Ou usar Git
git push origin main
```

### **2. NO SERVIDOR**

#### **2.1 Acessar o servidor**
```bash
ssh usuario@seu-servidor.com
```

#### **2.2 Baixar projeto**
```bash
# Via Git (recomendado)
git clone <seu-repositorio>
cd gestao_agencia

# Ou via upload
# Fazer upload do arquivo .tar.gz
tar -xzf gestao_agencia.tar.gz
cd gestao_agencia
```

#### **2.3 Configurar ambiente**
```bash
# Criar ambiente virtual
python3 -m venv venv
source venv/bin/activate

# Instalar dependências
pip install -r requirements.txt

# Configurar variáveis de ambiente
cp env.example .env
nano .env
```

#### **2.4 Configurar banco de dados**
```bash
# Se usar SQLite (desenvolvimento)
python manage.py migrate

# Se usar PostgreSQL (produção)
# Configurar DATABASE_URL no .env
python manage.py migrate
```

#### **2.5 Deploy com uWSGI**
```bash
# Executar script de deploy
./deploy_uwsgi.sh
```

---

## ⚙️ **CONFIGURAÇÕES IMPORTANTES**

### **1. Arquivo .env**
```bash
# Django
SECRET_KEY=sua-chave-secreta-muito-segura
DEBUG=False
ALLOWED_HOSTS=seu-subdominio.seudominio.com

# Banco de dados
DATABASE_URL=postgresql://user:pass@localhost:5432/gestao_agencia

# Email
EMAIL_HOST=smtp.gmail.com
EMAIL_PORT=587
EMAIL_HOST_USER=seu-email@gmail.com
EMAIL_HOST_PASSWORD=sua-senha-app
```

### **2. Configuração uWSGI (uwsgi.ini)**
```ini
[uwsgi]
module = gestao_agencia.wsgi:application
master = true
processes = 4
threads = 2
http = :8000
socket = /tmp/uwsgi.sock
chmod-socket = 666
pidfile = /tmp/uwsgi.pid
vacuum = true
die-on-term = true
logto = /var/log/uwsgi/gestao_agencia.log
env = DJANGO_SETTINGS_MODULE=gestao_agencia.settings
```

---

## 🔧 **COMANDOS ÚTEIS**

### **Gerenciar uWSGI**
```bash
# Iniciar
sudo uwsgi --ini uwsgi.ini --daemonize

# Parar
sudo uwsgi --stop /tmp/uwsgi.pid

# Recarregar (após mudanças no código)
sudo uwsgi --reload /tmp/uwsgi.pid

# Ver logs
sudo tail -f /var/log/uwsgi/gestao_agencia.log

# Ver status
ps aux | grep uwsgi
```

### **Gerenciar Django**
```bash
# Ativar ambiente
source venv/bin/activate

# Migrações
python manage.py migrate

# Superusuário
python manage.py createsuperuser

# Shell
python manage.py shell

# Coletar estáticos
python manage.py collectstatic --noinput
```

---

## 🌐 **CONFIGURAÇÃO DE DOMÍNIO**

### **1. DNS**
```
Tipo: A
Nome: gestao (ou o nome que quiser)
Valor: IP_DO_SEU_SERVIDOR
```

### **2. Nginx (se disponível)**
```nginx
server {
    listen 80;
    server_name gestao.seudominio.com;

    location /static/ {
        alias /opt/gestao_agencia/staticfiles/;
    }

    location / {
        include uwsgi_params;
        uwsgi_pass unix:/tmp/uwsgi.sock;
    }
}
```

---

## 📊 **MONITORAMENTO**

### **Logs**
```bash
# Logs do uWSGI
sudo tail -f /var/log/uwsgi/gestao_agencia.log

# Logs do Django
tail -f django.log

# Logs do sistema
sudo journalctl -u uwsgi -f
```

### **Performance**
```bash
# Ver processos
ps aux | grep uwsgi

# Ver uso de memória
free -h

# Ver uso de disco
df -h
```

---

## 🚨 **TROUBLESHOOTING**

### **Problema: uWSGI não inicia**
```bash
# Verificar logs
sudo tail -f /var/log/uwsgi/gestao_agencia.log

# Verificar permissões
ls -la /tmp/uwsgi.sock

# Verificar configuração
uwsgi --ini uwsgi.ini --check-static
```

### **Problema: Erro 502 Bad Gateway**
```bash
# Verificar se uWSGI está rodando
ps aux | grep uwsgi

# Verificar socket
ls -la /tmp/uwsgi.sock

# Reiniciar uWSGI
sudo uwsgi --stop /tmp/uwsgi.pid
sudo uwsgi --ini uwsgi.ini --daemonize
```

### **Problema: Arquivos estáticos não carregam**
```bash
# Coletar arquivos estáticos
python manage.py collectstatic --noinput

# Verificar permissões
sudo chown -R www-data:www-data staticfiles/
```

---

## 🎯 **CHECKLIST DE DEPLOY**

### ✅ **Pré-Deploy**
- [ ] Código testado localmente
- [ ] Variáveis de ambiente configuradas
- [ ] Banco de dados configurado
- [ ] Arquivos estáticos coletados

### ✅ **Deploy**
- [ ] Projeto enviado para servidor
- [ ] Ambiente virtual criado
- [ ] Dependências instaladas
- [ ] Migrações executadas
- [ ] uWSGI configurado
- [ ] uWSGI iniciado

### ✅ **Pós-Deploy**
- [ ] Site acessível
- [ ] Login funcionando
- [ ] Logs sem erros
- [ ] Performance OK

---

## 🎉 **RESULTADO FINAL**

Após o deploy, você terá:
- 🌐 Site rodando em: `http://gestao.seudominio.com`
- 🔐 Admin em: `http://gestao.seudominio.com/admin`
- ⚡ Performance de produção
- 📊 Logs e monitoramento
- 🔄 Deploy automatizado

**🚀 Pronto para usar em produção!** 