# 🚀 Instalação Rápida - Sistema de Gestão de Agência

## ✅ Instalação Concluída!

O sistema foi instalado com sucesso! Aqui estão as informações importantes:

### 🔐 Acesso ao Sistema

- **URL Principal**: http://localhost:8000
- **Admin**: http://localhost:8000/admin

### 👥 Usuários de Exemplo

| Usuário | Senha | Função |
|---------|-------|--------|
| `admin` | `admin123` | Administrador |
| `gerente` | `123456` | Gerente de Projetos |
| `ana.dev` | `123456` | Desenvolvedora Senior |
| `carlos.design` | `123456` | Designer UX/UI |
| `maria.marketing` | `123456` | Analista de Marketing |
| `pedro.dev` | `123456` | Desenvolvedor Pleno |
| `lucia.qa` | `123456` | Analista de Qualidade |

### 🚀 Como Iniciar o Sistema

#### Opção 1: Script Automático (Recomendado)
```bash
./start.sh
```

#### Opção 2: Manual
```bash
# Ativar ambiente virtual
source venv/bin/activate

# Iniciar servidor
python manage.py runserver
```

### 📁 Estrutura do Projeto

```
gestao_agencia/
├── venv/                    # Ambiente virtual Python
├── db.sqlite3              # Banco de dados SQLite
├── staticfiles/            # Arquivos estáticos coletados
├── start.sh               # Script de inicialização
├── manage.py              # Script de gerenciamento Django
├── requirements.txt       # Dependências Python
└── gestao_agencia/        # Configurações principais
    ├── settings.py        # Configurações Django
    ├── urls.py           # URLs principais
    └── management/       # Comandos personalizados
```

### 🔧 Funcionalidades Disponíveis

- ✅ **Gestão de Clientes**: Cadastro e controle de clientes
- ✅ **Gestão de Colaboradores**: Equipe organizada por áreas
- ✅ **Workspaces**: Espaços de trabalho por cliente
- ✅ **Portfolios**: Agrupamento de projetos
- ✅ **Projetos**: Gestão completa de projetos
- ✅ **Boards Kanban**: Organização visual de tarefas
- ✅ **Tarefas**: Controle detalhado de atividades
- ✅ **Notificações**: Sistema de alertas
- ✅ **API REST**: Endpoints para integração
- ✅ **Relatórios**: Dashboards e estatísticas

### 🛠️ Comandos Úteis

```bash
# Ativar ambiente virtual
source venv/bin/activate

# Criar superusuário
python manage.py createsuperuser

# Aplicar migrações
python manage.py migrate

# Carregar dados de exemplo
python manage.py load_sample_data

# Coletar arquivos estáticos
python manage.py collectstatic

# Acessar shell Django
python manage.py shell
```

### 🔍 Verificação da Instalação

Para verificar se tudo está funcionando:

1. **Teste o servidor**:
   ```bash
   ./start.sh
   ```

2. **Acesse o admin**:
   - URL: http://localhost:8000/admin
   - Login: admin / admin123

3. **Verifique os dados**:
   - Clientes criados
   - Colaboradores cadastrados
   - Projetos de exemplo
   - Tarefas organizadas

### 🐛 Solução de Problemas

#### Erro: "No module named 'django'"
```bash
source venv/bin/activate
pip install -r requirements.txt
```

#### Erro: "Database does not exist"
```bash
python manage.py migrate
```

#### Erro: "Static files not found"
```bash
python manage.py collectstatic
```

#### Erro: "Port 8000 already in use"
```bash
# Encerre o processo ou use outra porta
python manage.py runserver 8001
```

### 📞 Suporte

Se encontrar problemas:

1. Verifique se o ambiente virtual está ativado
2. Confirme se todas as dependências estão instaladas
3. Verifique se as migrações foram aplicadas
4. Consulte os logs em `django.log`

---

**🎉 Parabéns! O Sistema de Gestão de Agência está pronto para uso!** 