# Gestão de Agência - Sistema de Gestão de Projetos

Sistema completo de gestão de projetos inspirado no Monday.com, desenvolvido em Django com interface Bootstrap 5.

## 🚀 Características

- **Hierarquia Completa**: Workspace → Portfolio → Project → Board → Group → Task
- **API REST**: Django REST Framework com endpoints completos
- **Interface Moderna**: Bootstrap 5 com design responsivo
- **Sistema de Notificações**: Notificações em tempo real e por email
- **Controle de Tempo**: Cronômetro integrado para tarefas
- **Permissões Granulares**: Sistema de grupos e permissões customizado
- **Relatórios**: Dashboards e estatísticas detalhadas
- **Tarefas Assíncronas**: Celery para processamento em background

## 📋 Módulos

### Core
- **Client**: Gestão de clientes com CNPJ, contatos e endereços
- **Collaborator**: Colaboradores organizados por áreas com valores/hora
- **Workspace**: Espaços de trabalho por cliente com cores personalizadas

### Projetos
- **Portfolio**: Agrupamento de projetos relacionados
- **Project**: Projetos com cronogramas, orçamentos e status
- **Board**: Quadros Kanban para organização visual
- **Group**: Grupos de tarefas dentro dos boards
- **Task**: Tarefas com dependências, responsáveis e controle de tempo

### Sistema
- **Notification**: Sistema completo de notificações
- **Authentication**: Autenticação e permissões por grupos
- **API**: Endpoints REST para integração

## 🛠️ Tecnologias

- **Backend**: Django 5.2, Django REST Framework
- **Frontend**: Bootstrap 5, jQuery, HTML5/CSS3
- **Banco de Dados**: SQLite (desenvolvimento) / PostgreSQL (produção)
- **Cache/Queue**: Redis + Celery
- **Email**: SMTP configurável
- **API**: REST com documentação automática

## 📦 Instalação

### Pré-requisitos

- Python 3.11+
- pip
- Redis (opcional, para Celery)

### Instalação Rápida

1. **Clone o repositório**
```bash
git clone <repository-url>
cd gestao_agencia
```

2. **Instale as dependências**
```bash
pip install -r requirements.txt
```

3. **Execute a configuração inicial**
```bash
python setup.py
```

Este script irá:
- Criar e aplicar migrações
- Criar superusuário (admin/admin123)
- Configurar grupos e permissões
- Carregar dados de exemplo
- Configurar arquivos estáticos

### Instalação Manual

Se preferir fazer a instalação passo a passo:

```bash
# 1. Migrações
python manage.py makemigrations
python manage.py migrate

# 2. Criar superusuário
python manage.py createsuperuser

# 3. Configurar grupos
python manage.py setup_groups

# 4. Carregar dados de exemplo (opcional)
python manage.py load_sample_data

# 5. Arquivos estáticos
python manage.py collectstatic
```

## 🚀 Execução

### Servidor Django
```bash
python manage.py runserver
```

Acesse: http://localhost:8000

### Celery (Opcional)

Para tarefas assíncronas e notificações:

```bash
# Worker
celery -A gestao_agencia worker --loglevel=info

# Beat (tarefas periódicas)
celery -A gestao_agencia beat --loglevel=info
```

## 👥 Usuários de Exemplo

Após executar `load_sample_data`:

### Administrador
- **Usuário**: admin
- **Senha**: admin123
- **Acesso**: Completo ao sistema

### Gerente
- **Usuário**: gerente
- **Senha**: 123456
- **Acesso**: Gestão de projetos e equipes

### Colaboradores
- **ana.dev** / 123456 (Desenvolvedora)
- **carlos.design** / 123456 (Designer)
- **maria.marketing** / 123456 (Marketing)
- **pedro.dev** / 123456 (Desenvolvedor)
- **lucia.qa** / 123456 (QA)

## 📊 Estrutura do Projeto

```
gestao_agencia/
├── gestao_agencia/          # Configurações principais
│   ├── settings.py          # Configurações Django
│   ├── urls.py             # URLs principais
│   ├── permissions.py      # Permissões customizadas
│   ├── middleware.py       # Middleware customizado
│   └── celery.py          # Configuração Celery
├── client/                 # App de clientes
├── collaborator/          # App de colaboradores
├── workspace/             # App de workspaces
├── portfolio/             # App de portfolios
├── project/               # App de projetos
├── board/                 # App de boards
├── task/                  # App de tarefas
├── notification/          # App de notificações
├── templates/             # Templates HTML
├── static/                # Arquivos estáticos
├── requirements.txt       # Dependências Python
└── setup.py              # Script de configuração
```

## 🔧 Configuração

### Banco de Dados

Por padrão usa SQLite. Para PostgreSQL:

```python
# settings.py
DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.postgresql',
        'NAME': 'gestao_agencia',
        'USER': 'postgres',
        'PASSWORD': 'password',
        'HOST': 'localhost',
        'PORT': '5432',
    }
}
```

### Email

Configure SMTP em `settings.py`:

```python
EMAIL_BACKEND = 'django.core.mail.backends.smtp.EmailBackend'
EMAIL_HOST = 'smtp.gmail.com'
EMAIL_PORT = 587
EMAIL_USE_TLS = True
EMAIL_HOST_USER = 'seu-email@gmail.com'
EMAIL_HOST_PASSWORD = 'sua-senha'
```

### Redis/Celery

```python
CELERY_BROKER_URL = 'redis://localhost:6379/0'
CELERY_RESULT_BACKEND = 'redis://localhost:6379/0'
```

## 📱 API REST

### Endpoints Principais

- `/api/clients/` - Clientes
- `/api/collaborators/` - Colaboradores
- `/api/workspaces/` - Workspaces
- `/api/projects/` - Projetos
- `/api/boards/` - Boards
- `/api/tasks/` - Tarefas
- `/api/notifications/` - Notificações

### Autenticação

```bash
# Login
POST /api/auth/login/
{
    "username": "admin",
    "password": "admin123"
}

# Usar token nas requisições
Authorization: Token <token>
```

### Exemplos de Uso

```bash
# Listar projetos
GET /api/projects/

# Criar tarefa
POST /api/tasks/
{
    "nome": "Nova Tarefa",
    "descricao": "Descrição da tarefa",
    "group": 1,
    "responsavel": 1,
    "cronograma_inicio": "2024-01-15",
    "cronograma_fim": "2024-01-20",
    "prioridade": "alta"
}

# Atualizar status da tarefa
PATCH /api/tasks/1/update_status/
{
    "status": "em_andamento"
}
```

## 🎨 Interface

### Dashboard
- Estatísticas gerais
- Projetos recentes
- Tarefas pendentes
- Ações rápidas

### Gestão de Projetos
- Visualização Kanban
- Timeline de projetos
- Controle de progresso
- Relatórios detalhados

### Controle de Tempo
- Cronômetro integrado
- Registro automático
- Relatórios de produtividade

## 🔐 Permissões

### Grupos de Usuários

1. **Gerentes**
   - Acesso completo a projetos
   - Gestão de equipes
   - Relatórios gerenciais

2. **Colaboradores**
   - Visualização de projetos
   - Edição de suas tarefas
   - Controle de tempo

3. **Clientes**
   - Visualização de seus projetos
   - Acompanhamento de progresso

## 📈 Funcionalidades Avançadas

### Notificações Automáticas
- Tarefas atribuídas
- Prazos próximos
- Tarefas atrasadas
- Conclusão de tarefas

### Relatórios
- Progresso de projetos
- Produtividade por colaborador
- Análise de prazos
- Custos por projeto

### Integrações
- API REST completa
- Webhooks (configurável)
- Export de dados
- Import de projetos

## 🐛 Troubleshooting

### Problemas Comuns

1. **Erro de migração**
```bash
python manage.py migrate --fake-initial
```

2. **Arquivos estáticos não carregam**
```bash
python manage.py collectstatic --clear
```

3. **Celery não funciona**
- Verifique se o Redis está rodando
- Confirme as configurações de BROKER_URL

### Logs

```bash
# Django
tail -f logs/django.log

# Celery
celery -A gestao_agencia worker --loglevel=debug
```

## 🤝 Contribuição

1. Fork o projeto
2. Crie uma branch para sua feature
3. Commit suas mudanças
4. Push para a branch
5. Abra um Pull Request

## 📄 Licença

Este projeto está sob a licença MIT. Veja o arquivo LICENSE para detalhes.

## 📞 Suporte

Para dúvidas e suporte:
- Email: suporte@gestaoagencia.com
- Issues: GitHub Issues
- Documentação: Wiki do projeto

---

**Gestão de Agência** - Sistema completo para gestão de projetos e equipes.

