# 🚀 **DEPLOY BLACKBEANS - Sistema de Gestão de Agência**

## ✅ **CONFIGURADO PARA: gestao.blackbeans.com.br**

Sistema completo configurado especificamente para seu domínio na Cloudez!

---

## 🎯 **CONFIGURAÇÕES ESPECÍFICAS**

### **🌐 Domínio**
- **Principal**: `gestao.blackbeans.com.br`
- **Admin**: `https://gestao.blackbeans.com.br/admin`
- **API**: `https://gestao.blackbeans.com.br/api/`

### **📁 Estrutura no Servidor**
```
/srv/gestao.blackbeans.com.br/
├── .virtualenv/3.7/          # Ambiente Python
├── www/                      # Código da aplicação
├── etc/nginx/conf.d/         # Configuração Nginx
├── start_cloudez.sh          # Script de inicialização
└── gestao.service            # Serviço systemd
```

---

## 🚀 **PASSOS PARA DEPLOY**

### **1. NO PAINEL CLOUDEZ**
1. ✅ Criar aplicação Python
2. ✅ **Domínio**: `gestao.blackbeans.com.br`
3. ✅ Python 3.7
4. ✅ Aguardar criação

### **2. PREPARAR PROJETO**
```bash
# Compactar projeto
tar -czf gestao_agencia_blackbeans.tar.gz \
    --exclude=venv \
    --exclude=__pycache__ \
    --exclude=.git \
    --exclude=*.pyc \
    .
```

### **3. UPLOAD E DEPLOY**
```bash
# Via SSH
ssh usuario@seu-servidor-cloudez.com

# Navegar para diretório
cd /srv/gestao.blackbeans.com.br/

# Extrair arquivos
tar -xzf gestao_agencia_blackbeans.tar.gz -C www/

# Executar deploy
cd www/
./deploy_cloudez.sh
```

---

## ⚙️ **CONFIGURAÇÕES**

### **Variáveis de Ambiente**
```bash
# Copiar configuração específica
cp env.blackbeans .env

# Editar configurações
nano .env
```

### **Configurações Importantes**
- ✅ **SECRET_KEY**: Chave secreta segura
- ✅ **DEBUG**: False (produção)
- ✅ **ALLOWED_HOSTS**: gestao.blackbeans.com.br
- ✅ **EMAIL**: Configurado para blackbeans.com.br

---

## 🔧 **COMANDOS ÚTEIS**

### **Gerenciar Serviço**
```bash
# Status
sudo systemctl status gestao

# Reiniciar
sudo systemctl restart gestao

# Logs
sudo journalctl -u gestao -f
```

### **Gerenciar Aplicação**
```bash
# Ativar ambiente
source /srv/gestao.blackbeans.com.br/.virtualenv/3.7/bin/activate

# Navegar para aplicação
cd /srv/gestao.blackbeans.com.br/www/

# Comandos Django
python manage.py shell
python manage.py createsuperuser
python manage.py collectstatic
```

---

## 🌐 **DNS E DOMÍNIO**

### **Configuração DNS**
```
Tipo: A
Nome: gestao
Valor: IP_DO_SERVIDOR_CLOUDEZ
TTL: 300
```

### **SSL/HTTPS**
- ✅ SSL automático da Cloudez
- ✅ Certificado Let's Encrypt
- ✅ Redirecionamento HTTPS

---

## 📊 **MONITORAMENTO**

### **Logs**
```bash
# Logs do serviço
sudo journalctl -u gestao -f

# Logs do Nginx
sudo tail -f /var/log/nginx/access.log

# Logs do Django
tail -f /srv/gestao.blackbeans.com.br/www/django.log
```

### **Status**
```bash
# Verificar serviços
sudo systemctl status gestao nginx

# Verificar processos
ps aux | grep gunicorn
```

---

## 🎯 **CHECKLIST DE DEPLOY**

### ✅ **Pré-Deploy**
- [ ] Aplicação Python criada no painel Cloudez
- [ ] Domínio configurado: gestao.blackbeans.com.br
- [ ] Projeto testado localmente
- [ ] Arquivos compactados

### ✅ **Deploy**
- [ ] Arquivos enviados para servidor
- [ ] Script de deploy executado
- [ ] Variáveis de ambiente configuradas
- [ ] Serviço iniciado

### ✅ **Pós-Deploy**
- [ ] Site acessível: https://gestao.blackbeans.com.br
- [ ] Login funcionando: admin/admin123
- [ ] SSL funcionando
- [ ] Logs sem erros

---

## 🎉 **RESULTADO FINAL**

Após o deploy, você terá:
- 🌐 **Site**: https://gestao.blackbeans.com.br
- 🔐 **Admin**: https://gestao.blackbeans.com.br/admin
- ⚡ **Performance**: Gunicorn + Nginx
- 🔒 **Segurança**: SSL automático
- 📊 **Monitoramento**: Logs completos

---

## 🚀 **COMANDO FINAL**

No servidor Cloudez:
```bash
./deploy_cloudez.sh
```

**🎯 Pronto! Seu sistema estará rodando em https://gestao.blackbeans.com.br** 