# 🚀 **DEPLOY RÁPIDO - Sistema de Gestão de Agência**

## ⚡ **DEPLOY EM 5 MINUTOS**

### 🐳 **Com Docker (Recomendado)**

```bash
# 1. Clone o repositório
git clone <seu-repositorio>
cd gestao_agencia

# 2. Iniciar com Docker
docker-compose up -d

# 3. Configurar banco
docker-compose exec web python manage.py migrate
docker-compose exec web python manage.py createsuperuser

# 4. Acessar
# http://localhost:8000
```

### 🛠️ **Sem Docker (Tradicional)**

```bash
# 1. Ambiente virtual
python3 -m venv venv
source venv/bin/activate

# 2. Dependências
pip install -r requirements.txt

# 3. Configurar
python setup.py

# 4. Iniciar
python manage.py runserver
```

---

## 🎯 **OPÇÕES DE DEPLOY**

### 1. **Desenvolvimento Local** 🏠
```bash
# Usar docker-compose.dev.yml
docker-compose -f docker-compose.dev.yml up -d

# Acessos:
# Django: http://localhost:8000
# pgAdmin: http://localhost:5050
# Redis: localhost:6379
```

### 2. **Produção com Docker** 🚀
```bash
# Deploy automático
./deploy.sh production

# Ou manual
docker-compose up -d
```

### 3. **Deploy Automatizado (GitHub Actions)** 🤖
```bash
# Push para main = Deploy automático
git push origin main
```

---

## 🔧 **COMANDOS ÚTEIS**

### **Docker**
```bash
# Ver status
docker-compose ps

# Ver logs
docker-compose logs -f web

# Executar comando
docker-compose exec web python manage.py shell

# Backup banco
docker-compose exec db pg_dump -U postgres gestao_agencia > backup.sql

# Parar tudo
docker-compose down
```

### **Desenvolvimento**
```bash
# Migrações
python manage.py makemigrations
python manage.py migrate

# Superusuário
python manage.py createsuperuser

# Testes
python manage.py test

# Shell
python manage.py shell
```

---

## 🌐 **ACESSOS PADRÃO**

| Serviço | URL | Credenciais |
|---------|-----|-------------|
| **Django** | http://localhost:8000 | admin/admin123 |
| **Admin** | http://localhost:8000/admin | admin/admin123 |
| **pgAdmin** | http://localhost:5050 | admin@gestaoagencia.com/admin123 |
| **API** | http://localhost:8000/api/ | - |

---

## 🚨 **PROBLEMAS COMUNS**

### **Porta já em uso**
```bash
# Verificar o que está usando a porta
lsof -i :8000

# Parar processo
kill -9 <PID>
```

### **Docker não inicia**
```bash
# Verificar se Docker está rodando
docker --version
docker-compose --version

# Reconstruir imagens
docker-compose build --no-cache
```

### **Banco não conecta**
```bash
# Verificar se PostgreSQL está rodando
docker-compose ps db

# Ver logs do banco
docker-compose logs db
```

---

## 📊 **MONITORAMENTO**

### **Health Check**
```bash
# Verificar se está funcionando
curl http://localhost:8000/health/
```

### **Logs em Tempo Real**
```bash
# Todos os serviços
docker-compose logs -f

# Apenas Django
docker-compose logs -f web

# Apenas banco
docker-compose logs -f db
```

### **Recursos**
```bash
# Uso de CPU/Memória
docker stats

# Espaço em disco
docker system df
```

---

## 🔐 **SEGURANÇA**

### **Variáveis de Ambiente**
```bash
# Criar .env
SECRET_KEY=sua-chave-secreta
DEBUG=False
ALLOWED_HOSTS=localhost,127.0.0.1
```

### **SSL/HTTPS**
```bash
# Com Nginx (produção)
# Configurado automaticamente no docker-compose.yml
```

---

## 📞 **SUPORTE**

- **Documentação**: `GUIA_DEPLOY.md`
- **Issues**: GitHub Issues
- **Logs**: `docker-compose logs`
- **Backup**: `/opt/backups/`

---

## 🎉 **PRONTO!**

Seu sistema está rodando em:
- **Local**: http://localhost:8000
- **Admin**: http://localhost:8000/admin
- **API**: http://localhost:8000/api/

**Credenciais**: admin/admin123 