from django.contrib import admin
from .models import Board


@admin.register(Board)
class BoardAdmin(admin.ModelAdmin):
    """
    Admin para modelo Board.
    """
    list_display = ['nome', 'project', 'workspace', 'cliente', 'ordem', 'ativo']
    list_filter = ['ativo', 'project', 'workspace', 'cliente', 'created_at']
    search_fields = ['nome', 'descricao', 'project__nome', 'workspace__nome', 'cliente__nome']
    list_editable = ['ativo', 'ordem']
    ordering = ['project__nome', 'ordem', 'nome']
    
    fieldsets = (
        ('Informações Básicas', {
            'fields': ('nome', 'descricao', 'project', 'workspace', 'cliente', 'cor', 'ativo')
        }),
        ('Organização', {
            'fields': ('ordem',)
        }),
        ('Metadados', {
            'fields': ('created_at', 'updated_at'),
            'classes': ('collapse',)
        }),
    )
    
    readonly_fields = ['created_at', 'updated_at']
    
    def get_queryset(self, request):
        return super().get_queryset(request).select_related('project', 'workspace', 'cliente')

