from django import forms
from .models import Board
from project.models import Project


class BoardForm(forms.ModelForm):
    """
    Formulário para criação e edição de boards.
    """
    
    class Meta:
        model = Board
        fields = ['nome', 'descricao', 'project', 'cor', 'ativo']
        widgets = {
            'nome': forms.TextInput(attrs={
                'class': 'form-control',
                'placeholder': 'Nome do board'
            }),
            'descricao': forms.Textarea(attrs={
                'class': 'form-control',
                'rows': 3,
                'placeholder': 'Descrição do board'
            }),
            'project': forms.Select(attrs={
                'class': 'form-select'
            }),
            'cor': forms.TextInput(attrs={
                'class': 'form-control',
                'type': 'color',
                'value': '#28a745'
            }),
            'ativo': forms.CheckboxInput(attrs={
                'class': 'form-check-input'
            })
        }
    
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        
        # Filtrar apenas projetos ativos
        self.fields['project'].queryset = Project.objects.filter(ativo=True).order_by('nome')
        
        # Adiciona classes CSS aos labels
        for field_name, field in self.fields.items():
            if field_name != 'ativo':
                field.widget.attrs.update({'class': field.widget.attrs.get('class', '') + ' form-control'}) 