# Generated by Django 5.2.4 on 2025-07-17 23:15

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("client", "0001_initial"),
        ("project", "0001_initial"),
        ("workspace", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Board",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "nome",
                    models.CharField(
                        help_text="Nome do quadro", max_length=200, verbose_name="Nome"
                    ),
                ),
                (
                    "descricao",
                    models.TextField(
                        blank=True,
                        help_text="Descrição do quadro",
                        null=True,
                        verbose_name="Descrição",
                    ),
                ),
                (
                    "cor",
                    models.CharField(
                        default="#28a745",
                        help_text="Cor do quadro (formato hexadecimal)",
                        max_length=7,
                        verbose_name="Cor",
                    ),
                ),
                (
                    "ordem",
                    models.IntegerField(
                        default=0,
                        help_text="Ordem de exibição do quadro",
                        verbose_name="Ordem",
                    ),
                ),
                (
                    "ativo",
                    models.BooleanField(
                        default=True,
                        help_text="Indica se o quadro está ativo",
                        verbose_name="Ativo",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Criado em"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Atualizado em"),
                ),
                (
                    "cliente",
                    models.ForeignKey(
                        help_text="Cliente proprietário do quadro",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="boards",
                        to="client.client",
                        verbose_name="Cliente",
                    ),
                ),
                (
                    "project",
                    models.ForeignKey(
                        help_text="Projeto ao qual o quadro pertence",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="boards",
                        to="project.project",
                        verbose_name="Projeto",
                    ),
                ),
                (
                    "workspace",
                    models.ForeignKey(
                        help_text="Workspace ao qual o quadro pertence",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="boards",
                        to="workspace.workspace",
                        verbose_name="Workspace",
                    ),
                ),
            ],
            options={
                "verbose_name": "Quadro",
                "verbose_name_plural": "Quadros",
                "ordering": ["project", "ordem", "nome"],
                "unique_together": {("project", "nome")},
            },
        ),
    ]
