from django.db.models.signals import post_save
from django.dispatch import receiver
from .models import Board


@receiver(post_save, sender=Board)
def board_post_save(sender, instance, **kwargs):
    """
    Signal executado após salvar um board.
    """
    # Recalcular progresso do projeto
    if instance.project:
        instance.project.save()


# Importar signals no apps.py
def ready():
    import board.signals

