from django.urls import path
from . import views

app_name = 'board'

urlpatterns = [
    path('', views.board_list, name='list'),
    path('create/', views.board_create, name='create'),
    path('create-modal/', views.BoardCreateModalView.as_view(), name='create_modal'),
    path('<int:pk>/', views.board_detail, name='detail'),
    path('<int:pk>/edit-modal/', views.BoardUpdateModalView.as_view(), name='edit_modal'),
    path('<int:pk>/edit/', views.board_edit, name='edit'),
    path('<int:pk>/delete/', views.board_delete, name='delete'),
    path('<int:pk>/add-group/', views.board_add_group, name='add_group'),
    path('<int:pk>/add-task/', views.board_add_task, name='add_task'),
]
