from django.contrib import admin
from .models import Client


@admin.register(Client)
class ClientAdmin(admin.ModelAdmin):
    """
    Admin para modelo Client.
    """
    list_display = ['nome', 'cnpj', 'email', 'telefone', 'ativo', 'created_at']
    list_filter = ['ativo', 'created_at', 'updated_at']
    search_fields = ['nome', 'cnpj', 'email']
    list_editable = ['ativo']
    ordering = ['nome']
    
    fieldsets = (
        ('Informações Básicas', {
            'fields': ('nome', 'cnpj', 'ativo')
        }),
        ('Contato', {
            'fields': ('email', 'telefone', 'endereco')
        }),
        ('Metadados', {
            'fields': ('created_at', 'updated_at'),
            'classes': ('collapse',)
        }),
    )
    
    readonly_fields = ['created_at', 'updated_at']
    
    def get_queryset(self, request):
        return super().get_queryset(request).prefetch_related('workspaces', 'projects')

