# Generated by Django 5.2.4 on 2025-07-17 23:15

import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Client",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "nome",
                    models.CharField(
                        help_text="Nome do cliente", max_length=200, verbose_name="Nome"
                    ),
                ),
                (
                    "cnpj",
                    models.CharField(
                        help_text="CNPJ do cliente (formato: XX.XXX.XXX/XXXX-XX)",
                        max_length=18,
                        unique=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                message="CNPJ deve estar no formato XX.XXX.XXX/XXXX-XX",
                                regex="^\\d{2}\\.\\d{3}\\.\\d{3}\\/\\d{4}-\\d{2}$",
                            )
                        ],
                        verbose_name="CNPJ",
                    ),
                ),
                (
                    "email",
                    models.EmailField(
                        blank=True,
                        help_text="E-mail de contato do cliente",
                        max_length=254,
                        null=True,
                        verbose_name="E-mail",
                    ),
                ),
                (
                    "telefone",
                    models.CharField(
                        blank=True,
                        help_text="Telefone de contato do cliente",
                        max_length=20,
                        null=True,
                        verbose_name="Telefone",
                    ),
                ),
                (
                    "endereco",
                    models.TextField(
                        blank=True,
                        help_text="Endereço completo do cliente",
                        null=True,
                        verbose_name="Endereço",
                    ),
                ),
                (
                    "ativo",
                    models.BooleanField(
                        default=True,
                        help_text="Indica se o cliente está ativo",
                        verbose_name="Ativo",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Criado em"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Atualizado em"),
                ),
            ],
            options={
                "verbose_name": "Cliente",
                "verbose_name_plural": "Clientes",
                "ordering": ["nome"],
            },
        ),
    ]
