from django.urls import path
from . import views

app_name = 'client'

urlpatterns = [
    path('', views.ClientListView.as_view(), name='list'),
    path('create/', views.ClientCreateView.as_view(), name='create'),
    path('create-modal/', views.ClientCreateModalView.as_view(), name='create_modal'),
    path('<int:pk>/', views.ClientDetailView.as_view(), name='detail'),
    path('<int:pk>/edit-modal/', views.ClientUpdateModalView.as_view(), name='edit_modal'),
    path('<int:pk>/edit/', views.ClientUpdateView.as_view(), name='edit'),
    path('<int:pk>/delete/', views.ClientDeleteView.as_view(), name='delete'),
    path('<int:pk>/toggle-status/', views.ClientToggleStatusView.as_view(), name='toggle_status'),
]

