from django.contrib import admin
from .models import Area, Collaborator


@admin.register(Area)
class AreaAdmin(admin.ModelAdmin):
    """
    Admin para modelo Area.
    """
    list_display = ['nome', 'ativo', 'created_at']
    list_filter = ['ativo', 'created_at']
    search_fields = ['nome']
    list_editable = ['ativo']
    ordering = ['nome']


@admin.register(Collaborator)
class CollaboratorAdmin(admin.ModelAdmin):
    """
    Admin para modelo Collaborator.
    """
    list_display = ['nome', 'email', 'area', 'cargo', 'ativo', 'created_at']
    list_filter = ['ativo', 'area', 'created_at']
    search_fields = ['nome', 'email', 'cargo']
    list_editable = ['ativo']
    ordering = ['nome']
    
    fieldsets = (
        ('Informações Pessoais', {
            'fields': ('user', 'nome', 'email', 'telefone', 'ativo')
        }),
        ('Informações Profissionais', {
            'fields': ('area', 'cargo', 'data_admissao')
        }),
        ('Metadados', {
            'fields': ('created_at', 'updated_at'),
            'classes': ('collapse',)
        }),
    )
    
    readonly_fields = ['created_at', 'updated_at']
    
    def get_queryset(self, request):
        return super().get_queryset(request).select_related('user', 'area')

