# Generated by Django 5.2.4 on 2025-07-17 23:15

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Area",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "nome",
                    models.CharField(
                        help_text="Nome da área/departamento",
                        max_length=100,
                        unique=True,
                        verbose_name="Nome",
                    ),
                ),
                (
                    "descricao",
                    models.TextField(
                        blank=True,
                        help_text="Descrição da área",
                        null=True,
                        verbose_name="Descrição",
                    ),
                ),
                (
                    "ativo",
                    models.BooleanField(
                        default=True,
                        help_text="Indica se a área está ativa",
                        verbose_name="Ativo",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Criado em"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Atualizado em"),
                ),
            ],
            options={
                "verbose_name": "Área",
                "verbose_name_plural": "Áreas",
                "ordering": ["nome"],
            },
        ),
        migrations.CreateModel(
            name="Collaborator",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "nome",
                    models.CharField(
                        help_text="Nome completo do colaborador",
                        max_length=200,
                        verbose_name="Nome Completo",
                    ),
                ),
                (
                    "email",
                    models.EmailField(
                        help_text="E-mail do colaborador",
                        max_length=254,
                        unique=True,
                        verbose_name="E-mail",
                    ),
                ),
                (
                    "telefone",
                    models.CharField(
                        blank=True,
                        help_text="Telefone do colaborador",
                        max_length=20,
                        null=True,
                        verbose_name="Telefone",
                    ),
                ),
                (
                    "cargo",
                    models.CharField(
                        blank=True,
                        help_text="Cargo do colaborador",
                        max_length=100,
                        null=True,
                        verbose_name="Cargo",
                    ),
                ),
                (
                    "data_admissao",
                    models.DateField(
                        blank=True,
                        help_text="Data de admissão do colaborador",
                        null=True,
                        verbose_name="Data de Admissão",
                    ),
                ),
                (
                    "ativo",
                    models.BooleanField(
                        default=True,
                        help_text="Indica se o colaborador está ativo",
                        verbose_name="Ativo",
                    ),
                ),
                (
                    "foto",
                    models.ImageField(
                        blank=True,
                        help_text="Foto do colaborador",
                        null=True,
                        upload_to="collaborators/photos/",
                        verbose_name="Foto",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Criado em"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Atualizado em"),
                ),
                (
                    "area",
                    models.ForeignKey(
                        help_text="Área de trabalho do colaborador",
                        on_delete=django.db.models.deletion.PROTECT,
                        to="collaborator.area",
                        verbose_name="Área",
                    ),
                ),
                (
                    "user",
                    models.OneToOneField(
                        help_text="Usuário Django associado",
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Usuário",
                    ),
                ),
            ],
            options={
                "verbose_name": "Colaborador",
                "verbose_name_plural": "Colaboradores",
                "ordering": ["nome"],
            },
        ),
    ]
