from django.urls import path
from . import views

app_name = 'collaborator'

urlpatterns = [
    path('', views.collaborator_list, name='list'),
    path('create/', views.collaborator_create, name='create'),
    path('create-modal/', views.ColaboradorCreateModalView.as_view(), name='create_modal'),
    path('<int:pk>/', views.collaborator_detail, name='detail'),
    path('<int:pk>/edit-modal/', views.ColaboradorUpdateModalView.as_view(), name='edit_modal'),
    path('<int:pk>/edit/', views.collaborator_edit, name='edit'),
    path('<int:pk>/delete/', views.collaborator_delete, name='delete'),
    path('profile/', views.profile_view, name='profile'),
]

