#!/bin/bash

echo "============================================================"
echo "🚀 DEPLOY FINAL - SISTEMA DE GESTÃO DE AGÊNCIA"
echo "============================================================"

# Verificar se .env existe
if [ ! -f ".env" ]; then
    echo "❌ Arquivo .env não encontrado!"
    echo "📝 Copie env.example para .env e configure:"
    echo "   cp env.example .env"
    echo "   nano .env"
    exit 1
fi

# Carregar variáveis de ambiente
source .env

# Ativar ambiente virtual
echo "🔧 Ativando ambiente virtual..."
source venv/bin/activate

# Verificar configurações
echo "✅ Verificando configurações..."
python manage.py check --deploy

# Executar migrações
echo "🗄️ Executando migrações..."
python manage.py migrate

# Coletar arquivos estáticos
echo "📦 Coletando arquivos estáticos..."
python manage.py collectstatic --noinput

# Verificar se superusuário existe
echo "👤 Verificando superusuário..."
python manage.py shell -c "
from django.contrib.auth.models import User
if not User.objects.filter(is_superuser=True).exists():
    User.objects.create_superuser('admin', 'admin@gestaoagencia.com', 'admin123')
    print('Superusuário criado: admin/admin123')
else:
    print('Superusuário já existe')
"

echo ""
echo "============================================================"
echo "✅ DEPLOY FINALIZADO!"
echo "============================================================"
echo ""
echo "🌐 Para iniciar em produção:"
echo "   gunicorn gestao_agencia.wsgi:application --bind 0.0.0.0:8000"
echo ""
echo "🌐 Para desenvolvimento:"
echo "   python manage.py runserver"
echo ""
echo "🔐 Admin: admin/admin123"
echo "" 