"""
API URLs for gestao_agencia project.
"""
from django.urls import path, include
from rest_framework.routers import DefaultRouter

# Import ViewSets
from client.api import ClientViewSet
from collaborator.api import CollaboratorViewSet, AreaViewSet
from workspace.api import WorkspaceViewSet
from portfolio.api import PortfolioViewSet
from project.api import ProjectViewSet
from board.api import BoardViewSet
from task.api import TaskViewSet, GroupViewSet
from notification.api import NotificationViewSet

router = DefaultRouter()

# Register ViewSets
router.register(r'clients', ClientViewSet)
router.register(r'areas', AreaViewSet)
router.register(r'collaborators', CollaboratorViewSet)
router.register(r'workspaces', WorkspaceViewSet)
router.register(r'portfolios', PortfolioViewSet)
router.register(r'projects', ProjectViewSet)
router.register(r'boards', BoardViewSet)
router.register(r'groups', GroupViewSet)
router.register(r'tasks', TaskViewSet)
router.register(r'notifications', NotificationViewSet)

urlpatterns = [
    path('', include(router.urls)),
    path('auth/', include('rest_framework.urls')),
]

