from django.shortcuts import redirect
from django.contrib import messages
from django.contrib.auth.decorators import login_required
from functools import wraps


def superuser_required(view_func):
    """
    Decorator para verificar se o usuário é superuser.
    """
    @wraps(view_func)
    def wrapper(request, *args, **kwargs):
        if not request.user.is_superuser:
            messages.error(request, "Acesso negado. Apenas administradores podem realizar esta ação.")
            return redirect('home')
        return view_func(request, *args, **kwargs)
    return wrapper


def superuser_or_readonly(view_func):
    """
    Decorator que permite superuser fazer tudo, mas usuários normais só podem visualizar.
    """
    @wraps(view_func)
    def wrapper(request, *args, **kwargs):
        if request.method in ['POST', 'PUT', 'DELETE'] and not request.user.is_superuser:
            messages.error(request, "Acesso negado. Apenas administradores podem realizar esta ação.")
            return redirect('home')
        return view_func(request, *args, **kwargs)
    return wrapper 