from django.shortcuts import redirect
from django.contrib import messages
from django.contrib.auth.mixins import LoginRequiredMixin


class SuperuserRequiredMixin:
    """
    Mixin para verificar se o usuário é superuser.
    """
    def dispatch(self, request, *args, **kwargs):
        if not request.user.is_superuser:
            messages.error(request, "Acesso negado. Apenas administradores podem realizar esta ação.")
            return redirect('home')
        return super().dispatch(request, *args, **kwargs)


class SuperuserOrReadonlyMixin:
    """
    Mixin que permite superuser fazer tudo, mas usuários normais só podem visualizar.
    """
    def dispatch(self, request, *args, **kwargs):
        if request.method in ['POST', 'PUT', 'DELETE'] and not request.user.is_superuser:
            messages.error(request, "Acesso negado. Apenas administradores podem realizar esta ação.")
            return redirect('home')
        return super().dispatch(request, *args, **kwargs) 