"""
URL configuration for gestao_agencia project.

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/5.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.contrib import admin
from django.urls import path, include
from django.conf import settings
from django.conf.urls.static import static
from . import views

urlpatterns = [
    path('admin/', admin.site.urls),
    
    # Home
    path('', views.home, name='home'),
    
    # App URLs
    path('clients/', include('client.urls')),
    path('collaborators/', include('collaborator.urls')),
    path('workspaces/', include('workspace.urls')),
    path('portfolios/', include('portfolio.urls')),
    path('projects/', include('project.urls')),
    path('boards/', include('board.urls')),
    path('tasks/', include('task.urls')),
    path('notifications/', include('notification.urls')),
    path('permissions/', include('permissions.urls')),
    path('system-logs/', include('system_logs.urls')),
    
    # API URLs
    path('api/', include('gestao_agencia.api_urls')),
    
    # Authentication URLs
    path('accounts/', include('django.contrib.auth.urls')),
]

# Serve media files in development
if settings.DEBUG:
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
    urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)

