# Generated by Django 5.2.4 on 2025-07-17 23:15

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("collaborator", "0001_initial"),
        ("task", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Notification",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "tipo",
                    models.CharField(
                        choices=[
                            ("responsavel_adicionado", "Responsável Adicionado"),
                            ("tarefa_atrasada", "Tarefa Atrasada"),
                            ("tarefa_concluida", "Tarefa Concluída"),
                            ("prazo_proximo", "Prazo Próximo"),
                            ("dependencia_concluida", "Dependência Concluída"),
                        ],
                        help_text="Tipo da notificação",
                        max_length=30,
                        verbose_name="Tipo",
                    ),
                ),
                (
                    "titulo",
                    models.CharField(
                        help_text="Título da notificação",
                        max_length=200,
                        verbose_name="Título",
                    ),
                ),
                (
                    "mensagem",
                    models.TextField(
                        help_text="Conteúdo da notificação", verbose_name="Mensagem"
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("pendente", "Pendente"),
                            ("enviada", "Enviada"),
                            ("erro", "Erro"),
                        ],
                        default="pendente",
                        help_text="Status da notificação",
                        max_length=10,
                        verbose_name="Status",
                    ),
                ),
                (
                    "enviada_em",
                    models.DateTimeField(
                        blank=True,
                        help_text="Data e hora do envio",
                        null=True,
                        verbose_name="Enviada em",
                    ),
                ),
                (
                    "erro_envio",
                    models.TextField(
                        blank=True,
                        help_text="Detalhes do erro caso o envio falhe",
                        null=True,
                        verbose_name="Erro de Envio",
                    ),
                ),
                (
                    "lida",
                    models.BooleanField(
                        default=False,
                        help_text="Indica se a notificação foi lida",
                        verbose_name="Lida",
                    ),
                ),
                (
                    "lida_em",
                    models.DateTimeField(
                        blank=True,
                        help_text="Data e hora da leitura",
                        null=True,
                        verbose_name="Lida em",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Criado em"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Atualizado em"),
                ),
                (
                    "destinatario",
                    models.ForeignKey(
                        help_text="Colaborador que receberá a notificação",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="notifications",
                        to="collaborator.collaborator",
                        verbose_name="Destinatário",
                    ),
                ),
                (
                    "tarefa",
                    models.ForeignKey(
                        help_text="Tarefa relacionada à notificação",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="notifications",
                        to="task.task",
                        verbose_name="Tarefa",
                    ),
                ),
            ],
            options={
                "verbose_name": "Notificação",
                "verbose_name_plural": "Notificações",
                "ordering": ["-created_at"],
            },
        ),
    ]
