from django.core.management.base import BaseCommand
from django.contrib.auth.models import User
from django.template.loader import render_to_string
from django.test import RequestFactory
from workspace.models import Workspace


class Command(BaseCommand):
    help = 'Debuga o que está sendo renderizado nos templates'

    def add_arguments(self, parser):
        parser.add_argument('--username', type=str, help='Nome do usuário para testar')

    def handle(self, *args, **options):
        username = options['username']
        
        try:
            user = User.objects.get(username=username)
        except User.DoesNotExist:
            self.stdout.write(
                self.style.ERROR(f'❌ Usuário "{username}" não encontrado!')
            )
            return

        self.stdout.write(f'=== DEBUG TEMPLATE: {username} ===')
        self.stdout.write(f'👤 Usuário: {user.get_full_name() or user.username}')
        self.stdout.write(f'🔑 Superuser: {"✅ Sim" if user.is_superuser else "❌ Não"}')
        self.stdout.write('')

        # Criar request factory
        factory = RequestFactory()
        request = factory.get('/')
        request.user = user
        
        # Buscar dados reais
        workspaces = Workspace.objects.all()[:2]
        
        # Contexto
        context = {
            'user': user,
            'workspaces': workspaces,
            'page_obj': workspaces,
            'is_paginated': False,
            'search': '',
            'status': '',
            'cliente_id': '',
        }
        
        # Renderizar template
        rendered = render_to_string('workspace/list.html', context, request=request)
        
        # Procurar por botões específicos
        self.stdout.write('🔍 PROCURANDO POR BOTÕES:')
        self.stdout.write('')
        
        # Verificar botão "Novo Workspace"
        if 'Novo Workspace' in rendered:
            self.stdout.write('❌ "Novo Workspace" encontrado')
        else:
            self.stdout.write('✅ "Novo Workspace" NÃO encontrado')
            
        # Verificar botão "Editar"
        if 'edit-workspace-btn' in rendered:
            self.stdout.write('❌ "edit-workspace-btn" encontrado')
        else:
            self.stdout.write('✅ "edit-workspace-btn" NÃO encontrado')
            
        # Verificar botão "Excluir"
        if 'delete-btn' in rendered:
            self.stdout.write('❌ "delete-btn" encontrado')
        else:
            self.stdout.write('✅ "delete-btn" NÃO encontrado')
            
        # Verificar botão "Ver"
        if 'btn-outline-primary' in rendered:
            self.stdout.write('✅ "btn-outline-primary" (Ver) encontrado')
        else:
            self.stdout.write('❌ "btn-outline-primary" (Ver) NÃO encontrado')
        
        self.stdout.write('')
        self.stdout.write('📋 RESUMO:')
        if user.is_superuser:
            self.stdout.write('  Superuser deve ver todos os botões')
        else:
            self.stdout.write('  Usuário normal deve ver apenas "Ver"')
        
        self.stdout.write('')
        self.stdout.write('�� DEBUG CONCLUÍDO!') 