from django.core.management.base import BaseCommand
from django.contrib.auth.models import User
from django.template.loader import render_to_string
from django.test import RequestFactory
from workspace.models import Workspace


class Command(BaseCommand):
    help = 'Testa exatamente o que está sendo renderizado no template'

    def add_arguments(self, parser):
        parser.add_argument('--username', type=str, help='Nome do usuário para testar')

    def handle(self, *args, **options):
        username = options['username']
        
        try:
            user = User.objects.get(username=username)
        except User.DoesNotExist:
            self.stdout.write(
                self.style.ERROR(f'❌ Usuário "{username}" não encontrado!')
            )
            return

        self.stdout.write(f'=== TESTE EXATO: {username} ===')
        self.stdout.write(f'👤 Usuário: {user.get_full_name() or user.username}')
        self.stdout.write(f'🔑 Superuser: {"✅ Sim" if user.is_superuser else "❌ Não"}')
        self.stdout.write('')

        # Criar request factory
        factory = RequestFactory()
        request = factory.get('/')
        request.user = user
        
        # Buscar dados reais
        workspaces = Workspace.objects.all()[:1]  # Apenas 1 workspace
        
        # Contexto
        context = {
            'user': user,
            'workspaces': workspaces,
            'page_obj': workspaces,
            'is_paginated': False,
            'search': '',
            'status': '',
            'cliente_id': '',
        }
        
        # Renderizar template
        rendered = render_to_string('workspace/list.html', context, request=request)
        
        # Procurar pela seção específica dos botões
        self.stdout.write('🔍 PROCURANDO SEÇÃO DE BOTÕES:')
        self.stdout.write('')
        
        # Encontrar a seção dos botões
        if 'btn-group w-100' in rendered:
            start = rendered.find('btn-group w-100')
            end = rendered.find('</div>', start) + 6
            button_section = rendered[start:end]
            
            self.stdout.write('📋 SEÇÃO DE BOTÕES ENCONTRADA:')
            self.stdout.write('---')
            self.stdout.write(button_section)
            self.stdout.write('---')
            
            # Verificar se a condição está presente
            if '{% if user.is_superuser %}' in button_section:
                self.stdout.write('✅ Condição {% if user.is_superuser %} encontrada')
            else:
                self.stdout.write('❌ Condição {% if user.is_superuser %} NÃO encontrada')
                
            if '{% endif %}' in button_section:
                self.stdout.write('✅ {% endif %} encontrado')
            else:
                self.stdout.write('❌ {% endif %} NÃO encontrado')
                
            # Verificar se os botões estão dentro da condição
            if 'edit-workspace-btn' in button_section:
                if user.is_superuser:
                    self.stdout.write('✅ Botão editar visível (superuser)')
                else:
                    self.stdout.write('❌ Botão editar visível (usuário normal) - PROBLEMA!')
            else:
                if user.is_superuser:
                    self.stdout.write('❌ Botão editar NÃO visível (superuser) - PROBLEMA!')
                else:
                    self.stdout.write('✅ Botão editar NÃO visível (usuário normal)')
                    
        else:
            self.stdout.write('❌ Seção de botões NÃO encontrada')
        
        self.stdout.write('')
        self.stdout.write('🎯 TESTE EXATO CONCLUÍDO!') 