from django.core.management.base import BaseCommand
from django.contrib.auth.models import User
from django.template import Template, Context


class Command(BaseCommand):
    help = 'Testa especificamente a condição user.is_superuser'

    def add_arguments(self, parser):
        parser.add_argument('--username', type=str, help='Nome do usuário para testar')

    def handle(self, *args, **options):
        username = options['username']
        
        try:
            user = User.objects.get(username=username)
        except User.DoesNotExist:
            self.stdout.write(
                self.style.ERROR(f'❌ Usuário "{username}" não encontrado!')
            )
            return

        self.stdout.write(f'=== TESTE CONDITION: {username} ===')
        self.stdout.write(f'👤 Usuário: {user.get_full_name() or user.username}')
        self.stdout.write(f'🔑 Superuser: {"✅ Sim" if user.is_superuser else "❌ Não"}')
        self.stdout.write('')

        # Testar template simples
        template_string = """
        {% if user.is_superuser %}
            SUPERUSER CONTENT
        {% else %}
            NORMAL USER CONTENT
        {% endif %}
        """
        
        template = Template(template_string)
        context = Context({'user': user})
        rendered = template.render(context)
        
        self.stdout.write('🔍 TESTANDO CONDITION:')
        self.stdout.write(f'  Template renderizado: "{rendered.strip()}"')
        
        if user.is_superuser:
            expected = "SUPERUSER CONTENT"
        else:
            expected = "NORMAL USER CONTENT"
            
        if rendered.strip() == expected:
            self.stdout.write(f'  ✅ Resultado correto: "{expected}"')
        else:
            self.stdout.write(f'  ❌ Resultado incorreto. Esperado: "{expected}"')
        
        self.stdout.write('')
        self.stdout.write('�� TESTE CONCLUÍDO!') 