# Generated by Django 5.2.4 on 2025-07-24 22:39

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("collaborator", "0001_initial"),
        ("contenttypes", "0002_remove_content_type_name"),
        ("workspace", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="VisibilityPermission",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "permission_type",
                    models.CharField(
                        choices=[
                            ("workspace", "Workspace"),
                            ("portfolio", "Portfolio"),
                            ("project", "Projeto"),
                            ("board", "Quadro"),
                        ],
                        help_text="Nível hierárquico da permissão",
                        max_length=20,
                        verbose_name="Tipo de Permissão",
                    ),
                ),
                (
                    "access_type",
                    models.CharField(
                        choices=[("allow", "Permitir"), ("deny", "Negar")],
                        default="allow",
                        help_text="Se permite ou nega o acesso",
                        max_length=10,
                        verbose_name="Tipo de Acesso",
                    ),
                ),
                (
                    "scope_type",
                    models.CharField(
                        choices=[("collaborator", "Colaborador"), ("area", "Área")],
                        help_text="Se a permissão é para colaborador específico ou área",
                        max_length=20,
                        verbose_name="Tipo de Escopo",
                    ),
                ),
                ("object_id", models.PositiveIntegerField(verbose_name="ID do Objeto")),
                (
                    "inherit_from_parent",
                    models.BooleanField(
                        default=True,
                        help_text="Se deve herdar permissões do nível superior",
                        verbose_name="Herdar do Pai",
                    ),
                ),
                (
                    "override_parent",
                    models.BooleanField(
                        default=False,
                        help_text="Se esta permissão sobrescreve a do nível superior",
                        verbose_name="Sobrescrever Pai",
                    ),
                ),
                (
                    "ativo",
                    models.BooleanField(
                        default=True,
                        help_text="Indica se a permissão está ativa",
                        verbose_name="Ativo",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Criado em"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Atualizado em"),
                ),
                (
                    "area",
                    models.ForeignKey(
                        blank=True,
                        help_text="Área específica para esta permissão",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="collaborator.area",
                        verbose_name="Área",
                    ),
                ),
                (
                    "collaborator",
                    models.ForeignKey(
                        blank=True,
                        help_text="Colaborador específico para esta permissão",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="collaborator.collaborator",
                        verbose_name="Colaborador",
                    ),
                ),
                (
                    "content_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                        verbose_name="Tipo de Conteúdo",
                    ),
                ),
            ],
            options={
                "verbose_name": "Permissão de Visão",
                "verbose_name_plural": "Permissões de Visão",
                "ordering": ["permission_type", "scope_type", "content_type"],
                "unique_together": {
                    (
                        "permission_type",
                        "scope_type",
                        "collaborator",
                        "area",
                        "content_type",
                        "object_id",
                    )
                },
            },
        ),
        migrations.CreateModel(
            name="WorkspaceAccess",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "can_manage",
                    models.BooleanField(
                        default=False,
                        help_text="Se pode gerenciar o workspace e seus elementos",
                        verbose_name="Pode Gerenciar",
                    ),
                ),
                ("ativo", models.BooleanField(default=True, verbose_name="Ativo")),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Criado em"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Atualizado em"),
                ),
                (
                    "area",
                    models.ForeignKey(
                        blank=True,
                        help_text="Área inteira com acesso ao workspace",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="collaborator.area",
                        verbose_name="Área",
                    ),
                ),
                (
                    "collaborator",
                    models.ForeignKey(
                        blank=True,
                        help_text="Colaborador específico com acesso ao workspace",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="collaborator.collaborator",
                        verbose_name="Colaborador",
                    ),
                ),
                (
                    "workspace",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="access_controls",
                        to="workspace.workspace",
                        verbose_name="Workspace",
                    ),
                ),
            ],
            options={
                "verbose_name": "Acesso ao Workspace",
                "verbose_name_plural": "Acessos ao Workspace",
                "unique_together": {
                    ("workspace", "area"),
                    ("workspace", "collaborator"),
                },
            },
        ),
    ]
