from django.urls import path
from . import views

app_name = 'permissions'

urlpatterns = [
    # Dashboard de permissões
    path('dashboard/', views.permission_dashboard, name='dashboard'),
    
    # Gerenciamento de permissões de workspace (ambas as formas)
    path('workspace/<int:workspace_id>/', views.workspace_permissions, name='workspace_permissions'),
    path('workspaces/<int:workspace_id>/', views.workspace_permissions, name='workspace_permissions_plural'),
    path('workspace/<int:workspace_id>/add/', views.add_workspace_permission, name='add_workspace_permission'),
    path('workspace/<int:workspace_id>/remove/<int:permission_id>/', views.remove_workspace_permission, name='remove_workspace_permission'),
    
    # Gerenciamento de permissões de portfolio
    path('portfolio/<int:portfolio_id>/', views.portfolio_permissions, name='portfolio_permissions'),
    path('portfolio/<int:portfolio_id>/add/', views.add_portfolio_permission, name='add_portfolio_permission'),
    path('portfolio/<int:portfolio_id>/remove/<int:permission_id>/', views.remove_portfolio_permission, name='remove_portfolio_permission'),
    
    # Gerenciamento de permissões de project
    path('project/<int:project_id>/', views.project_permissions, name='project_permissions'),
    path('project/<int:project_id>/add/', views.add_project_permission, name='add_project_permission'),
    path('project/<int:project_id>/remove/<int:permission_id>/', views.remove_project_permission, name='remove_project_permission'),
    
    # Gerenciamento de permissões de board
    path('board/<int:board_id>/', views.board_permissions, name='board_permissions'),
    path('board/<int:board_id>/add/', views.add_board_permission, name='add_board_permission'),
    path('board/<int:board_id>/remove/<int:permission_id>/', views.remove_board_permission, name='remove_board_permission'),
    
    # Gerenciamento em lote
    path('bulk/', views.bulk_permission_manager, name='bulk_manager'),
] 