from django.contrib import admin
from .models import Portfolio


@admin.register(Portfolio)
class PortfolioAdmin(admin.ModelAdmin):
    """
    Admin para modelo Portfolio.
    """
    list_display = ['nome', 'workspace', 'cliente', 'ativo', 'created_at']
    list_filter = ['ativo', 'workspace', 'cliente', 'created_at']
    search_fields = ['nome', 'descricao', 'workspace__nome', 'cliente__nome']
    list_editable = ['ativo']
    ordering = ['workspace__nome', 'nome']
    
    fieldsets = (
        ('Informações Básicas', {
            'fields': ('nome', 'descricao', 'workspace', 'cliente', 'ativo')
        }),
        ('Metadados', {
            'fields': ('created_at', 'updated_at'),
            'classes': ('collapse',)
        }),
    )
    
    readonly_fields = ['created_at', 'updated_at']
    
    def get_queryset(self, request):
        return super().get_queryset(request).select_related('workspace', 'cliente')

