from django import forms
from .models import Portfolio
from client.models import Client
from workspace.models import Workspace


class PortfolioForm(forms.ModelForm):
    """
    Formulário para criação e edição de portfolios.
    """
    
    class Meta:
        model = Portfolio
        fields = ['nome', 'descricao', 'workspace', 'status', 'ativo']
        widgets = {
            'nome': forms.TextInput(attrs={
                'class': 'form-control',
                'placeholder': 'Nome do portfolio'
            }),
            'descricao': forms.Textarea(attrs={
                'class': 'form-control',
                'rows': 3,
                'placeholder': 'Descrição do portfolio'
            }),
            'workspace': forms.Select(attrs={
                'class': 'form-select'
            }),
            'status': forms.Select(attrs={
                'class': 'form-select'
            }),
            'ativo': forms.CheckboxInput(attrs={
                'class': 'form-check-input'
            })
        }
    
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        
        # Filtrar apenas workspaces ativos
        self.fields['workspace'].queryset = Workspace.objects.filter(ativo=True).order_by('nome')
        
        # Adiciona classes CSS aos labels
        for field_name, field in self.fields.items():
            if field_name != 'ativo':
                field.widget.attrs.update({'class': field.widget.attrs.get('class', '') + ' form-control'}) 