# Generated by Django 5.2.4 on 2025-07-17 23:15

import django.core.validators
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("client", "0001_initial"),
        ("workspace", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Portfolio",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "nome",
                    models.CharField(
                        help_text="Nome do portfolio",
                        max_length=200,
                        verbose_name="Nome",
                    ),
                ),
                (
                    "descricao",
                    models.TextField(
                        blank=True,
                        help_text="Descrição do portfolio",
                        null=True,
                        verbose_name="Descrição",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("planejamento", "Planejamento"),
                            ("em_andamento", "Em Andamento"),
                            ("pausado", "Pausado"),
                            ("concluido", "Concluído"),
                            ("cancelado", "Cancelado"),
                        ],
                        default="planejamento",
                        help_text="Status atual do portfolio",
                        max_length=20,
                        verbose_name="Status",
                    ),
                ),
                (
                    "risco",
                    models.CharField(
                        choices=[
                            ("baixo", "Baixo"),
                            ("medio", "Médio"),
                            ("alto", "Alto"),
                            ("critico", "Crítico"),
                        ],
                        default="baixo",
                        help_text="Nível de risco do portfolio",
                        max_length=10,
                        verbose_name="Risco",
                    ),
                ),
                (
                    "prazo",
                    models.DateField(
                        blank=True,
                        help_text="Data limite para conclusão do portfolio",
                        null=True,
                        verbose_name="Prazo",
                    ),
                ),
                (
                    "progresso",
                    models.IntegerField(
                        default=0,
                        help_text="Percentual de progresso do portfolio (0-100)",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(100),
                        ],
                        verbose_name="Progresso (%)",
                    ),
                ),
                (
                    "prioridade",
                    models.CharField(
                        choices=[
                            ("baixa", "Baixa"),
                            ("media", "Média"),
                            ("alta", "Alta"),
                            ("urgente", "Urgente"),
                        ],
                        default="media",
                        help_text="Prioridade do portfolio",
                        max_length=10,
                        verbose_name="Prioridade",
                    ),
                ),
                (
                    "rentabilidade",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="Rentabilidade esperada/realizada do portfolio",
                        max_digits=10,
                        null=True,
                        verbose_name="Rentabilidade",
                    ),
                ),
                (
                    "orcamento",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="Orçamento total do portfolio",
                        max_digits=12,
                        null=True,
                        verbose_name="Orçamento",
                    ),
                ),
                (
                    "ativo",
                    models.BooleanField(
                        default=True,
                        help_text="Indica se o portfolio está ativo",
                        verbose_name="Ativo",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Criado em"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Atualizado em"),
                ),
                (
                    "cliente",
                    models.ForeignKey(
                        help_text="Cliente proprietário do portfolio",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="portfolios",
                        to="client.client",
                        verbose_name="Cliente",
                    ),
                ),
                (
                    "workspace",
                    models.ForeignKey(
                        help_text="Workspace ao qual o portfolio pertence",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="portfolios",
                        to="workspace.workspace",
                        verbose_name="Workspace",
                    ),
                ),
            ],
            options={
                "verbose_name": "Portfolio",
                "verbose_name_plural": "Portfolios",
                "ordering": ["workspace", "nome"],
                "unique_together": {("workspace", "nome")},
            },
        ),
    ]
